/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.CommentsTableFactory;
import com.github.pjfanning.poi.xssf.streaming.FactoryMismatchException;
import com.github.pjfanning.poi.xssf.streaming.SharedStringsTableFactory;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLRelation;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.usermodel.XSSFFactory;
import org.apache.poi.xssf.usermodel.XSSFRelation;

public class CustomXSSFFactory
extends XSSFFactory {
    private final CommentsTableFactory commentsTableFactory;
    private final SharedStringsTableFactory sharedStringsFactory;

    public static Builder builder() {
        return new Builder();
    }

    private CustomXSSFFactory(CommentsTableFactory commentsTableFactory, SharedStringsTableFactory sharedStringsFactory) {
        this.commentsTableFactory = commentsTableFactory;
        this.sharedStringsFactory = sharedStringsFactory;
    }

    @Override
    public POIXMLDocumentPart newDocumentPart(POIXMLRelation descriptor) {
        if (XSSFRelation.SHARED_STRINGS.getRelation().equals(descriptor.getRelation()) && this.sharedStringsFactory != null) {
            SharedStrings sharedStrings = this.sharedStringsFactory.createSharedStringsTable();
            if (sharedStrings instanceof POIXMLDocumentPart) {
                return (POIXMLDocumentPart)((Object)sharedStrings);
            }
            if (sharedStrings != null) {
                throw new FactoryMismatchException("Shared Strings Table must implement POIXMLDocumentPart");
            }
            return null;
        }
        if (XSSFRelation.SHEET_COMMENTS.getRelation().equals(descriptor.getRelation()) && this.commentsTableFactory != null) {
            Comments commentsTable = this.commentsTableFactory.createCommentsTable();
            if (commentsTable instanceof POIXMLDocumentPart) {
                return (POIXMLDocumentPart)((Object)commentsTable);
            }
            if (commentsTable != null) {
                throw new FactoryMismatchException("Comments Table must implement POIXMLDocumentPart");
            }
            return null;
        }
        return super.newDocumentPart(descriptor);
    }

    public static class Builder {
        private CommentsTableFactory commentsTableFactory;
        private SharedStringsTableFactory sharedStringsFactory;

        public Builder commentsTableFactory(CommentsTableFactory commentsTableFactory) {
            this.commentsTableFactory = commentsTableFactory;
            return this;
        }

        public Builder sharedStringsFactory(SharedStringsTableFactory sharedStringsFactory) {
            this.sharedStringsFactory = sharedStringsFactory;
            return this;
        }

        public CustomXSSFFactory build() {
            return new CustomXSSFFactory(this.commentsTableFactory, this.sharedStringsFactory);
        }
    }
}

