/*
 * Decompiled with CFR 0.152.
 */
package com.crealytics.spark.v2.excel;

import com.crealytics.spark.v2.excel.DataLocator;
import com.crealytics.spark.v2.excel.DataLocator$;
import com.crealytics.spark.v2.excel.ExcelHelper$;
import com.crealytics.spark.v2.excel.ExcelOptions;
import com.crealytics.spark.v2.excel.PlainNumberFormat$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import shadeio.poi.ss.SpreadsheetVersion;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.CellType;
import shadeio.poi.ss.usermodel.DataFormatter;
import shadeio.poi.ss.usermodel.Workbook;
import shadeio.poi.ss.usermodel.WorkbookFactory;
import shadeio.poi.ss.util.AreaReference;
import shadeio.poi.ss.util.CellReference;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001\u0002\b\u0010\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006M\u0001!\ta\n\u0005\tU\u0001A)\u0019!C\u0005W!)!\b\u0001C\u0001w!)A\n\u0001C\u0001\u001b\")A\r\u0001C\u0001K\")A\u000f\u0001C\u0001k\")\u0011\u0010\u0001C\u0001u\u001e9\u00111A\b\t\u0002\u0005\u0015aA\u0002\b\u0010\u0011\u0003\t9\u0001\u0003\u0004'\u0015\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003\u0017QA\u0011AA\u0007\u0011\u001d\t\tB\u0003C\u0001\u0003'\u00111\"\u0012=dK2DU\r\u001c9fe*\u0011\u0001#E\u0001\u0006Kb\u001cW\r\u001c\u0006\u0003%M\t!A\u001e\u001a\u000b\u0005Q)\u0012!B:qCJ\\'B\u0001\f\u0018\u0003)\u0019'/Z1msRL7m\u001d\u0006\u00021\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\u000f=\u0004H/[8ogB\u00111\u0005J\u0007\u0002\u001f%\u0011Qe\u0004\u0002\r\u000bb\u001cW\r\\(qi&|gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005!J\u0003CA\u0012\u0001\u0011\u0015\t#\u00011\u0001#\u00035!\u0017\r^1G_Jl\u0017\r\u001e;feV\tA\u0006\u0005\u0002.q5\taF\u0003\u00020a\u0005IQo]3s[>$W\r\u001c\u0006\u0003cI\n!a]:\u000b\u0005M\"\u0014a\u00019pS*\u0011QGN\u0001\u0007CB\f7\r[3\u000b\u0003]\n1a\u001c:h\u0013\tIdFA\u0007ECR\fgi\u001c:nCR$XM]\u0001\u0014g\u00064WmQ3mYN#(/\u001b8h-\u0006dW/\u001a\u000b\u0003y\u001d\u0003\"!\u0010#\u000f\u0005y\u0012\u0005CA \u001e\u001b\u0005\u0001%BA!\u001a\u0003\u0019a$o\\8u}%\u00111)H\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002D;!)\u0001\n\u0002a\u0001\u0013\u0006!1-\u001a7m!\ti#*\u0003\u0002L]\t!1)\u001a7m\u0003-9W\r^,pe.\u0014wn\\6\u0015\u00079\u000b&\f\u0005\u0002.\u001f&\u0011\u0001K\f\u0002\t/>\u00148NY8pW\")!+\u0002a\u0001'\u0006!1m\u001c8g!\t!\u0006,D\u0001V\u0015\t\u0011fK\u0003\u0002Xi\u00051\u0001.\u00193p_BL!!W+\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015YV\u00011\u0001]\u0003\r)(/\u001b\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\f1A\\3u\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\u0007U\u0013\u0016*A\u0004hKR\u0014vn^:\u0015\u0007\u0019\u00148\u000fE\u0002hY>t!\u0001\u001b6\u000f\u0005}J\u0017\"\u0001\u0010\n\u0005-l\u0012a\u00029bG.\fw-Z\u0005\u0003[:\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003Wv\u00012a\u001a9J\u0013\t\thN\u0001\u0004WK\u000e$xN\u001d\u0005\u0006%\u001a\u0001\ra\u0015\u0005\u00067\u001a\u0001\r\u0001X\u0001\u000fO\u0016$8i\u001c7v[:t\u0015-\\3t)\t1x\u000fE\u0002harBQ\u0001_\u0004A\u0002=\f\u0001BZ5sgR\u0014vn^\u0001\u0013a\u0006\u00148/\u001a3SC:<W-\u00113ee\u0016\u001c8\u000fF\u0001|!\tax0D\u0001~\u0015\tq\b'\u0001\u0003vi&d\u0017bAA\u0001{\ni\u0011I]3b%\u00164WM]3oG\u0016\f1\"\u0012=dK2DU\r\u001c9feB\u00111EC\n\u0003\u0015m!\"!!\u0002\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007!\ny\u0001C\u0003\"\u0019\u0001\u0007!%\u0001\nd_:4\u0017nZ;sKB\u0013xN^5eKJ\u001cHCAA\u000b!\ra\u0012qC\u0005\u0004\u00033i\"\u0001B+oSR\u0004")
public class ExcelHelper {
    private DataFormatter dataFormatter;
    private final ExcelOptions options;
    private volatile boolean bitmap$0;

    public static void configureProviders() {
        ExcelHelper$.MODULE$.configureProviders();
    }

    public static ExcelHelper apply(ExcelOptions options) {
        return ExcelHelper$.MODULE$.apply(options);
    }

    /*
     * WARNING - void declaration
     */
    private DataFormatter dataFormatter$lzycompute() {
        ExcelHelper excelHelper = this;
        synchronized (excelHelper) {
            if (!this.bitmap$0) {
                void var2_2;
                DataFormatter r = new DataFormatter();
                if (this.options.usePlainNumberFormat()) {
                    PlainNumberFormat$ plainNumberFormat = PlainNumberFormat$.MODULE$;
                    r.addFormat("General", plainNumberFormat);
                    r.addFormat("@", plainNumberFormat);
                }
                this.dataFormatter = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.dataFormatter;
    }

    private DataFormatter dataFormatter() {
        return !this.bitmap$0 ? this.dataFormatter$lzycompute() : this.dataFormatter;
    }

    public String safeCellStringValue(Cell cell) {
        String string;
        CellType cellType = cell.getCellType();
        boolean bl = ((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType);
        if (bl) {
            string = "";
        } else if (((Object)((Object)CellType.STRING)).equals((Object)cellType)) {
            string = cell.getStringCellValue();
        } else if (((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
            CellType cellType2 = cell.getCachedFormulaResultType();
            boolean bl2 = ((Object)((Object)CellType.BLANK)).equals((Object)cellType2) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType2);
            String string2 = bl2 ? "" : (((Object)((Object)CellType.ERROR)).equals((Object)cellType2) ? cell.getCellFormula() : (((Object)((Object)CellType.STRING)).equals((Object)cellType2) ? cell.getStringCellValue() : (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType2) ? Double.toString(cell.getNumericCellValue()) : this.dataFormatter().formatCellValue(cell))));
            string = string2;
        } else {
            string = this.dataFormatter().formatCellValue(cell);
        }
        return string;
    }

    public Workbook getWorkbook(Configuration conf, URI uri) {
        Workbook workbook;
        ExcelHelper$.MODULE$.configureProviders();
        try (FSDataInputStream ins = FileSystem.get((URI)uri, (Configuration)conf).open(new Path(uri));){
            Workbook workbook2;
            Option<String> option = this.options.workbookPassword();
            if (None$.MODULE$.equals(option)) {
                workbook2 = WorkbookFactory.create((InputStream)ins);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String password = (String)some.value();
                workbook2 = WorkbookFactory.create((InputStream)ins, password);
            } else {
                throw new MatchError(option);
            }
            workbook = workbook2;
        }
        return workbook;
    }

    public Iterator<Vector<Cell>> getRows(Configuration conf, URI uri) {
        Iterator<Vector<Cell>> iterator;
        DataLocator excelReader = DataLocator$.MODULE$.apply(this.options);
        try (Workbook workbook = this.getWorkbook(conf, uri);){
            iterator = excelReader.readFrom(workbook);
        }
        return iterator;
    }

    public Vector<String> getColumnNames(Vector<Cell> firstRow) {
        Vector vector;
        Vector rowNumColumn;
        Vector vector2 = rowNumColumn = this.options.columnNameOfRowNumber().isDefined() ? (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.options.columnNameOfRowNumber().get()})) : package$.MODULE$.Vector().empty();
        if (this.options.header()) {
            Vector headerNames = (Vector)firstRow.map((Function1 & Serializable)x$1 -> this.dataFormatter().formatCellValue((Cell)x$1));
            Vector nonNullHeaderNames = (Vector)headerNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExcelHelper.$anonfun$getColumnNames$2(x$1)));
            Set duplicates = ((MapOps)nonNullHeaderNames.groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExcelHelper.$anonfun$getColumnNames$4(x$2)))).keySet();
            vector = (Vector)((StrictOptimizedIterableOps)firstRow.zipWithIndex()).map(arg_0 -> ExcelHelper.$anonfun$getColumnNames$5(this, duplicates, arg_0));
        } else {
            vector = (Vector)((StrictOptimizedIterableOps)firstRow.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int index = tuple2._2$mcI$sp();
                String string = new StringBuilder(2).append("_c").append(index).toString();
                return string;
            });
        }
        Vector dataColumns = vector;
        return (Vector)rowNumColumn.$plus$plus((IterableOnce)dataColumns);
    }

    public AreaReference parsedRangeAddress() {
        return (AreaReference)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            CellReference cellRef = new CellReference($this.options.dataAddress());
            return new AreaReference(cellRef, new CellReference(cellRef.getSheetName(), SpreadsheetVersion.EXCEL2007.getLastRowIndex(), SpreadsheetVersion.EXCEL2007.getLastColumnIndex(), false, false), SpreadsheetVersion.EXCEL2007);
        }).getOrElse((Function0 & Serializable)() -> new AreaReference($this.options.dataAddress(), SpreadsheetVersion.EXCEL2007));
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$2(String x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$4(Tuple2 x$2) {
        return ((SeqOps)x$2._2()).size() > 1;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ String $anonfun$getColumnNames$5(ExcelHelper $this, Set duplicates$1, Tuple2 x0$1) {
        block3: {
            block2: {
                var4_3 = x0$1;
                if (var4_3 == null) break block2;
                cell = (Cell)var4_3._1();
                index = var4_3._2$mcI$sp();
                value = $this.dataFormatter().formatCellValue(cell);
                v0 = cellType = cell.getCellType();
                var9_8 = CellType.ERROR;
                if (!(v0 == null ? var9_8 != null : v0.equals((Object)var9_8) == false)) ** GOTO lbl-1000
                v1 = cellType;
                var10_9 = CellType.BLANK;
                if (!(v1 == null ? var10_9 != null : v1.equals((Object)var10_9) == false)) ** GOTO lbl-1000
                v2 = cellType;
                var11_10 = CellType._NONE;
                if (!(v2 == null ? var11_10 != null : v2.equals((Object)var11_10) == false) || value.isEmpty()) lbl-1000:
                // 3 sources

                {
                    v3 = new StringBuilder(2).append("_c").append(index).toString();
                } else {
                    v3 = duplicates$1.contains((Object)value) != false ? new StringBuilder(0).append(value).append(index).toString() : value;
                }
                break block3;
            }
            throw new MatchError((Object)var4_3);
        }
        var3_11 = v3;
        return var3_11;
    }

    public ExcelHelper(ExcelOptions options) {
        this.options = options;
    }
}

