/*
 * Decompiled with CFR 0.152.
 */
package shadeio.pjfanning.poi.xssf.streaming;

import java.io.Serializable;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import shadeio.poi.ooxml.POIXMLException;
import shadeio.poi.ss.usermodel.RichTextString;
import shadeio.poi.ss.util.CellAddress;
import shadeio.poi.xssf.usermodel.XSSFRichTextString;

class SerializableComment
implements Serializable {
    private static final long serialVersionUID = 7829136421241571165L;
    private String author;
    private String commentText;
    private boolean fullFormat = false;
    private transient CTRst ctRst;
    private String addressAsText;
    private transient CellAddress cellAddress;
    private boolean visible = true;

    public void setAddress(CellAddress address) {
        this.cellAddress = address;
        this.addressAsText = address.formatAsString();
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public int getColumn() {
        CellAddress address = this.getAddress();
        if (address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        return address.getColumn();
    }

    public int getRow() {
        CellAddress address = this.getAddress();
        if (address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        return address.getRow();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public CellAddress getAddress() {
        if (this.cellAddress == null && this.addressAsText != null) {
            this.cellAddress = new CellAddress(this.addressAsText);
        }
        return this.cellAddress;
    }

    public void setAddress(int row, int col) {
        this.setAddress(new CellAddress(row, col));
    }

    public void setColumn(int col) {
        CellAddress address = this.getAddress();
        if (address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        this.setAddress(address.getRow(), col);
    }

    public void setRow(int row) {
        CellAddress address = this.getAddress();
        if (address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        this.setAddress(row, address.getColumn());
    }

    public XSSFRichTextString getString() {
        return new XSSFRichTextString(this.getCTRst());
    }

    public String getCommentText() {
        if (this.fullFormat) {
            return this.getString().getString();
        }
        return this.commentText;
    }

    public void setString(RichTextString string) {
        if (!(string instanceof XSSFRichTextString)) {
            throw new IllegalArgumentException("Only XSSFRichTextString argument is supported");
        }
        this.ctRst = ((XSSFRichTextString)string).getCTRst();
        this.fullFormat = true;
        this.commentText = this.ctRst.xmlText();
    }

    public void setString(String text) {
        this.commentText = text;
        this.fullFormat = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CTRst getCTRst() throws POIXMLException {
        if (this.ctRst == null && this.commentText != null) {
            SerializableComment serializableComment = this;
            synchronized (serializableComment) {
                if (this.ctRst == null && this.commentText != null) {
                    if (this.fullFormat) {
                        try {
                            this.ctRst = (CTRst)CTRst.Factory.parse(this.commentText);
                        }
                        catch (XmlException e) {
                            throw new POIXMLException("Could not parse comment rich text string", e);
                        }
                    } else {
                        XSSFRichTextString richTextString = new XSSFRichTextString();
                        richTextString.setString(this.commentText);
                        this.ctRst = richTextString.getCTRst();
                    }
                }
            }
        }
        return this.ctRst;
    }
}

