/*
 * Decompiled with CFR 0.152.
 */
package shadeio.pjfanning.xlsx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import shadeio.pjfanning.xlsx.impl.StreamingWorkbook;
import shadeio.pjfanning.xlsx.impl.StreamingWorkbookReader;
import shadeio.poi.ss.usermodel.Workbook;

public class StreamingReader
implements AutoCloseable {
    private final StreamingWorkbookReader workbook;

    public StreamingReader(StreamingWorkbookReader workbook) {
        this.workbook = workbook;
    }

    @Override
    public void close() throws IOException {
        this.workbook.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int rowCacheSize = 10;
        private int bufferSize = 1024;
        private boolean avoidTempFiles = false;
        private boolean useSstTempFile = false;
        private boolean useSstReadOnly = false;
        private boolean encryptSstTempFile = false;
        private boolean useCommentsTempFile = false;
        private boolean encryptCommentsTempFile = false;
        private boolean adjustLegacyComments = false;
        private boolean readComments = false;
        private boolean readCoreProperties = false;
        private boolean readHyperlinks = false;
        private boolean readShapes = false;
        private boolean readStyles = true;
        private boolean readSharedFormulas = false;
        private boolean fullFormatRichText = false;
        private String password;

        public int getRowCacheSize() {
            return this.rowCacheSize;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean avoidTempFiles() {
            return this.avoidTempFiles;
        }

        public boolean useSstTempFile() {
            return this.useSstTempFile;
        }

        public boolean useSstReadOnly() {
            return this.useSstReadOnly;
        }

        public boolean encryptSstTempFile() {
            return this.encryptSstTempFile;
        }

        public boolean adjustLegacyComments() {
            return this.adjustLegacyComments;
        }

        public boolean readComments() {
            return this.readComments;
        }

        public boolean useCommentsTempFile() {
            return this.useCommentsTempFile;
        }

        public boolean encryptCommentsTempFile() {
            return this.encryptCommentsTempFile;
        }

        public boolean readCoreProperties() {
            return this.readCoreProperties;
        }

        public boolean readHyperlinks() {
            return this.readHyperlinks;
        }

        public boolean readShapes() {
            return this.readShapes;
        }

        public boolean readSharedFormulas() {
            return this.readSharedFormulas;
        }

        public boolean readStyles() {
            return this.readStyles;
        }

        public boolean fullFormatRichText() {
            return this.fullFormatRichText;
        }

        public Builder rowCacheSize(int rowCacheSize) {
            this.rowCacheSize = rowCacheSize;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder setAvoidTempFiles(boolean avoidTempFiles) {
            this.avoidTempFiles = avoidTempFiles;
            return this;
        }

        public Builder setUseSstTempFile(boolean useSstTempFile) {
            this.useSstTempFile = useSstTempFile;
            return this;
        }

        public Builder setUseSstReadOnly(boolean useSstReadOnly) {
            this.useSstReadOnly = useSstReadOnly;
            return this;
        }

        public Builder setEncryptSstTempFile(boolean encryptSstTempFile) {
            this.encryptSstTempFile = encryptSstTempFile;
            return this;
        }

        public Builder setUseCommentsTempFile(boolean useCommentsTempFile) {
            this.useCommentsTempFile = useCommentsTempFile;
            return this;
        }

        public Builder setEncryptCommentsTempFile(boolean encryptCommentsTempFile) {
            this.encryptCommentsTempFile = encryptCommentsTempFile;
            return this;
        }

        public Builder setReadComments(boolean readComments) {
            this.readComments = readComments;
            return this;
        }

        public Builder setAdjustLegacyComments(boolean adjustLegacyComments) {
            this.adjustLegacyComments = adjustLegacyComments;
            return this;
        }

        public Builder setReadCoreProperties(boolean readCoreProperties) {
            this.readCoreProperties = readCoreProperties;
            return this;
        }

        public Builder setReadHyperlinks(boolean readHyperlinks) {
            this.readHyperlinks = readHyperlinks;
            return this;
        }

        public Builder setReadShapes(boolean readShapes) {
            this.readShapes = readShapes;
            return this;
        }

        public Builder setReadSharedFormulas(boolean readSharedFormulas) {
            this.readSharedFormulas = readSharedFormulas;
            return this;
        }

        public Builder setReadStyles(boolean readStyles) {
            this.readStyles = readStyles;
            return this;
        }

        public Builder setFullFormatRichText(boolean fullFormatRichText) {
            this.fullFormatRichText = fullFormatRichText;
            return this;
        }

        public Workbook open(InputStream is) {
            StreamingWorkbookReader workbook = new StreamingWorkbookReader(this);
            workbook.init(is);
            return new StreamingWorkbook(workbook);
        }

        public Workbook open(File file) {
            StreamingWorkbookReader workbook = new StreamingWorkbookReader(this);
            workbook.init(file);
            return new StreamingWorkbook(workbook);
        }
    }
}

