/*
 * Decompiled with CFR 0.152.
 */
package shadeio.pjfanning.xlsx.impl;

import shadeio.pjfanning.xlsx.impl.OoxmlEvaluationCell;
import shadeio.poi.ss.formula.EvaluationCell;
import shadeio.poi.ss.formula.EvaluationSheet;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.Row;
import shadeio.poi.ss.usermodel.Sheet;
import shadeio.poi.util.Internal;

@Internal
final class CurrentRowEvaluationSheet
implements EvaluationSheet {
    private final Sheet _xs;
    private final Row _row;

    CurrentRowEvaluationSheet(Sheet sheet, Row row) {
        this._xs = sheet;
        this._row = row;
    }

    Sheet getSheet() {
        return this._xs;
    }

    @Override
    public int getLastRowNum() {
        return this._xs.getLastRowNum();
    }

    @Override
    public boolean isRowHidden(int rowIndex) {
        if (this._row == null) {
            return false;
        }
        return this._row.getZeroHeight();
    }

    @Override
    public EvaluationCell getCell(int rowIndex, int columnIndex) {
        if (this._row == null) {
            return null;
        }
        Cell cell = this._row.getCell(columnIndex);
        if (cell == null) {
            return null;
        }
        return new OoxmlEvaluationCell(cell, this);
    }

    @Override
    public void clearAllCachedResultValues() {
    }
}

