/*
 * Decompiled with CFR 0.152.
 */
package shadeio.pjfanning.xlsx.impl;

import java.net.URI;
import shadeio.pjfanning.xlsx.impl.ooxml.HyperlinkData;
import shadeio.poi.common.usermodel.HyperlinkType;
import shadeio.poi.openxml4j.opc.PackageRelationship;
import shadeio.poi.ss.SpreadsheetVersion;
import shadeio.poi.ss.usermodel.Hyperlink;
import shadeio.poi.ss.util.AreaReference;
import shadeio.poi.ss.util.CellReference;

public class XlsxHyperlink
implements Hyperlink {
    private final HyperlinkType _type;
    private final PackageRelationship _externalRel;
    private final HyperlinkData hyperlinkData;
    private String _location;

    XlsxHyperlink(HyperlinkData hyperlinkData, PackageRelationship hyperlinkRel) {
        this.hyperlinkData = hyperlinkData;
        this._externalRel = hyperlinkRel;
        if (this._externalRel == null) {
            if (hyperlinkData.getLocation() != null) {
                this._type = HyperlinkType.DOCUMENT;
                this._location = hyperlinkData.getLocation();
            } else {
                if (hyperlinkData.getId() != null) {
                    throw new IllegalStateException("The hyperlink for cell " + hyperlinkData.getRef() + " references relation " + hyperlinkData.getId() + ", but that didn't exist!");
                }
                this._type = HyperlinkType.DOCUMENT;
            }
        } else {
            URI target = this._externalRel.getTargetURI();
            this._location = target.toString();
            if (hyperlinkData.getLocation() != null) {
                this._location = this._location + "#" + hyperlinkData.getLocation();
            }
            this._type = this._location.startsWith("http://") || this._location.startsWith("https://") || this._location.startsWith("ftp://") ? HyperlinkType.URL : (this._location.startsWith("mailto:") ? HyperlinkType.EMAIL : HyperlinkType.FILE);
        }
    }

    @Override
    public HyperlinkType getType() {
        return this._type;
    }

    public String getCellRef() {
        return this.hyperlinkData.getRef();
    }

    @Override
    public String getAddress() {
        return this._location;
    }

    @Override
    public String getLabel() {
        return this.hyperlinkData.getDisplay();
    }

    public String getLocation() {
        return this.hyperlinkData.getLocation();
    }

    private CellReference buildFirstCellReference() {
        return this.buildCellReference(false);
    }

    private CellReference buildLastCellReference() {
        return this.buildCellReference(true);
    }

    private CellReference buildCellReference(boolean lastCell) {
        String ref = this.hyperlinkData.getRef();
        if (ref == null) {
            ref = "A1";
        }
        if (ref.contains(":")) {
            AreaReference area = new AreaReference(ref, SpreadsheetVersion.EXCEL2007);
            return lastCell ? area.getLastCell() : area.getFirstCell();
        }
        return new CellReference(ref);
    }

    @Override
    public int getFirstColumn() {
        return this.buildFirstCellReference().getCol();
    }

    @Override
    public int getLastColumn() {
        return this.buildLastCellReference().getCol();
    }

    @Override
    public int getFirstRow() {
        return this.buildFirstCellReference().getRow();
    }

    @Override
    public int getLastRow() {
        return this.buildLastCellReference().getRow();
    }

    public String getTooltip() {
        return this.hyperlinkData.getTooltip();
    }

    @Override
    public void setAddress(String address) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setLabel(String label) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setFirstColumn(int col) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setLastColumn(int col) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setFirstRow(int row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setLastRow(int row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }
}

