/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.ddf;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import shadeio.poi.ddf.EscherComplexProperty;
import shadeio.poi.ddf.EscherPropertyTypes;
import shadeio.poi.util.GenericRecordUtil;
import shadeio.poi.util.IOUtils;
import shadeio.poi.util.Internal;
import shadeio.poi.util.LittleEndian;
import shadeio.poi.util.Removal;

public final class EscherArrayProperty
extends EscherComplexProperty
implements Iterable<byte[]> {
    private static final int DEFAULT_MAX_RECORD_LENGTH = 100000;
    private static int MAX_RECORD_LENGTH = 100000;
    private static final int FIXED_SIZE = 6;
    private boolean sizeIncludesHeaderSize = true;
    private final boolean emptyComplexPart;

    public static void setMaxRecordLength(int length) {
        MAX_RECORD_LENGTH = length;
    }

    public static int getMaxRecordLength() {
        return MAX_RECORD_LENGTH;
    }

    @Internal
    public EscherArrayProperty(short id, int complexSize) {
        super(id, complexSize);
        this.emptyComplexPart = complexSize == 0;
    }

    @Deprecated
    @Removal(version="5.0.0")
    public EscherArrayProperty(short propertyNumber, boolean isBlipId, byte[] complexData) {
        this((short)(propertyNumber | (isBlipId ? 16384 : 0)), EscherArrayProperty.safeSize(complexData == null ? 0 : complexData.length));
        this.setComplexData(complexData);
    }

    public EscherArrayProperty(EscherPropertyTypes type, boolean isBlipId, int complexSize) {
        this((short)(type.propNumber | (isBlipId ? 16384 : 0)), EscherArrayProperty.safeSize(complexSize));
    }

    private static int safeSize(int complexSize) {
        return complexSize == 0 ? 6 : complexSize;
    }

    public int getNumberOfElementsInArray() {
        return this.emptyComplexPart ? 0 : LittleEndian.getUShort(this.getComplexData(), 0);
    }

    public void setNumberOfElementsInArray(int numberOfElements) {
        if (this.emptyComplexPart) {
            return;
        }
        this.rewriteArray(numberOfElements, false);
        LittleEndian.putShort(this.getComplexData(), 0, (short)numberOfElements);
    }

    private void rewriteArray(int numberOfElements, boolean copyToNewLen) {
        int expectedArraySize = numberOfElements * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        this.resizeComplexData(expectedArraySize, copyToNewLen ? expectedArraySize : this.getComplexData().length);
    }

    public int getNumberOfElementsInMemory() {
        return this.emptyComplexPart ? 0 : LittleEndian.getUShort(this.getComplexData(), 2);
    }

    public void setNumberOfElementsInMemory(int numberOfElements) {
        if (this.emptyComplexPart) {
            return;
        }
        this.rewriteArray(numberOfElements, true);
        LittleEndian.putShort(this.getComplexData(), 2, (short)numberOfElements);
    }

    public short getSizeOfElements() {
        return this.emptyComplexPart ? (short)0 : LittleEndian.getShort(this.getComplexData(), 4);
    }

    public void setSizeOfElements(int sizeOfElements) {
        if (this.emptyComplexPart) {
            return;
        }
        LittleEndian.putShort(this.getComplexData(), 4, (short)sizeOfElements);
        int expectedArraySize = this.getNumberOfElementsInArray() * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        this.resizeComplexData(expectedArraySize, 6);
    }

    public byte[] getElement(int index) {
        int actualSize = EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements());
        return IOUtils.safelyClone(this.getComplexData(), 6 + index * actualSize, actualSize, MAX_RECORD_LENGTH);
    }

    public void setElement(int index, byte[] element) {
        if (this.emptyComplexPart) {
            return;
        }
        int actualSize = EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements());
        System.arraycopy(element, 0, this.getComplexData(), 6 + index * actualSize, actualSize);
    }

    public int setArrayData(byte[] data, int offset) {
        if (this.emptyComplexPart) {
            this.resizeComplexData(0);
        } else {
            short numElements = LittleEndian.getShort(data, offset);
            short sizeOfElements = LittleEndian.getShort(data, offset + 4);
            int cdLen = this.getComplexData().length;
            int arraySize = EscherArrayProperty.getActualSizeOfElements(sizeOfElements) * numElements;
            if (arraySize == cdLen) {
                this.resizeComplexData(arraySize + 6, 0);
                this.sizeIncludesHeaderSize = false;
            }
            this.setComplexData(data, offset);
        }
        return this.getComplexData().length;
    }

    @Override
    public int serializeSimplePart(byte[] data, int pos) {
        LittleEndian.putShort(data, pos, this.getId());
        int recordSize = this.getComplexData().length;
        if (!this.sizeIncludesHeaderSize) {
            recordSize -= 6;
        }
        LittleEndian.putInt(data, pos + 2, recordSize);
        return 6;
    }

    private static int getActualSizeOfElements(short sizeOfElements) {
        if (sizeOfElements < 0) {
            return (short)(-sizeOfElements >> 2);
        }
        return sizeOfElements;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            int idx;

            @Override
            public boolean hasNext() {
                return this.idx < EscherArrayProperty.this.getNumberOfElementsInArray();
            }

            @Override
            public byte[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return EscherArrayProperty.this.getElement(this.idx++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not yet implemented");
            }
        };
    }

    @Override
    public Spliterator<byte[]> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.getNumberOfElementsInArray(), 0);
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("base", () -> super.getGenericProperties(), "numElements", this::getNumberOfElementsInArray, "numElementsInMemory", this::getNumberOfElementsInMemory, "sizeOfElements", this::getSizeOfElements, "elements", () -> StreamSupport.stream(this.spliterator(), false).collect(Collectors.toList()));
    }
}

