/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.extractor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import shadeio.poi.extractor.ExtractorFactory;
import shadeio.poi.extractor.ExtractorProvider;
import shadeio.poi.extractor.POITextExtractor;
import shadeio.poi.hssf.extractor.EventBasedExcelExtractor;
import shadeio.poi.hssf.extractor.ExcelExtractor;
import shadeio.poi.hssf.extractor.OldExcelExtractor;
import shadeio.poi.hssf.model.InternalWorkbook;
import shadeio.poi.hssf.record.crypto.Biff8EncryptionKey;
import shadeio.poi.poifs.filesystem.DirectoryNode;
import shadeio.poi.poifs.filesystem.FileMagic;
import shadeio.poi.poifs.filesystem.POIFSFileSystem;

public class MainExtractorFactory
implements ExtractorProvider {
    @Override
    public boolean accepts(FileMagic fm) {
        return FileMagic.OLE2 == fm;
    }

    @Override
    public POITextExtractor create(File file, String password) throws IOException {
        return this.create(new POIFSFileSystem(file, true).getRoot(), password);
    }

    @Override
    public POITextExtractor create(InputStream inputStream, String password) throws IOException {
        return this.create(new POIFSFileSystem(inputStream).getRoot(), password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public POITextExtractor create(DirectoryNode poifsDir, String password) throws IOException {
        String oldPW = Biff8EncryptionKey.getCurrentUserPassword();
        try {
            Biff8EncryptionKey.setCurrentUserPassword(password);
            for (String workbookName : InternalWorkbook.WORKBOOK_DIR_ENTRY_NAMES) {
                if (!poifsDir.hasEntry(workbookName)) continue;
                shadeio.poi.ss.extractor.ExcelExtractor excelExtractor = ExtractorFactory.getPreferEventExtractor() ? new EventBasedExcelExtractor(poifsDir) : new ExcelExtractor(poifsDir);
                return excelExtractor;
            }
            if (poifsDir.hasEntry("Book")) {
                OldExcelExtractor oldExcelExtractor = new OldExcelExtractor(poifsDir);
                return oldExcelExtractor;
            }
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(oldPW);
        }
        return null;
    }
}

