/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hpsf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadeio.poi.hpsf.ClassID;
import shadeio.poi.hpsf.CodePageString;
import shadeio.poi.hpsf.DocumentSummaryInformation;
import shadeio.poi.hpsf.HPSFRuntimeException;
import shadeio.poi.hpsf.IllegalPropertySetDataException;
import shadeio.poi.hpsf.Property;
import shadeio.poi.hpsf.SummaryInformation;
import shadeio.poi.hpsf.WritingNotSupportedException;
import shadeio.poi.hpsf.wellknown.PropertyIDMap;
import shadeio.poi.util.CodePageUtil;
import shadeio.poi.util.IOUtils;
import shadeio.poi.util.LittleEndian;
import shadeio.poi.util.LittleEndianByteArrayInputStream;

public class Section {
    private static final Logger LOG = LogManager.getLogger(Section.class);
    private Map<Long, String> dictionary;
    private ClassID formatID;
    private final UnsynchronizedByteArrayOutputStream sectionBytes = new UnsynchronizedByteArrayOutputStream();
    private final long _offset;
    private final Map<Long, Property> properties = new LinkedHashMap<Long, Property>();
    private transient boolean wasNull;

    public Section() {
        this._offset = -1L;
    }

    public Section(Section s) {
        this._offset = -1L;
        this.setFormatID(s.getFormatID());
        for (Property p : s.properties.values()) {
            this.properties.put(p.getID(), new Property(p));
        }
        this.setDictionary(s.getDictionary());
    }

    public Section(byte[] src, int offset) throws UnsupportedEncodingException {
        this.formatID = new ClassID(src, offset);
        int offFix = (int)LittleEndian.getUInt(src, offset + 16);
        if (src[offFix] == 0) {
            int i = 0;
            while (i < 3 && src[offFix] == 0) {
                ++i;
                ++offFix;
            }
            i = 0;
            while (i < 3 && (src[offFix + 3] != 0 || src[offFix + 7] != 0 || src[offFix + 11] != 0)) {
                ++i;
                --offFix;
            }
        }
        this._offset = offFix;
        LittleEndianByteArrayInputStream leis = new LittleEndianByteArrayInputStream(src, offFix);
        int size = (int)Math.min(leis.readUInt(), (long)src.length - this._offset);
        int propertyCount = (int)leis.readUInt();
        TreeBidiMap offset2Id = new TreeBidiMap();
        for (int i = 0; i < propertyCount; ++i) {
            long id = leis.readUInt();
            long off = leis.readUInt();
            offset2Id.put((Comparable)Long.valueOf(off), (Comparable)Long.valueOf(id));
        }
        Long cpOffset = (Long)offset2Id.getKey((Object)1L);
        int codepage = -1;
        if (cpOffset != null) {
            leis.setReadIndex(Math.toIntExact(this._offset + cpOffset));
            long type = leis.readUInt();
            if (type != 2L) {
                throw new HPSFRuntimeException("Value type of property ID 1 is not VT_I2 but " + type + ".");
            }
            codepage = leis.readUShort();
            this.setCodepage(codepage);
        }
        for (Map.Entry me : offset2Id.entrySet()) {
            long off = (Long)me.getKey();
            long id = (Long)me.getValue();
            if (id == 1L) continue;
            int pLen = Section.propLen((TreeBidiMap<Long, Long>)offset2Id, off, size);
            leis.setReadIndex(Math.toIntExact(this._offset + off));
            if (id == 0L) {
                leis.mark(100000);
                if (this.readDictionary(leis, pLen, codepage)) continue;
                leis.reset();
                try {
                    id = Math.max(31L, (Long)offset2Id.inverseBidiMap().lastKey()) + 1L;
                    this.setProperty(new Property(id, leis, pLen, codepage));
                }
                catch (RuntimeException e) {
                    LOG.atInfo().log("Dictionary fallback failed - ignoring property");
                }
                continue;
            }
            this.setProperty(new Property(id, leis, pLen, codepage));
        }
        this.sectionBytes.write(src, Math.toIntExact(this._offset), size);
        this.padSectionBytes();
    }

    private static int propLen(TreeBidiMap<Long, Long> offset2Id, Long entryOffset, long maxSize) {
        Long nextKey = (Long)offset2Id.nextKey((Comparable)entryOffset);
        long begin = entryOffset;
        long end = nextKey != null ? nextKey : maxSize;
        return Math.toIntExact(end - begin);
    }

    public ClassID getFormatID() {
        return this.formatID;
    }

    public void setFormatID(ClassID formatID) {
        this.formatID = formatID;
    }

    public void setFormatID(byte[] formatID) {
        ClassID fid = this.getFormatID();
        if (fid == null) {
            fid = new ClassID();
            this.setFormatID(fid);
        }
        fid.setBytes(formatID);
    }

    public long getOffset() {
        return this._offset;
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public Property[] getProperties() {
        return this.properties.values().toArray(new Property[0]);
    }

    public void setProperties(Property[] properties) {
        this.properties.clear();
        for (Property p : properties) {
            this.setProperty(p);
        }
    }

    public Object getProperty(long id) {
        this.wasNull = !this.properties.containsKey(id);
        return this.wasNull ? null : this.properties.get(id).getValue();
    }

    public void setProperty(int id, String value) {
        this.setProperty(id, 30L, value);
    }

    public void setProperty(int id, int value) {
        this.setProperty(id, 3L, value);
    }

    public void setProperty(int id, long value) {
        this.setProperty(id, 20L, value);
    }

    public void setProperty(int id, boolean value) {
        this.setProperty(id, 11L, value);
    }

    public void setProperty(int id, long variantType, Object value) {
        this.setProperty(new Property(id, variantType, value));
    }

    public void setProperty(Property p) {
        Property old = this.properties.get(p.getID());
        if (old == null || !old.equals(p)) {
            this.properties.put(p.getID(), p);
            this.sectionBytes.reset();
        }
    }

    public void setProperty(int id, Object value) {
        if (value instanceof String) {
            this.setProperty(id, (String)value);
        } else if (value instanceof Long) {
            this.setProperty(id, (Long)value);
        } else if (value instanceof Integer) {
            this.setProperty(id, (Integer)value);
        } else if (value instanceof Short) {
            this.setProperty(id, ((Short)value).intValue());
        } else if (value instanceof Boolean) {
            this.setProperty(id, (Boolean)value);
        } else if (value instanceof Date) {
            this.setProperty(id, 64L, value);
        } else {
            throw new HPSFRuntimeException("HPSF does not support properties of type " + value.getClass().getName() + ".");
        }
    }

    int getPropertyIntValue(long id) {
        Object o = this.getProperty(id);
        if (o == null) {
            return 0;
        }
        if (!(o instanceof Long) && !(o instanceof Integer)) {
            throw new HPSFRuntimeException("This property is not an integer type, but " + o.getClass().getName() + ".");
        }
        Number i = (Number)o;
        return i.intValue();
    }

    boolean getPropertyBooleanValue(int id) {
        Boolean b = (Boolean)this.getProperty(id);
        return b != null && b != false;
    }

    protected void setPropertyBooleanValue(int id, boolean value) {
        this.setProperty(id, 11L, value);
    }

    public int getSize() {
        int size = this.sectionBytes.size();
        if (size > 0) {
            return size;
        }
        try {
            return this.calcSize();
        }
        catch (HPSFRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new HPSFRuntimeException(ex);
        }
    }

    private int calcSize() throws WritingNotSupportedException, IOException {
        this.sectionBytes.reset();
        this.write((OutputStream)this.sectionBytes);
        this.padSectionBytes();
        return this.sectionBytes.size();
    }

    private void padSectionBytes() {
        byte[] padArray = new byte[]{0, 0, 0};
        int pad = 4 - (this.sectionBytes.size() & 3) & 3;
        this.sectionBytes.write(padArray, 0, pad);
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getPIDString(long pid) {
        PropertyIDMap dic = this.getDictionary();
        if (dic == null || !dic.containsKey(pid)) {
            ClassID fmt = this.getFormatID();
            if (SummaryInformation.FORMAT_ID.equals(fmt)) {
                dic = PropertyIDMap.getSummaryInformationProperties();
            } else if (DocumentSummaryInformation.FORMAT_ID[0].equals(fmt)) {
                dic = PropertyIDMap.getDocumentSummaryInformationProperties();
            }
        }
        return dic != null && dic.containsKey(pid) ? (String)dic.get(pid) : "[undefined]";
    }

    public void clear() {
        for (Property p : this.getProperties()) {
            this.removeProperty(p.getID());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Section)) {
            return false;
        }
        Section s = (Section)o;
        if (!s.getFormatID().equals(this.getFormatID())) {
            return false;
        }
        HashSet<Long> propIds = new HashSet<Long>(this.properties.keySet());
        propIds.addAll(s.properties.keySet());
        propIds.remove(0L);
        propIds.remove(1L);
        for (Long id : propIds) {
            Property p1 = this.properties.get(id);
            Property p2 = s.properties.get(id);
            if (p1 != null && p1.equals(p2)) continue;
            return false;
        }
        Map<Long, String> d1 = this.getDictionary();
        Map<Long, String> d2 = s.getDictionary();
        return d1 == null && d2 == null || d1 != null && d1.equals(d2);
    }

    public void removeProperty(long id) {
        if (this.properties.remove(id) != null) {
            this.sectionBytes.reset();
        }
    }

    /*
     * Exception decompiling
     */
    public int write(OutputStream out) throws WritingNotSupportedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean readDictionary(LittleEndianByteArrayInputStream leis, int length, int codepage) {
        HashMap<Long, String> dic = new HashMap<Long, String>();
        long nrEntries = leis.readUInt();
        long id = -1L;
        boolean isCorrupted = false;
        int i = 0;
        while ((long)i < nrEntries) {
            int cp;
            String errMsg = "The property set's dictionary contains bogus data. All dictionary entries starting with the one with ID " + id + " will be ignored.";
            id = leis.readUInt();
            long sLength = leis.readUInt();
            int nrBytes = Math.toIntExact((sLength - 1L) * (long)((cp = codepage == -1 ? 1252 : codepage) == 1200 ? 2 : 1));
            if (nrBytes > 0xFFFFFF) {
                LOG.atWarn().log(errMsg);
                isCorrupted = true;
                break;
            }
            try {
                byte[] buf = IOUtils.safelyAllocate(nrBytes, CodePageString.getMaxRecordLength());
                leis.readFully(buf, 0, nrBytes);
                String str = CodePageUtil.getStringFromCodePage(buf, 0, nrBytes, cp);
                int pad = 1;
                if (cp == 1200) {
                    pad = 2 + (4 - (nrBytes + 2 & 3) & 3);
                }
                IOUtils.skipFully(leis, pad);
                dic.put(id, str);
            }
            catch (IOException | RuntimeException ex) {
                LOG.atWarn().withThrowable((Throwable)ex).log(errMsg);
                isCorrupted = true;
                break;
            }
            ++i;
        }
        this.setDictionary(dic);
        return !isCorrupted;
    }

    private void writeDictionary(OutputStream out, int codepage) throws IOException {
        byte[] padding = new byte[4];
        Map<Long, String> dic = this.getDictionary();
        LittleEndian.putUInt(dic.size(), out);
        int length = 4;
        for (Map.Entry<Long, String> ls : dic.entrySet()) {
            LittleEndian.putUInt(ls.getKey(), out);
            length += 4;
            String value = ls.getValue() + "\u0000";
            byte[] bytes = CodePageUtil.getBytesInCodePage(value, codepage);
            int len = codepage == 1200 ? value.length() : bytes.length;
            LittleEndian.putUInt(len, out);
            length += 4;
            out.write(bytes);
            int pad = codepage == 1200 ? 4 - ((length += bytes.length) & 3) & 3 : 0;
            out.write(padding, 0, pad);
            length += pad;
        }
        int pad = 4 - (length & 3) & 3;
        out.write(padding, 0, pad);
    }

    public void setDictionary(Map<Long, String> dictionary) throws IllegalPropertySetDataException {
        if (dictionary != null) {
            if (this.dictionary == null) {
                this.dictionary = new TreeMap<Long, String>();
            }
            this.dictionary.putAll(dictionary);
            int cp = this.getCodepage();
            if (cp == -1) {
                this.setCodepage(1252);
            }
            this.setProperty(0, -1L, dictionary);
        } else {
            this.removeProperty(0L);
            this.dictionary = null;
        }
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.getFormatID(), this.getProperties()});
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(PropertyIDMap idMap) {
        StringBuilder b = new StringBuilder();
        Property[] pa = this.getProperties();
        b.append("\n\n\n");
        b.append(this.getClass().getName());
        b.append('[');
        b.append("formatID: ");
        b.append(this.getFormatID());
        b.append(", offset: ");
        b.append(this.getOffset());
        b.append(", propertyCount: ");
        b.append(this.getPropertyCount());
        b.append(", size: ");
        b.append(this.getSize());
        b.append(", properties: [\n");
        int codepage = this.getCodepage();
        if (codepage == -1) {
            codepage = 1252;
        }
        for (Property p : pa) {
            b.append(p.toString(codepage, idMap));
            b.append(",\n");
        }
        b.append(']');
        b.append(']');
        return b.toString();
    }

    public Map<Long, String> getDictionary() {
        if (this.dictionary == null) {
            this.dictionary = (Map)this.getProperty(0L);
        }
        return this.dictionary;
    }

    public int getCodepage() {
        Integer codepage = (Integer)this.getProperty(1L);
        return codepage == null ? -1 : codepage;
    }

    public void setCodepage(int codepage) {
        this.setProperty(1, 2L, codepage);
    }
}

