/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.record;

import java.util.Map;
import java.util.function.Supplier;
import shadeio.poi.hssf.record.FormulaSpecialCachedValue;
import shadeio.poi.hssf.record.HSSFRecordTypes;
import shadeio.poi.hssf.record.OldCellRecord;
import shadeio.poi.hssf.record.RecordInputStream;
import shadeio.poi.ss.formula.Formula;
import shadeio.poi.ss.formula.ptg.Ptg;
import shadeio.poi.ss.usermodel.CellType;
import shadeio.poi.util.GenericRecordUtil;

public final class OldFormulaRecord
extends OldCellRecord {
    public static final short biff2_sid = 6;
    public static final short biff3_sid = 518;
    public static final short biff4_sid = 1030;
    public static final short biff5_sid = 6;
    private FormulaSpecialCachedValue specialCachedValue;
    private double field_4_value;
    private short field_5_options;
    private Formula field_6_parsed_expr;

    public OldFormulaRecord(RecordInputStream ris) {
        super(ris, ris.getSid() == 6);
        if (this.isBiff2()) {
            this.field_4_value = ris.readDouble();
        } else {
            long valueLongBits = ris.readLong();
            this.specialCachedValue = FormulaSpecialCachedValue.create(valueLongBits);
            if (this.specialCachedValue == null) {
                this.field_4_value = Double.longBitsToDouble(valueLongBits);
            }
        }
        this.field_5_options = this.isBiff2() ? (short)ris.readUByte() : ris.readShort();
        short expression_len = ris.readShort();
        int nBytesAvailable = ris.available();
        this.field_6_parsed_expr = Formula.read(expression_len, ris, nBytesAvailable);
    }

    @Deprecated
    public int getCachedResultType() {
        if (this.specialCachedValue == null) {
            return CellType.NUMERIC.getCode();
        }
        return this.specialCachedValue.getValueType();
    }

    public CellType getCachedResultTypeEnum() {
        if (this.specialCachedValue == null) {
            return CellType.NUMERIC;
        }
        return this.specialCachedValue.getValueTypeEnum();
    }

    public boolean getCachedBooleanValue() {
        return this.specialCachedValue.getBooleanValue();
    }

    public int getCachedErrorValue() {
        return this.specialCachedValue.getErrorValue();
    }

    public double getValue() {
        return this.field_4_value;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public Ptg[] getParsedExpression() {
        return this.field_6_parsed_expr.getTokens();
    }

    public Formula getFormula() {
        return this.field_6_parsed_expr;
    }

    public HSSFRecordTypes getGenericRecordType() {
        return HSSFRecordTypes.FORMULA;
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("base", () -> super.getGenericProperties(), "options", this::getOptions, "formula", this::getFormula, "value", this::getValue);
    }
}

