/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.record;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import shadeio.poi.hssf.record.BlankRecord;
import shadeio.poi.hssf.record.DBCellRecord;
import shadeio.poi.hssf.record.HSSFRecordTypes;
import shadeio.poi.hssf.record.MulBlankRecord;
import shadeio.poi.hssf.record.MulRKRecord;
import shadeio.poi.hssf.record.NumberRecord;
import shadeio.poi.hssf.record.RKRecord;
import shadeio.poi.hssf.record.Record;
import shadeio.poi.hssf.record.RecordFactoryInputStream;
import shadeio.poi.hssf.record.RecordInputStream;
import shadeio.poi.util.IOUtils;
import shadeio.poi.util.RecordFormatException;

public final class RecordFactory {
    private static final int NUM_RECORDS = 512;
    private static final int MAX_NUMBER_OF_RECORDS = 2000000;

    private RecordFactory() {
    }

    public static Class<? extends Record> getRecordClass(int sid) {
        return HSSFRecordTypes.forSID((int)sid).clazz;
    }

    public static Record[] createRecord(RecordInputStream in) {
        Record record = RecordFactory.createSingleRecord(in);
        if (record instanceof DBCellRecord) {
            return new Record[]{null};
        }
        if (record instanceof RKRecord) {
            return new Record[]{RecordFactory.convertToNumberRecord((RKRecord)record)};
        }
        if (record instanceof MulRKRecord) {
            return RecordFactory.convertRKRecords((MulRKRecord)record);
        }
        return new Record[]{record};
    }

    public static Record createSingleRecord(RecordInputStream in) {
        HSSFRecordTypes rec = HSSFRecordTypes.forSID(in.getSid());
        if (!rec.isParseable()) {
            rec = HSSFRecordTypes.UNKNOWN;
        }
        return rec.recordConstructor.apply(in);
    }

    public static NumberRecord convertToNumberRecord(RKRecord rk) {
        NumberRecord num = new NumberRecord();
        num.setColumn(rk.getColumn());
        num.setRow(rk.getRow());
        num.setXFIndex(rk.getXFIndex());
        num.setValue(rk.getRKNumber());
        return num;
    }

    public static NumberRecord[] convertRKRecords(MulRKRecord mrk) {
        int numColumns = mrk.getNumColumns();
        if (numColumns < 0) {
            throw new RecordFormatException("Cannot create RKRecords with negative number of columns: " + numColumns);
        }
        NumberRecord[] mulRecs = new NumberRecord[numColumns];
        for (int k = 0; k < numColumns; ++k) {
            NumberRecord nr = new NumberRecord();
            nr.setColumn((short)(k + mrk.getFirstColumn()));
            nr.setRow(mrk.getRow());
            nr.setXFIndex(mrk.getXFAt(k));
            nr.setValue(mrk.getRKNumberAt(k));
            mulRecs[k] = nr;
        }
        return mulRecs;
    }

    public static BlankRecord[] convertBlankRecords(MulBlankRecord mbk) {
        BlankRecord[] mulRecs = new BlankRecord[mbk.getNumColumns()];
        for (int k = 0; k < mbk.getNumColumns(); ++k) {
            BlankRecord br = new BlankRecord();
            br.setColumn((short)(k + mbk.getFirstColumn()));
            br.setRow(mbk.getRow());
            br.setXFIndex(mbk.getXFAt(k));
            mulRecs[k] = br;
        }
        return mulRecs;
    }

    public static short[] getAllKnownRecordSIDs() {
        int[] intSid = Arrays.stream(HSSFRecordTypes.values()).mapToInt(HSSFRecordTypes::getSid).toArray();
        short[] shortSid = new short[intSid.length];
        for (int i = 0; i < intSid.length; ++i) {
            shortSid[i] = (short)intSid[i];
        }
        return shortSid;
    }

    public static List<Record> createRecords(InputStream in) throws RecordFormatException {
        Record record;
        ArrayList<Record> records = new ArrayList<Record>(512);
        RecordFactoryInputStream recStream = new RecordFactoryInputStream(in, true);
        while ((record = recStream.nextRecord()) != null) {
            records.add(record);
            IOUtils.safelyAllocateCheck(records.size(), 2000000);
        }
        return records;
    }
}

