/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.ss.usermodel;

import java.util.regex.Pattern;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.TableStyleInfo;
import shadeio.poi.ss.util.CellReference;

public interface Table {
    public static final Pattern isStructuredReference = Pattern.compile("[a-zA-Z_\\\\][a-zA-Z0-9._]*\\[.*\\]");

    public int getStartColIndex();

    public int getStartRowIndex();

    public int getEndColIndex();

    public int getEndRowIndex();

    public String getName();

    public String getStyleName();

    public int findColumnIndex(String var1);

    public String getSheetName();

    public boolean isHasTotalsRow();

    public int getTotalsRowCount();

    public int getHeaderRowCount();

    public TableStyleInfo getStyle();

    default public boolean contains(Cell cell) {
        if (cell == null) {
            return false;
        }
        return this.contains(new CellReference(cell.getSheet().getSheetName(), cell.getRowIndex(), cell.getColumnIndex(), true, true));
    }

    public boolean contains(CellReference var1);
}

