/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xddf.usermodel.chart;

import org.openxmlformats.schemas.drawingml.x2006.chart.CTView3D;
import shadeio.poi.ooxml.util.POIXMLUnits;
import shadeio.poi.util.Internal;

public class XDDFView3D {
    private final CTView3D view3D;

    @Internal
    protected XDDFView3D(CTView3D view3D) {
        this.view3D = view3D;
    }

    public Byte getXRotationAngle() {
        if (this.view3D.isSetRotX()) {
            return this.view3D.getRotX().getVal();
        }
        return null;
    }

    public void setXRotationAngle(Byte rotation) {
        if (rotation == null) {
            if (this.view3D.isSetRotX()) {
                this.view3D.unsetRotX();
            }
        } else {
            if (rotation < -90 || 90 < rotation) {
                throw new IllegalArgumentException("rotation must be between -90 and 90");
            }
            if (this.view3D.isSetRotX()) {
                this.view3D.getRotX().setVal(rotation.byteValue());
            } else {
                this.view3D.addNewRotX().setVal(rotation.byteValue());
            }
        }
    }

    public Integer getYRotationAngle() {
        if (this.view3D.isSetRotY()) {
            return this.view3D.getRotY().getVal();
        }
        return null;
    }

    public void setYRotationAngle(Integer rotation) {
        if (rotation == null) {
            if (this.view3D.isSetRotY()) {
                this.view3D.unsetRotY();
            }
        } else {
            if (rotation < 0 || 360 < rotation) {
                throw new IllegalArgumentException("rotation must be between 0 and 360");
            }
            if (this.view3D.isSetRotY()) {
                this.view3D.getRotY().setVal(rotation.intValue());
            } else {
                this.view3D.addNewRotY().setVal(rotation.intValue());
            }
        }
    }

    public Boolean hasRightAngleAxes() {
        if (this.view3D.isSetRAngAx()) {
            return this.view3D.getRAngAx().getVal();
        }
        return null;
    }

    public void setRightAngleAxes(Boolean rightAngles) {
        if (rightAngles == null) {
            if (this.view3D.isSetRAngAx()) {
                this.view3D.unsetRAngAx();
            }
        } else if (this.view3D.isSetRAngAx()) {
            this.view3D.getRAngAx().setVal(rightAngles.booleanValue());
        } else {
            this.view3D.addNewRAngAx().setVal(rightAngles.booleanValue());
        }
    }

    public Short getPerspectiveAngle() {
        if (this.view3D.isSetPerspective()) {
            return this.view3D.getPerspective().getVal();
        }
        return null;
    }

    public void setPerspectiveAngle(Short perspective) {
        if (perspective == null) {
            if (this.view3D.isSetPerspective()) {
                this.view3D.unsetPerspective();
            }
        } else {
            if (perspective < 0 || 240 < perspective) {
                throw new IllegalArgumentException("perspective must be between 0 and 240");
            }
            if (this.view3D.isSetPerspective()) {
                this.view3D.getPerspective().setVal(perspective.shortValue());
            } else {
                this.view3D.addNewPerspective().setVal(perspective.shortValue());
            }
        }
    }

    public Integer getDepthPercent() {
        return this.view3D.isSetDepthPercent() ? Integer.valueOf(POIXMLUnits.parsePercent(this.view3D.getDepthPercent().xgetVal())) : null;
    }

    public void setDepthPercent(Integer percent) {
        if (percent == null) {
            if (this.view3D.isSetDepthPercent()) {
                this.view3D.unsetDepthPercent();
            }
        } else {
            if (percent < 20 || 2000 < percent) {
                throw new IllegalArgumentException("percent must be between 20 and 2000");
            }
            if (this.view3D.isSetDepthPercent()) {
                this.view3D.getDepthPercent().setVal((Object)percent);
            } else {
                this.view3D.addNewDepthPercent().setVal((Object)percent);
            }
        }
    }

    public Integer getHPercent() {
        return this.view3D.isSetHPercent() ? Integer.valueOf(POIXMLUnits.parsePercent(this.view3D.getHPercent().xgetVal())) : null;
    }

    public void setHPercent(Integer percent) {
        if (percent == null) {
            if (this.view3D.isSetHPercent()) {
                this.view3D.unsetHPercent();
            }
        } else {
            if (percent < 5 || 500 < percent) {
                throw new IllegalArgumentException("percent must be between 5 and 500");
            }
            if (this.view3D.isSetHPercent()) {
                this.view3D.getHPercent().setVal((Object)percent);
            } else {
                this.view3D.addNewHPercent().setVal((Object)percent);
            }
        }
    }
}

