/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xdgf.usermodel;

import com.microsoft.schemas.office.visio.x2012.main.PageContentsDocument;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import shadeio.poi.ooxml.POIXMLDocumentPart;
import shadeio.poi.ooxml.POIXMLException;
import shadeio.poi.openxml4j.opc.PackagePart;
import shadeio.poi.xdgf.exceptions.XDGFException;
import shadeio.poi.xdgf.usermodel.XDGFBaseContents;
import shadeio.poi.xdgf.usermodel.XDGFMaster;
import shadeio.poi.xdgf.usermodel.XDGFMasterContents;
import shadeio.poi.xdgf.usermodel.XDGFPage;
import shadeio.poi.xdgf.usermodel.XDGFShape;

public class XDGFPageContents
extends XDGFBaseContents {
    protected Map<Long, XDGFMaster> _masters = new HashMap<Long, XDGFMaster>();
    protected XDGFPage _page;

    public XDGFPageContents(PackagePart part) {
        super(part);
    }

    @Override
    protected void onDocumentRead() {
        try {
            try (InputStream stream = this.getPackagePart().getInputStream();){
                this._pageContents = ((PageContentsDocument)PageContentsDocument.Factory.parse(stream)).getPageContents();
            }
            catch (IOException | XmlException e) {
                throw new POIXMLException(e);
            }
            for (POIXMLDocumentPart part : this.getRelations()) {
                if (!(part instanceof XDGFMasterContents)) continue;
                XDGFMaster master = ((XDGFMasterContents)part).getMaster();
                if (master == null) {
                    throw new POIXMLException("Master entry is missing in XDGFPageContents");
                }
                this._masters.put(master.getID(), master);
            }
            super.onDocumentRead();
            for (XDGFShape shape : this._shapes.values()) {
                if (!shape.isTopmost()) continue;
                shape.setupMaster(this, null);
            }
        }
        catch (POIXMLException e) {
            throw XDGFException.wrap(this, e);
        }
    }

    public XDGFPage getPage() {
        return this._page;
    }

    protected void setPage(XDGFPage page) {
        this._page = page;
    }

    public XDGFMaster getMasterById(long id) {
        return this._masters.get(id);
    }
}

