/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xslf.usermodel;

import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShapeNonVisual;
import shadeio.poi.sl.usermodel.AutoShape;
import shadeio.poi.xddf.usermodel.text.XDDFTextBody;
import shadeio.poi.xslf.usermodel.XSLFFreeformShape;
import shadeio.poi.xslf.usermodel.XSLFShape;
import shadeio.poi.xslf.usermodel.XSLFSheet;
import shadeio.poi.xslf.usermodel.XSLFTextBox;
import shadeio.poi.xslf.usermodel.XSLFTextParagraph;
import shadeio.poi.xslf.usermodel.XSLFTextShape;

public class XSLFAutoShape
extends XSLFTextShape
implements AutoShape<XSLFShape, XSLFTextParagraph> {
    XSLFAutoShape(CTShape shape, XSLFSheet sheet) {
        super((XmlObject)shape, sheet);
    }

    static XSLFAutoShape create(CTShape shape, XSLFSheet sheet) {
        if (shape.getSpPr().isSetCustGeom()) {
            return new XSLFFreeformShape(shape, sheet);
        }
        if (shape.getNvSpPr().getCNvSpPr().isSetTxBox()) {
            return new XSLFTextBox(shape, sheet);
        }
        return new XSLFAutoShape(shape, sheet);
    }

    static CTShape prototype(int shapeId) {
        CTShape ct = (CTShape)CTShape.Factory.newInstance();
        CTShapeNonVisual nvSpPr = ct.addNewNvSpPr();
        CTNonVisualDrawingProps cnv = nvSpPr.addNewCNvPr();
        cnv.setName("AutoShape " + shapeId);
        cnv.setId((long)shapeId);
        nvSpPr.addNewCNvSpPr();
        nvSpPr.addNewNvPr();
        CTShapeProperties spPr = ct.addNewSpPr();
        CTPresetGeometry2D prst = spPr.addNewPrstGeom();
        prst.setPrst(STShapeType.RECT);
        prst.addNewAvLst();
        return ct;
    }

    @Override
    protected CTTextBody getTextBody(boolean create) {
        CTShape shape = (CTShape)this.getXmlObject();
        CTTextBody txBody = shape.getTxBody();
        if (txBody == null && create) {
            XDDFTextBody body = new XDDFTextBody(this);
            shape.setTxBody(body.getXmlObject());
            txBody = shape.getTxBody();
        }
        return txBody;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] " + this.getShapeName();
    }
}

