/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xssf.streaming;

import shadeio.poi.ss.formula.EvaluationCell;
import shadeio.poi.ss.formula.EvaluationSheet;
import shadeio.poi.util.Internal;
import shadeio.poi.xssf.streaming.SXSSFCell;
import shadeio.poi.xssf.streaming.SXSSFEvaluationCell;
import shadeio.poi.xssf.streaming.SXSSFFormulaEvaluator;
import shadeio.poi.xssf.streaming.SXSSFRow;
import shadeio.poi.xssf.streaming.SXSSFSheet;

@Internal
final class SXSSFEvaluationSheet
implements EvaluationSheet {
    private final SXSSFSheet _xs;

    public SXSSFEvaluationSheet(SXSSFSheet sheet) {
        this._xs = sheet;
    }

    public SXSSFSheet getSXSSFSheet() {
        return this._xs;
    }

    @Override
    public int getLastRowNum() {
        return this._xs.getLastRowNum();
    }

    @Override
    public boolean isRowHidden(int rowIndex) {
        SXSSFRow row = this._xs.getRow(rowIndex);
        if (row == null) {
            return false;
        }
        return row.getZeroHeight();
    }

    @Override
    public EvaluationCell getCell(int rowIndex, int columnIndex) {
        SXSSFRow row = this._xs.getRow(rowIndex);
        if (row == null) {
            if (rowIndex <= this._xs.getLastFlushedRowNum()) {
                throw new SXSSFFormulaEvaluator.RowFlushedException(rowIndex, this._xs.getLastFlushedRowNum());
            }
            return null;
        }
        SXSSFCell cell = row.getCell(columnIndex);
        if (cell == null) {
            return null;
        }
        return new SXSSFEvaluationCell(cell, this);
    }

    @Override
    public void clearAllCachedResultValues() {
    }
}

