/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import shadeio.poi.ooxml.POIXMLDocumentPart;
import shadeio.poi.ooxml.POIXMLException;
import shadeio.poi.ooxml.POIXMLRelation;
import shadeio.poi.openxml4j.opc.PackagePart;
import shadeio.poi.ss.usermodel.PictureData;
import shadeio.poi.util.IOUtils;
import shadeio.poi.xssf.usermodel.XSSFRelation;

public class XSSFPictureData
extends POIXMLDocumentPart
implements PictureData {
    protected static final POIXMLRelation[] RELATIONS = new POIXMLRelation[13];

    protected XSSFPictureData() {
    }

    protected XSSFPictureData(PackagePart part) {
        super(part);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getData() {
        try (InputStream inputStream = this.getPackagePart().getInputStream();){
            byte[] byArray = IOUtils.toByteArray(inputStream);
            return byArray;
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
    }

    @Override
    public String suggestFileExtension() {
        return this.getPackagePart().getPartName().getExtension();
    }

    @Override
    public int getPictureType() {
        String contentType = this.getPackagePart().getContentType();
        for (int i = 0; i < RELATIONS.length; ++i) {
            if (RELATIONS[i] == null || !RELATIONS[i].getContentType().equals(contentType)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public String getMimeType() {
        return this.getPackagePart().getContentType();
    }

    @Override
    protected void prepareForCommit() {
    }

    static {
        XSSFPictureData.RELATIONS[2] = XSSFRelation.IMAGE_EMF;
        XSSFPictureData.RELATIONS[3] = XSSFRelation.IMAGE_WMF;
        XSSFPictureData.RELATIONS[4] = XSSFRelation.IMAGE_PICT;
        XSSFPictureData.RELATIONS[5] = XSSFRelation.IMAGE_JPEG;
        XSSFPictureData.RELATIONS[6] = XSSFRelation.IMAGE_PNG;
        XSSFPictureData.RELATIONS[7] = XSSFRelation.IMAGE_DIB;
        XSSFPictureData.RELATIONS[8] = XSSFRelation.IMAGE_GIF;
        XSSFPictureData.RELATIONS[9] = XSSFRelation.IMAGE_TIFF;
        XSSFPictureData.RELATIONS[10] = XSSFRelation.IMAGE_EPS;
        XSSFPictureData.RELATIONS[11] = XSSFRelation.IMAGE_BMP;
        XSSFPictureData.RELATIONS[12] = XSSFRelation.IMAGE_WPG;
    }
}

