/*
 * Decompiled with CFR 0.152.
 */
package com.crealytics.spark.v2.excel;

import com.crealytics.spark.v2.excel.ExcelHelper$;
import com.crealytics.spark.v2.excel.ExcelOptions;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import shadeio.poi.hssf.usermodel.HSSFWorkbook;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.CellStyle;
import shadeio.poi.ss.usermodel.CreationHelper;
import shadeio.poi.ss.usermodel.Row;
import shadeio.poi.ss.usermodel.Sheet;
import shadeio.poi.ss.usermodel.Workbook;
import shadeio.poi.ss.util.AreaReference;
import shadeio.poi.ss.util.WorkbookUtil;
import shadeio.poi.xssf.usermodel.XSSFWorkbook;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\u0012%\u0001=B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005q!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003G\u0011!!\u0006A!b\u0001\n\u0003)\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006K\u0002!\tA\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019A\b\u0001)A\u0005]\"Q\u0011\u0010\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002>\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001bBA\u0006\u0001\u0001\u0006I! \u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"!\u0005\u0001A\u0003%\u0011\u0011\u0001\u0005\n\u0003'\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"!\u0006\u0001A\u0003%\u0011\u0011A\u0003\u0007\u0003/\u0001A!!\u0007\t\u0013\u0005]\u0002A1A\u0005\n\u0005e\u0002\u0002CA#\u0001\u0001\u0006I!a\u000f\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!Q\u0011Q\u000b\u0001\t\u0006\u0004%I!a\u0016\t\u0015\u0005e\u0003\u0001#b\u0001\n\u0013\t9\u0006\u0003\u0006\u0002\\\u0001A)\u0019!C\u0005\u0003/B!\"!\u0018\u0001\u0011\u000b\u0007I\u0011BA,\u0011)\ty\u0006\u0001EC\u0002\u0013%\u0011q\u000b\u0005\b\u0003C\u0002A\u0011BA2\u0011%\ty\u0007\u0001a\u0001\n\u0013\ty\u0001C\u0005\u0002r\u0001\u0001\r\u0011\"\u0003\u0002t!A\u0011q\u000f\u0001!B\u0013\t\t\u0001C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u0011Q\u0011\u0001\u0005\u0002\u0005m$AD#yG\u0016dw)\u001a8fe\u0006$xN\u001d\u0006\u0003K\u0019\nQ!\u001a=dK2T!a\n\u0015\u0002\u0005Y\u0014$BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0006de\u0016\fG.\u001f;jGNT\u0011!L\u0001\u0004G>l7\u0001A\n\u0003\u0001A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0017\u0001\u00029bi\",\u0012\u0001\u000f\t\u0003s\u0001s!A\u000f \u0011\u0005m\u0012T\"\u0001\u001f\u000b\u0005ur\u0013A\u0002\u001fs_>$h(\u0003\u0002@e\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\ty$'A\u0003qCRD\u0007%\u0001\u0006eCR\f7k\u00195f[\u0006,\u0012A\u0012\t\u0003\u000fFk\u0011\u0001\u0013\u0006\u0003\u0013*\u000bQ\u0001^=qKNT!a\u0013'\u0002\u0007M\fHN\u0003\u0002*\u001b*\u0011ajT\u0001\u0007CB\f7\r[3\u000b\u0003A\u000b1a\u001c:h\u0013\t\u0011\u0006J\u0001\u0006TiJ,8\r\u001e+za\u0016\f1\u0002Z1uCN\u001b\u0007.Z7bA\u0005!1m\u001c8g+\u00051\u0006CA,\\\u001b\u0005A&B\u0001+Z\u0015\tQV*\u0001\u0004iC\u0012|w\u000e]\u0005\u00039b\u0013QbQ8oM&<WO]1uS>t\u0017!B2p]\u001a\u0004\u0013aB8qi&|gn]\u000b\u0002AB\u0011\u0011MY\u0007\u0002I%\u00111\r\n\u0002\r\u000bb\u001cW\r\\(qi&|gn]\u0001\t_B$\u0018n\u001c8tA\u00051A(\u001b8jiz\"Ra\u001a5jU.\u0004\"!\u0019\u0001\t\u000bYJ\u0001\u0019\u0001\u001d\t\u000b\u0011K\u0001\u0019\u0001$\t\u000bQK\u0001\u0019\u0001,\t\u000byK\u0001\u0019\u00011\u0002\u0005]\u0014W#\u00018\u0011\u0005=4X\"\u00019\u000b\u0007E\fi)A\u0005vg\u0016\u0014Xn\u001c3fY*\u00191/!%\u0002\u0005M\u001c(bA;\u0002\u0014\u0006\u0019\u0001o\\5\n\u0005]\u0004(\u0001C,pe.\u0014wn\\6\u0002\u0007]\u0014\u0007%A\u0002yIE\u0002r!M>~\u0003\u0003\t\t!\u0003\u0002}e\t1A+\u001e9mKN\u0002\"a\u001c@\n\u0005}\u0004(!B*iK\u0016$\bcA\u0019\u0002\u0004%\u0019\u0011Q\u0001\u001a\u0003\u0007%sG/A\u0003tQ\u0016,G/F\u0001~\u0003\u0019\u0019\b.Z3uA\u0005Aa-\u001b:ti\u000e{G.\u0006\u0002\u0002\u0002\u0005Ia-\u001b:ti\u000e{G\u000eI\u0001\tM&\u00148\u000f\u001e*po\u0006Ia-\u001b:tiJ{w\u000f\t\u0002\u000f-\u0006dW/Z\"p]Z,'\u000f^3s!-\t\u00141DA\u0010\u0003\u0003\tY#!\r\n\u0007\u0005u!GA\u0005Gk:\u001cG/[8ogA!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&)\u000b\u0001bY1uC2L8\u000f^\u0005\u0005\u0003S\t\u0019CA\u0006J]R,'O\\1m%><\bcA8\u0002.%\u0019\u0011q\u00069\u0003\t\r+G\u000e\u001c\t\u0004c\u0005M\u0012bAA\u001be\t!QK\\5u\u0003=1\u0018\r\\;f\u0007>tg/\u001a:uKJ\u001cXCAA\u001e!\u0015\t\u0014QHA!\u0013\r\tyD\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0003\u0007\u001aR\"\u0001\u0001\u0002!Y\fG.^3D_:4XM\u001d;feN\u0004\u0013aC2sK\u0006$Xm\u0015;zY\u0016$B!a\u0013\u0002RA\u0019q.!\u0014\n\u0007\u0005=\u0003OA\u0005DK2d7\u000b^=mK\"1\u00111\u000b\fA\u0002a\naAZ8s[\u0006$\u0018!\u0004#bi\u0016\u001cU\r\u001c7TifdW-\u0006\u0002\u0002L\u0005\u0011B+[7fgR\fW\u000e]\"fY2\u001cF/\u001f7f\u0003Q9\u0006n\u001c7f\u001dVl'-\u001a:DK2d7\u000b^=mK\u00061B)Z2j[\u0006dg*^7cKJ\u001cU\r\u001c7TifdW-A\bTiJLgnZ\"fY2\u001cF/\u001f7f\u00035i\u0017m[3D_:4XM\u001d;feR!\u0011\u0011IA3\u0011\u001d\t9\u0007\ba\u0001\u0003S\n\u0001\u0002Z1uCRK\b/\u001a\t\u0004\u000f\u0006-\u0014bAA7\u0011\nAA)\u0019;b)f\u0004X-A\u0002s_^\fqA]8x?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005U\u0004\u0002C=\u001f\u0003\u0003\u0005\r!!\u0001\u0002\tI|w\u000fI\u0001\roJLG/\u001a%fC\u0012,'o\u001d\u000b\u0003\u0003c\tQa\u001e:ji\u0016$B!!\r\u0002\u0002\"9\u00111Q\u0011A\u0002\u0005}\u0011A\u0002:fG>\u0014H-A\u0003dY>\u001cX-A\u0004tQ\u0006$W-[8\u000b\u0005\u0005\u001d%bA;\u0002\n*\u00191/a#\u000b\u0005\u0005\u001d%bA;\u0002\u0010*\u0011\u0011q\u0011")
public class ExcelGenerator {
    private CellStyle DateCellStyle;
    private CellStyle TimestampCellStyle;
    private CellStyle WholeNumberCellStyle;
    private CellStyle DecimalNumberCellStyle;
    private CellStyle StringCellStyle;
    private final String path;
    private final StructType dataSchema;
    private final Configuration conf;
    private final ExcelOptions options;
    private final Workbook wb;
    private final /* synthetic */ Tuple3 x$1;
    private final Sheet sheet;
    private final int firstCol;
    private final int firstRow;
    private final Function3<InternalRow, Object, Cell, BoxedUnit>[] valueConverters;
    private int row;
    private volatile byte bitmap$0;

    public String path() {
        return this.path;
    }

    public StructType dataSchema() {
        return this.dataSchema;
    }

    public Configuration conf() {
        return this.conf;
    }

    public ExcelOptions options() {
        return this.options;
    }

    private Workbook wb() {
        return this.wb;
    }

    private Sheet sheet() {
        return this.sheet;
    }

    private int firstCol() {
        return this.firstCol;
    }

    private int firstRow() {
        return this.firstRow;
    }

    private Function3<InternalRow, Object, Cell, BoxedUnit>[] valueConverters() {
        return this.valueConverters;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle createStyle(String format) {
        void var3_3;
        CreationHelper createHelper = this.wb().getCreationHelper();
        CellStyle r = this.wb().createCellStyle();
        r.setDataFormat(createHelper.createDataFormat().getFormat(format));
        return var3_3;
    }

    private CellStyle DateCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.DateCellStyle = this.createStyle(this.options().dateFormat());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.DateCellStyle;
    }

    private CellStyle DateCellStyle() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.DateCellStyle$lzycompute() : this.DateCellStyle;
    }

    private CellStyle TimestampCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.TimestampCellStyle = this.createStyle(this.options().timestampFormat());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.TimestampCellStyle;
    }

    private CellStyle TimestampCellStyle() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.TimestampCellStyle$lzycompute() : this.TimestampCellStyle;
    }

    private CellStyle WholeNumberCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.WholeNumberCellStyle = this.createStyle("General");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.WholeNumberCellStyle;
    }

    private CellStyle WholeNumberCellStyle() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.WholeNumberCellStyle$lzycompute() : this.WholeNumberCellStyle;
    }

    private CellStyle DecimalNumberCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.DecimalNumberCellStyle = this.options().usePlainNumberFormat() ? this.createStyle("General") : this.createStyle("0.00E+000");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.DecimalNumberCellStyle;
    }

    private CellStyle DecimalNumberCellStyle() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.DecimalNumberCellStyle$lzycompute() : this.DecimalNumberCellStyle;
    }

    private CellStyle StringCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.StringCellStyle = this.createStyle("@");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.StringCellStyle;
    }

    private CellStyle StringCellStyle() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.StringCellStyle$lzycompute() : this.StringCellStyle;
    }

    private Function3<InternalRow, Object, Cell, BoxedUnit> makeConverter(DataType dataType) {
        Function3 & Serializable intersect;
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal), cell);
                return BoxedUnit.UNIT;
            };
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal), cell);
                return BoxedUnit.UNIT;
            };
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal), cell);
                return BoxedUnit.UNIT;
            };
        } else if (LongType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal), cell);
                return BoxedUnit.UNIT;
            };
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal), cell);
                return BoxedUnit.UNIT;
            };
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal), cell);
                return BoxedUnit.UNIT;
            };
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            intersect = (Function3 & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$7(this, decimalType, row, BoxesRunTime.unboxToInt((Object)ordinal), cell);
                return BoxedUnit.UNIT;
            };
        } else if (DateType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal), cell);
                return BoxedUnit.UNIT;
            };
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal), cell);
                return BoxedUnit.UNIT;
            };
        } else if (StringType$.MODULE$.equals(dataType2)) {
            intersect = (Function3 & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal), cell);
                return BoxedUnit.UNIT;
            };
        } else {
            throw new RuntimeException(new StringBuilder(18).append("Unsupported type: ").append(dataType.typeName()).toString());
        }
        return intersect;
    }

    private int row() {
        return this.row;
    }

    private void row_$eq(int x$1) {
        this.row = x$1;
    }

    public void writeHeaders() {
        Row excelRow = this.sheet().createRow(this.row());
        ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.dataSchema().fields()), (Function1 & Serializable)x$3 -> x$3.name(), ClassTag$.MODULE$.apply(String.class))))), (Function1 & Serializable)x0$1 -> {
            ExcelGenerator.$anonfun$writeHeaders$2(this, excelRow, x0$1);
            return BoxedUnit.UNIT;
        }, (ClassTag)ClassTag$.MODULE$.Unit());
        this.row_$eq(this.row() + 1);
    }

    public void write(InternalRow record) {
        Row excelRow = this.sheet().createRow(this.row());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), record.numFields()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            Cell cell = excelRow.createCell(idx + this.firstCol());
            if (record.isNullAt(idx)) {
                cell.setBlank();
            } else {
                this.valueConverters()[idx].apply((Object)record, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)cell);
            }
        });
        this.row_$eq(this.row() + 1);
    }

    public void close() {
        Path hdfsPath = new Path(this.path());
        FileSystem fs = hdfsPath.getFileSystem(this.conf());
        FSDataOutputStream fos = fs.create(hdfsPath, true);
        this.wb().write((OutputStream)fos);
        this.wb().close();
        fos.close();
    }

    public static final /* synthetic */ void $anonfun$makeConverter$1(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getByte(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$2(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getShort(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$3(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getInt(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$4(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getLong(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$5(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getFloat(ordinal));
        cell.setCellStyle($this.DecimalNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$6(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getDouble(ordinal));
        cell.setCellStyle($this.DecimalNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$7(ExcelGenerator $this, DecimalType x8$1, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getDecimal(ordinal, x8$1.precision(), x8$1.scale()).toDouble());
        cell.setCellStyle($this.DecimalNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$8(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(DateTimeUtils$.MODULE$.toJavaDate(row.getInt(ordinal)));
        cell.setCellStyle($this.DateCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$9(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(DateTimeUtils$.MODULE$.toJavaTimestamp(row.getLong(ordinal)));
        cell.setCellStyle($this.TimestampCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$10(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getString(ordinal));
        cell.setCellStyle($this.StringCellStyle());
    }

    public static final /* synthetic */ void $anonfun$writeHeaders$2(ExcelGenerator $this, Row excelRow$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        excelRow$1.createCell(idx + $this.firstCol()).setCellValue(name);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ExcelGenerator(String path, StructType dataSchema, Configuration conf, ExcelOptions options) {
        this.path = path;
        this.dataSchema = dataSchema;
        this.conf = conf;
        this.options = options;
        String string = options.fileExtension().toLowerCase();
        String string2 = "xlsx";
        this.wb = !(string != null ? !string.equals(string2) : string2 != null) ? new XSSFWorkbook() : new HSSFWorkbook();
        AreaReference dataAddress = ExcelHelper$.MODULE$.apply(options).parsedRangeAddress();
        String ret = dataAddress.getFirstCell().getSheetName();
        String sheetname = ret == null || ret.isEmpty() ? "Sheet1" : WorkbookUtil.createSafeSheetName(ret);
        short col = dataAddress.getFirstCell().getCol();
        int row = dataAddress.getFirstCell().getRow();
        Tuple3 tuple3 = new Tuple3((Object)this.wb().createSheet(sheetname), (Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)row));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Sheet sheet = (Sheet)tuple3._1();
        int firstCol = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int firstRow = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)sheet, (Object)BoxesRunTime.boxToInteger((int)firstCol), (Object)BoxesRunTime.boxToInteger((int)firstRow));
        this.x$1 = tuple32;
        this.sheet = (Sheet)this.x$1._1();
        this.firstCol = BoxesRunTime.unboxToInt((Object)this.x$1._2());
        this.firstRow = BoxesRunTime.unboxToInt((Object)this.x$1._3());
        this.valueConverters = (Function3[])((IterableOnceOps)((IterableOps)dataSchema.map((Function1 & Serializable)x$2 -> x$2.dataType())).map((Function1 & Serializable)dataType -> this.makeConverter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function3.class));
        this.row = this.firstRow();
    }
}

