/*
 * Decompiled with CFR 0.152.
 */
package com.crealytics.spark.v2.excel;

import com.crealytics.spark.v2.excel.DataLocator;
import com.crealytics.spark.v2.excel.DataLocator$;
import com.crealytics.spark.v2.excel.ExcelHelper$;
import com.crealytics.spark.v2.excel.ExcelOptions;
import com.crealytics.spark.v2.excel.PlainNumberFormat$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import shadeio.poi.ss.SpreadsheetVersion;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.CellType;
import shadeio.poi.ss.usermodel.DataFormatter;
import shadeio.poi.ss.usermodel.FormulaError;
import shadeio.poi.ss.usermodel.Workbook;
import shadeio.poi.ss.usermodel.WorkbookFactory;
import shadeio.poi.ss.util.AreaReference;
import shadeio.poi.ss.util.CellReference;

@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001\u0002\n\u0014\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006U\u0001!Ia\u000b\u0005\t]\u0001A)\u0019!C\u0005_!)a\b\u0001C\u0001\u007f!)\u0001\u000b\u0001C\u0001#\")\u0001\u000e\u0001C\u0001S\")\u0001\u0010\u0001C\u0001s\")Q\u0010\u0001C\u0001}\u001e9\u00111B\n\t\u0002\u00055aA\u0002\n\u0014\u0011\u0003\ty\u0001\u0003\u0004+\u0015\u0011\u0005\u0011\u0011\u0003\u0005\n\u0003'Q!\u0019!C\u0005\u0003+A\u0001\"!\u000b\u000bA\u0003%\u0011q\u0003\u0005\n\u0003WQ!\u0019!C\u0005\u0003+A\u0001\"!\f\u000bA\u0003%\u0011q\u0003\u0005\b\u0003_QA\u0011AA\u0019\u0011\u001d\t)D\u0003C\u0001\u0003o\u00111\"\u0012=dK2DU\r\u001c9fe*\u0011A#F\u0001\u0006Kb\u001cW\r\u001c\u0006\u0003-]\t!A\u001e\u001a\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003)\u0019'/Z1msRL7m\u001d\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\u000f=\u0004H/[8ogB\u0011q\u0005K\u0007\u0002'%\u0011\u0011f\u0005\u0002\r\u000bb\u001cW\r\\(qi&|gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051j\u0003CA\u0014\u0001\u0011\u0015)#\u00011\u0001'\u00035!\u0017\r^1G_Jl\u0017\r\u001e;feV\t\u0001\u0007\u0005\u00022y5\t!GC\u00024\u0003\u000b\n\u0011\"^:fe6|G-\u001a7\u000b\u0007U\nI%\u0001\u0002tg*\u0019q'a\u0013\u0002\u0007A|\u0017N\u0003\u0002:u\u00051\u0011\r]1dQ\u0016T\u0011aO\u0001\u0004_J<\u0017BA\u001f3\u00055!\u0015\r^1G_Jl\u0017\r\u001e;fe\u0006\u00192/\u00194f\u0007\u0016dGn\u0015;sS:<g+\u00197vKR\u0011\u0001i\u0013\t\u0003\u0003\"s!A\u0011$\u0011\u0005\r\u000bS\"\u0001#\u000b\u0005\u0015k\u0012A\u0002\u001fs_>$h(\u0003\u0002HC\u00051\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9\u0015\u0005C\u0003M\t\u0001\u0007Q*\u0001\u0003dK2d\u0007CA\u0019O\u0013\ty%G\u0001\u0003DK2d\u0017aC4fi^{'o\u001b2p_.$2AU+_!\t\t4+\u0003\u0002Ue\tAqk\u001c:lE>|7\u000eC\u0003W\u000b\u0001\u0007q+\u0001\u0003d_:4\u0007C\u0001-]\u001b\u0005I&B\u0001,[\u0015\tY\u0006(\u0001\u0004iC\u0012|w\u000e]\u0005\u0003;f\u0013QbQ8oM&<WO]1uS>t\u0007\"B0\u0006\u0001\u0004\u0001\u0017aA;sSB\u0011\u0011MZ\u0007\u0002E*\u00111\rZ\u0001\u0004]\u0016$(\"A3\u0002\t)\fg/Y\u0005\u0003O\n\u00141!\u0016*J\u0003\u001d9W\r\u001e*poN$2A\u001b<x!\rY\u0007o\u001d\b\u0003Y:t!aQ7\n\u0003\tJ!a\\\u0011\u0002\u000fA\f7m[1hK&\u0011\u0011O\u001d\u0002\t\u0013R,'/\u0019;pe*\u0011q.\t\t\u0004WRl\u0015BA;s\u0005\u00191Vm\u0019;pe\")aK\u0002a\u0001/\")qL\u0002a\u0001A\u0006qq-\u001a;D_2,XN\u001c(b[\u0016\u001cHC\u0001>|!\rYG\u000f\u0011\u0005\u0006y\u001e\u0001\ra]\u0001\tM&\u00148\u000f\u001e*po\u0006\u0011\u0002/\u0019:tK\u0012\u0014\u0016M\\4f\u0003\u0012$'/Z:t)\u0005y\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015A'\u0001\u0003vi&d\u0017\u0002BA\u0005\u0003\u0007\u0011Q\"\u0011:fCJ+g-\u001a:f]\u000e,\u0017aC#yG\u0016d\u0007*\u001a7qKJ\u0004\"a\n\u0006\u0014\u0005)yBCAA\u0007\u0003M\u0019wN\u001c4jOV\u0014\u0018\r^5p]:+W\rZ3e+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\u0015RBAA\u000e\u0015\u0011\ti\"a\b\u0002\r\u0005$x.\\5d\u0015\u0011\t\t#a\t\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002\u0006\u0011LA!a\n\u0002\u001c\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fAcY8oM&<WO]1uS>tg*Z3eK\u0012\u0004\u0013aE2p]\u001aLw-\u001e:bi&|g.S:E_:,\u0017\u0001F2p]\u001aLw-\u001e:bi&|g.S:E_:,\u0007%A\u0003baBd\u0017\u0010F\u0002-\u0003gAQ!\n\tA\u0002\u0019\nacY8oM&<WO]3Qe>4\u0018\u000eZ3sg>s7-\u001a\u000b\u0003\u0003s\u00012\u0001IA\u001e\u0013\r\ti$\t\u0002\u0005+:LG/A\u0004tQ\u0006$W-[8\u000b\u0005\u0005}\"bA\u001c\u0002B)\u0019Q'a\u0011\u000b\u0005\u0005}\"bA\u001c\u0002H)\u0011\u0011q\b")
public class ExcelHelper {
    private DataFormatter dataFormatter;
    private final ExcelOptions options;
    private volatile boolean bitmap$0;

    public static void configureProvidersOnce() {
        ExcelHelper$.MODULE$.configureProvidersOnce();
    }

    public static ExcelHelper apply(ExcelOptions options) {
        return ExcelHelper$.MODULE$.apply(options);
    }

    /*
     * WARNING - void declaration
     */
    private DataFormatter dataFormatter$lzycompute() {
        ExcelHelper excelHelper = this;
        synchronized (excelHelper) {
            if (!this.bitmap$0) {
                void var2_2;
                DataFormatter r = new DataFormatter();
                if (this.options.usePlainNumberFormat()) {
                    PlainNumberFormat$ plainNumberFormat = PlainNumberFormat$.MODULE$;
                    r.addFormat("General", plainNumberFormat);
                    r.addFormat("@", plainNumberFormat);
                }
                this.dataFormatter = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.dataFormatter;
    }

    private DataFormatter dataFormatter() {
        return !this.bitmap$0 ? this.dataFormatter$lzycompute() : this.dataFormatter;
    }

    public String safeCellStringValue(Cell cell) {
        String string;
        CellType cellType = cell.getCellType();
        boolean bl = ((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType);
        if (bl) {
            string = "";
        } else if (((Object)((Object)CellType.STRING)).equals((Object)cellType)) {
            string = cell.getStringCellValue();
        } else if (((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
            CellType cellType2 = cell.getCachedFormulaResultType();
            boolean bl2 = ((Object)((Object)CellType.BLANK)).equals((Object)cellType2) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType2);
            String string2 = bl2 ? "" : (((Object)((Object)CellType.ERROR)).equals((Object)cellType2) ? FormulaError.forInt(cell.getErrorCellValue()).getString() : (((Object)((Object)CellType.STRING)).equals((Object)cellType2) ? cell.getStringCellValue() : (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType2) ? Double.toString(cell.getNumericCellValue()) : this.dataFormatter().formatCellValue(cell))));
            string = string2;
        } else {
            string = this.dataFormatter().formatCellValue(cell);
        }
        return string;
    }

    public Workbook getWorkbook(Configuration conf, URI uri) {
        Workbook workbook;
        try (FSDataInputStream ins = FileSystem.get((URI)uri, (Configuration)conf).open(new Path(uri));){
            Workbook workbook2;
            Option<String> option = this.options.workbookPassword();
            if (None$.MODULE$.equals(option)) {
                workbook2 = WorkbookFactory.create((InputStream)ins);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String password = (String)some.value();
                workbook2 = WorkbookFactory.create((InputStream)ins, password);
            } else {
                throw new MatchError(option);
            }
            workbook = workbook2;
        }
        return workbook;
    }

    public Iterator<Vector<Cell>> getRows(Configuration conf, URI uri) {
        Iterator<Vector<Cell>> iterator;
        DataLocator excelReader = DataLocator$.MODULE$.apply(this.options);
        try (Workbook workbook = this.getWorkbook(conf, uri);){
            iterator = excelReader.readFrom(workbook);
        }
        return iterator;
    }

    public Vector<String> getColumnNames(Vector<Cell> firstRow) {
        Vector vector;
        Vector rowNumColumn;
        Vector vector2 = rowNumColumn = this.options.columnNameOfRowNumber().isDefined() ? (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.options.columnNameOfRowNumber().get()})) : package$.MODULE$.Vector().empty();
        if (this.options.header()) {
            Vector headerNames = (Vector)firstRow.map((Function1 & Serializable)x$1 -> this.dataFormatter().formatCellValue((Cell)x$1));
            Vector nonNullHeaderNames = (Vector)headerNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExcelHelper.$anonfun$getColumnNames$2(x$1)));
            Set duplicates = ((MapOps)nonNullHeaderNames.groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExcelHelper.$anonfun$getColumnNames$4(x$2)))).keySet();
            vector = (Vector)((StrictOptimizedIterableOps)firstRow.zipWithIndex()).map(arg_0 -> ExcelHelper.$anonfun$getColumnNames$5(this, duplicates, arg_0));
        } else {
            vector = (Vector)((StrictOptimizedIterableOps)firstRow.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int index = tuple2._2$mcI$sp();
                String string = new StringBuilder(2).append("_c").append(index).toString();
                return string;
            });
        }
        Vector dataColumns = vector;
        return (Vector)rowNumColumn.$plus$plus((IterableOnce)dataColumns);
    }

    public AreaReference parsedRangeAddress() {
        return (AreaReference)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            CellReference cellRef = new CellReference($this.options.dataAddress());
            return new AreaReference(cellRef, new CellReference(cellRef.getSheetName(), SpreadsheetVersion.EXCEL2007.getLastRowIndex(), SpreadsheetVersion.EXCEL2007.getLastColumnIndex(), false, false), SpreadsheetVersion.EXCEL2007);
        }).getOrElse((Function0 & Serializable)() -> new AreaReference($this.options.dataAddress(), SpreadsheetVersion.EXCEL2007));
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$2(String x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$4(Tuple2 x$2) {
        return ((SeqOps)x$2._2()).size() > 1;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ String $anonfun$getColumnNames$5(ExcelHelper $this, Set duplicates$1, Tuple2 x0$1) {
        block3: {
            block2: {
                var4_3 = x0$1;
                if (var4_3 == null) break block2;
                cell = (Cell)var4_3._1();
                index = var4_3._2$mcI$sp();
                value = $this.dataFormatter().formatCellValue(cell);
                v0 = cellType = cell.getCellType();
                var9_8 = CellType.ERROR;
                if (!(v0 == null ? var9_8 != null : v0.equals((Object)var9_8) == false)) ** GOTO lbl-1000
                v1 = cellType;
                var10_9 = CellType.BLANK;
                if (!(v1 == null ? var10_9 != null : v1.equals((Object)var10_9) == false)) ** GOTO lbl-1000
                v2 = cellType;
                var11_10 = CellType._NONE;
                if (!(v2 == null ? var11_10 != null : v2.equals((Object)var11_10) == false) || value.isEmpty()) lbl-1000:
                // 3 sources

                {
                    v3 = new StringBuilder(2).append("_c").append(index).toString();
                } else {
                    v3 = duplicates$1.contains((Object)value) != false ? new StringBuilder(0).append(value).append(index).toString() : value;
                }
                break block3;
            }
            throw new MatchError((Object)var4_3);
        }
        var3_11 = v3;
        return var3_11;
    }

    public ExcelHelper(ExcelOptions options) {
        this.options = options;
    }
}

