/*
 * Decompiled with CFR 0.152.
 */
package shadeio.pjfanning.poi.xssf.streaming;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadeio.pjfanning.poi.xssf.streaming.Constants;
import shadeio.pjfanning.poi.xssf.streaming.SharedStringsTableBase;
import shadeio.poi.openxml4j.opc.OPCPackage;
import shadeio.poi.openxml4j.opc.PackagePart;
import shadeio.poi.ss.usermodel.RichTextString;
import shadeio.poi.util.TempFile;
import shadeio.poi.xssf.usermodel.XSSFRelation;

public class TempFileSharedStringsTable
extends SharedStringsTableBase {
    private static final Logger log = LoggerFactory.getLogger(TempFileSharedStringsTable.class);
    private File tempFile;
    private MVStore mvStore;
    private MVMap<Integer, String> mvStrings;

    public TempFileSharedStringsTable() throws IOException {
        this(false, false);
    }

    public TempFileSharedStringsTable(boolean encryptTempFiles) throws IOException {
        this(encryptTempFiles, false);
    }

    public TempFileSharedStringsTable(boolean encryptTempFiles, boolean fullFormat) throws IOException {
        super(fullFormat);
        try {
            this.tempFile = TempFile.createTempFile("poi-shared-strings", ".tmp");
            MVStore.Builder mvStoreBuilder = new MVStore.Builder();
            if (encryptTempFiles) {
                byte[] bytes = new byte[1024];
                Constants.RANDOM.nextBytes(bytes);
                mvStoreBuilder.encryptionKey(Base64.getEncoder().encodeToString(bytes).toCharArray());
            }
            mvStoreBuilder.fileName(this.tempFile.getAbsolutePath());
            this.mvStore = mvStoreBuilder.open();
            this.mvStrings = this.mvStore.openMap("strings");
            this.strings = this.mvStrings;
            this.stmap = this.mvStore.openMap("stmap");
        }
        catch (IOException | Error e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null && !this.tempFile.delete()) {
                log.debug("failed to delete temp file - probably already deleted");
            }
            throw e;
        }
        catch (Exception e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null && !this.tempFile.delete()) {
                log.debug("failed to delete temp file - probably already deleted");
            }
            throw new IOException(e);
        }
    }

    public TempFileSharedStringsTable(OPCPackage pkg, boolean encryptTempFiles) throws IOException {
        this(pkg, encryptTempFiles, false);
    }

    public TempFileSharedStringsTable(OPCPackage pkg, boolean encryptTempFiles, boolean fullFormat) throws IOException {
        this(encryptTempFiles, fullFormat);
        ArrayList<PackagePart> parts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (!parts.isEmpty()) {
            PackagePart sstPart = parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected Iterator<Integer> keyIterator() {
        return this.mvStrings.keyIterator(null);
    }

    @Override
    public List<RichTextString> getSharedStringItems() {
        throw new UnsupportedOperationException("TempFileSharedStringsTable only supports streaming access of shared strings");
    }

    @Override
    public void close() throws IOException {
        if (this.mvStore != null) {
            this.mvStore.closeImmediately();
        }
        if (this.tempFile != null && !this.tempFile.delete()) {
            log.debug("failed to delete temp file - probably already deleted");
        }
    }
}

