/*
 * Decompiled with CFR 0.152.
 */
package shadeio.pjfanning.xlsx.impl;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import shadeio.pjfanning.xlsx.XmlUtils;
import shadeio.pjfanning.xlsx.exceptions.NotSupportedException;
import shadeio.pjfanning.xlsx.impl.DateTimeUtil;
import shadeio.pjfanning.xlsx.impl.Supplier;
import shadeio.poi.ss.formula.FormulaParseException;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.CellStyle;
import shadeio.poi.ss.usermodel.CellType;
import shadeio.poi.ss.usermodel.Comment;
import shadeio.poi.ss.usermodel.DateUtil;
import shadeio.poi.ss.usermodel.FormulaError;
import shadeio.poi.ss.usermodel.Hyperlink;
import shadeio.poi.ss.usermodel.RichTextString;
import shadeio.poi.ss.usermodel.Row;
import shadeio.poi.ss.usermodel.Sheet;
import shadeio.poi.ss.util.CellAddress;
import shadeio.poi.ss.util.CellRangeAddress;
import shadeio.poi.xssf.usermodel.XSSFRichTextString;

public class StreamingCell
implements Cell {
    private static final Supplier NULL_SUPPLIER = () -> null;
    private final Sheet sheet;
    private final int columnIndex;
    private int rowIndex;
    private Row row;
    private final boolean use1904Dates;
    private Supplier contentsSupplier = NULL_SUPPLIER;
    private String rawContents;
    private String formula;
    private String numericFormat;
    private Short numericFormatIndex;
    private String type;
    private CellStyle cellStyle;
    private boolean formulaType;
    private boolean sharedFormula;
    private String formulaSI;

    public StreamingCell(Sheet sheet, int columnIndex, int rowIndex, boolean use1904Dates) {
        this.sheet = sheet;
        this.columnIndex = columnIndex;
        this.rowIndex = rowIndex;
        this.use1904Dates = use1904Dates;
    }

    public StreamingCell(Sheet sheet, int columnIndex, Row row, boolean use1904Dates) {
        this.sheet = sheet;
        this.columnIndex = columnIndex;
        this.row = row;
        this.use1904Dates = use1904Dates;
    }

    void setContentSupplier(Supplier contentsSupplier) {
        this.contentsSupplier = contentsSupplier;
    }

    void setRawContents(String rawContents) {
        this.rawContents = rawContents;
    }

    public String getNumericFormat() {
        return this.numericFormat;
    }

    void setNumericFormat(String numericFormat) {
        this.numericFormat = numericFormat;
    }

    Short getNumericFormatIndex() {
        return this.numericFormatIndex;
    }

    void setNumericFormatIndex(Short numericFormatIndex) {
        this.numericFormatIndex = numericFormatIndex;
    }

    void setFormula(String formula) {
        this.formula = formula;
    }

    String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    boolean isFormulaType() {
        return this.formulaType;
    }

    void setFormulaType(boolean formulaType) {
        this.formulaType = formulaType;
    }

    void setSharedFormula(boolean sharedFormula) {
        this.sharedFormula = sharedFormula;
    }

    boolean isSharedFormula() {
        return this.sharedFormula;
    }

    void setFormulaSI(String formulaSI) {
        this.formulaSI = formulaSI;
    }

    String getFormulaSI() {
        return this.formulaSI;
    }

    @Override
    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getRowIndex() {
        return this.row == null ? this.rowIndex : this.row.getRowNum();
    }

    @Override
    public Row getRow() {
        return this.row;
    }

    @Override
    public Sheet getSheet() {
        return this.sheet;
    }

    @Override
    public CellType getCellType() {
        if (this.formulaType) {
            return CellType.FORMULA;
        }
        if (this.contentsSupplier.getContent() == null || this.type == null) {
            return CellType.BLANK;
        }
        return StreamingCell.getCellTypeFromShortHandType(this.type);
    }

    @Override
    public String getStringCellValue() {
        Object c = this.contentsSupplier.getContent();
        return c == null ? "" : c.toString();
    }

    @Override
    public double getNumericCellValue() {
        if ("d".equals(this.type)) {
            try {
                LocalDateTime dt = DateTimeUtil.parseDateTime(this.rawContents);
                return DateUtil.getExcelDate(dt, this.use1904Dates);
            }
            catch (Exception e) {
                try {
                    return DateTimeUtil.convertTime(this.rawContents);
                }
                catch (Exception e2) {
                    throw new IllegalStateException("cannot parse strict format date/time " + this.rawContents);
                }
            }
        }
        return this.rawContents == null ? 0.0 : Double.parseDouble(this.rawContents);
    }

    @Override
    public Date getDateCellValue() {
        if (this.getCellType() == CellType.STRING) {
            throw new IllegalStateException("Cell type cannot be CELL_TYPE_STRING");
        }
        return this.rawContents == null ? null : DateUtil.getJavaDate(this.getNumericCellValue(), this.use1904Dates);
    }

    @Override
    public boolean getBooleanCellValue() {
        CellType cellType = this.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = this.getCachedFormulaResultType();
        }
        switch (cellType) {
            case BLANK: {
                return false;
            }
            case BOOLEAN: {
                return this.rawContents != null && XmlUtils.evaluateBoolean(this.rawContents);
            }
        }
        throw StreamingCell.typeMismatch(CellType.BOOLEAN, cellType, this.isFormulaType());
    }

    private static IllegalStateException typeMismatch(CellType expectedType, CellType actualType, boolean isFormulaCell) {
        String msg = "Cannot get a " + StreamingCell.getCellTypeName(expectedType) + " value from a " + StreamingCell.getCellTypeName(actualType) + " " + (isFormulaCell ? "formula " : "") + "cell";
        return new IllegalStateException(msg);
    }

    private static String getCellTypeName(CellType cellType) {
        switch (cellType) {
            case BLANK: {
                return "blank";
            }
            case STRING: {
                return "text";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case ERROR: {
                return "error";
            }
            case NUMERIC: {
                return "numeric";
            }
            case FORMULA: {
                return "formula";
            }
        }
        return "#unknown cell type (" + (Object)((Object)cellType) + ")#";
    }

    @Override
    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    @Override
    public String getCellFormula() {
        if (!this.formulaType) {
            throw new IllegalStateException("This cell does not have a formula");
        }
        if ((this.formula == null || this.formula.isEmpty()) && this.sharedFormula) {
            throw new IllegalStateException("This cell has a shared formula and it seems setReadSharedFormulas has been set to false or the formula can't be evaluated");
        }
        return this.formula;
    }

    @Override
    public XSSFRichTextString getRichStringCellValue() {
        XSSFRichTextString rt;
        CellType cellType = this.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = this.getCachedFormulaResultType();
        }
        switch (cellType) {
            case BLANK: {
                rt = new XSSFRichTextString("");
                break;
            }
            case STRING: {
                Object content = this.contentsSupplier.getContent();
                if (content instanceof XSSFRichTextString) {
                    rt = (XSSFRichTextString)content;
                    break;
                }
                if (content != null) {
                    rt = new XSSFRichTextString(content.toString());
                    break;
                }
                rt = new XSSFRichTextString("");
                break;
            }
            default: {
                throw new NotSupportedException("getRichStringCellValue does not support cell type " + (Object)((Object)cellType));
            }
        }
        return rt;
    }

    @Override
    public CellType getCachedFormulaResultType() {
        if (this.formulaType) {
            if (this.contentsSupplier.getContent() == null || this.type == null) {
                return CellType.BLANK;
            }
            return StreamingCell.getCellTypeFromShortHandType(this.type);
        }
        throw new IllegalStateException("Only formula cells have cached results");
    }

    @Override
    public LocalDateTime getLocalDateTimeCellValue() {
        if (this.getCellType() == CellType.STRING) {
            throw new IllegalStateException("Cell type cannot be CELL_TYPE_STRING");
        }
        return this.rawContents == null ? null : DateUtil.getLocalDateTime(this.getNumericCellValue(), this.use1904Dates);
    }

    @Override
    public byte getErrorCellValue() {
        CellType cellType = this.getCellType();
        if (cellType != CellType.ERROR) {
            throw StreamingCell.typeMismatch(CellType.ERROR, cellType, false);
        }
        String code = this.rawContents;
        if (code == null) {
            return 0;
        }
        try {
            return FormulaError.forString(code).getCode();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unexpected error code", e);
        }
    }

    @Override
    public CellAddress getAddress() {
        return new CellAddress(this);
    }

    @Override
    public Comment getCellComment() {
        return this.sheet == null ? null : this.sheet.getCellComment(this.getAddress());
    }

    @Override
    public Hyperlink getHyperlink() {
        return this.sheet == null ? null : this.sheet.getHyperlink(this.getAddress());
    }

    @Override
    public void setCellType(CellType cellType) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setBlank() {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setCellValue(double value) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setCellValue(Date value) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setCellValue(Calendar value) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setCellValue(LocalDate value) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setCellValue(LocalDateTime value) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setCellValue(RichTextString value) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setCellValue(String value) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setCellFormula(String formula) throws FormulaParseException {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void removeFormula() throws IllegalStateException {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setCellValue(boolean value) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setCellErrorValue(byte value) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setAsActiveCell() {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setCellComment(Comment comment) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void removeCellComment() {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setHyperlink(Hyperlink link) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void removeHyperlink() {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public CellRangeAddress getArrayFormulaRange() {
        throw new NotSupportedException();
    }

    @Override
    public boolean isPartOfArrayFormulaGroup() {
        throw new NotSupportedException();
    }

    private static CellType getCellTypeFromShortHandType(String cellType) {
        switch (cellType) {
            case "n": 
            case "d": {
                return CellType.NUMERIC;
            }
            case "s": 
            case "inlineStr": 
            case "str": {
                return CellType.STRING;
            }
            case "b": {
                return CellType.BOOLEAN;
            }
            case "e": {
                return CellType.ERROR;
            }
        }
        throw new UnsupportedOperationException("Unsupported cell cell type '" + cellType + "'");
    }
}

