/*
 * Decompiled with CFR 0.152.
 */
package shadeio.pjfanning.xlsx.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import shadeio.pjfanning.xlsx.exceptions.NotSupportedException;
import shadeio.pjfanning.xlsx.impl.StreamingCell;
import shadeio.pjfanning.xlsx.impl.StreamingSheetReader;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.CellStyle;
import shadeio.poi.ss.usermodel.CellType;
import shadeio.poi.ss.usermodel.Row;
import shadeio.poi.ss.usermodel.Sheet;

public class StreamingRow
implements Row {
    private final Sheet sheet;
    private final int rowIndex;
    private final boolean isHidden;
    private float height = -1.0f;
    private TreeMap<Integer, Cell> cellMap = new TreeMap();
    private StreamingSheetReader streamingSheetReader;
    private CellStyle rowStyle;

    public StreamingRow(Sheet sheet, int rowIndex, boolean isHidden) {
        this.sheet = sheet;
        this.rowIndex = rowIndex;
        this.isHidden = isHidden;
    }

    void setStreamingSheetReader(StreamingSheetReader streamingSheetReader) {
        this.streamingSheetReader = streamingSheetReader;
    }

    void setHeight(float height) {
        this.height = height;
    }

    public Map<Integer, Cell> getCellMap() {
        return this.cellMap;
    }

    @Override
    public int getRowNum() {
        return this.rowIndex;
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return this.cellMap.values().iterator();
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.cellMap.values().iterator();
    }

    @Override
    public Spliterator<Cell> spliterator() {
        return Spliterators.spliterator(this.cellMap.values(), 16);
    }

    @Override
    public Sheet getSheet() {
        return this.sheet;
    }

    @Override
    public Cell getCell(int cellnum) {
        return this.cellMap.get(cellnum);
    }

    @Override
    public short getLastCellNum() {
        return (short)(this.cellMap.isEmpty() ? -1 : this.cellMap.lastEntry().getValue().getColumnIndex() + 1);
    }

    @Override
    public boolean getZeroHeight() {
        return this.isHidden;
    }

    @Override
    public short getHeight() {
        return (short)(this.getHeightInPoints() * 20.0f);
    }

    @Override
    public float getHeightInPoints() {
        return this.height;
    }

    @Override
    public int getPhysicalNumberOfCells() {
        return this.cellMap.size();
    }

    @Override
    public short getFirstCellNum() {
        if (this.cellMap.isEmpty()) {
            return -1;
        }
        return this.cellMap.firstKey().shortValue();
    }

    @Override
    public Cell getCell(int cellnum, Row.MissingCellPolicy policy) {
        StreamingCell cell = (StreamingCell)this.cellMap.get(cellnum);
        if (policy == Row.MissingCellPolicy.CREATE_NULL_AS_BLANK) {
            if (cell == null) {
                boolean use1904Dates = this.streamingSheetReader != null && this.streamingSheetReader.isUse1904Dates();
                return new StreamingCell(this.sheet, cellnum, this, use1904Dates);
            }
        } else if (policy == Row.MissingCellPolicy.RETURN_BLANK_AS_NULL && (cell == null || cell.getCellType() == CellType.BLANK)) {
            return null;
        }
        return cell;
    }

    @Override
    public boolean isFormatted() {
        return this.rowStyle != null;
    }

    @Override
    public CellStyle getRowStyle() {
        return this.rowStyle;
    }

    @Override
    public void setRowStyle(CellStyle style) {
        this.rowStyle = style;
    }

    @Override
    public Cell createCell(int column) {
        throw new NotSupportedException();
    }

    @Override
    public Cell createCell(int i, CellType cellType) {
        throw new NotSupportedException();
    }

    @Override
    public void removeCell(Cell cell) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setRowNum(int rowNum) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setHeight(short height) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setZeroHeight(boolean zHeight) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void setHeightInPoints(float height) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public int getOutlineLevel() {
        throw new NotSupportedException();
    }

    @Override
    public void shiftCellsRight(int firstShiftColumnIndex, int lastShiftColumnIndex, int step) {
        throw new NotSupportedException("update operations are not supported");
    }

    @Override
    public void shiftCellsLeft(int firstShiftColumnIndex, int lastShiftColumnIndex, int step) {
        throw new NotSupportedException("update operations are not supported");
    }
}

