/*
 * Decompiled with CFR 0.152.
 */
package shadeio.pjfanning.xlsx.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadeio.pjfanning.xlsx.CloseableIterator;
import shadeio.pjfanning.xlsx.SharedFormula;
import shadeio.pjfanning.xlsx.StreamingReader;
import shadeio.pjfanning.xlsx.exceptions.OpenException;
import shadeio.pjfanning.xlsx.exceptions.ReadException;
import shadeio.pjfanning.xlsx.impl.StreamingCell;
import shadeio.pjfanning.xlsx.impl.StreamingRowIterator;
import shadeio.pjfanning.xlsx.impl.StreamingSheet;
import shadeio.pjfanning.xlsx.impl.StreamingWorkbookReader;
import shadeio.pjfanning.xlsx.impl.XlsxHyperlink;
import shadeio.pjfanning.xlsx.impl.ooxml.HyperlinkData;
import shadeio.poi.ooxml.POIXMLException;
import shadeio.poi.openxml4j.exceptions.InvalidFormatException;
import shadeio.poi.openxml4j.opc.PackagePart;
import shadeio.poi.openxml4j.opc.PackageRelationship;
import shadeio.poi.openxml4j.opc.PackageRelationshipCollection;
import shadeio.poi.ss.usermodel.BuiltinFormats;
import shadeio.poi.ss.usermodel.Row;
import shadeio.poi.ss.usermodel.Workbook;
import shadeio.poi.ss.util.CellAddress;
import shadeio.poi.ss.util.CellRangeAddress;
import shadeio.poi.ss.util.PaneInformation;
import shadeio.poi.util.XMLHelper;
import shadeio.poi.xssf.model.Comments;
import shadeio.poi.xssf.model.SharedStrings;
import shadeio.poi.xssf.model.StylesTable;
import shadeio.poi.xssf.usermodel.XSSFCellStyle;
import shadeio.poi.xssf.usermodel.XSSFDrawing;
import shadeio.poi.xssf.usermodel.XSSFRelation;
import shadeio.poi.xssf.usermodel.XSSFShape;

public class StreamingSheetReader
implements Iterable<Row> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamingSheetReader.class);
    private static XMLInputFactory xmlInputFactory;
    private final StreamingWorkbookReader streamingWorkbookReader;
    private final PackagePart packagePart;
    private final SharedStrings sst;
    private final StylesTable stylesTable;
    private final Comments commentsTable;
    private final boolean use1904Dates;
    private final int rowCacheSize;
    private final Set<Integer> hiddenColumns = new HashSet<Integer>();
    private final Map<Integer, Float> columnWidths = new HashMap<Integer, Float>();
    private final Set<CellRangeAddress> mergedCells = new LinkedHashSet<CellRangeAddress>();
    private final List<StreamingRowIterator> iterators = new ArrayList<StreamingRowIterator>();
    private final Set<HyperlinkData> hyperlinks = new LinkedHashSet<HyperlinkData>();
    private List<XlsxHyperlink> xlsxHyperlinks;
    private Map<String, SharedFormula> sharedFormulaMap;
    private int firstRowNum;
    private int lastRowNum;
    private float defaultRowHeight;
    private int baseColWidth = 8;
    private StreamingSheet sheet;
    private CellAddress activeCell;
    private PaneInformation pane;

    StreamingSheetReader(StreamingWorkbookReader streamingWorkbookReader, PackagePart packagePart, SharedStrings sst, StylesTable stylesTable, Comments commentsTable, boolean use1904Dates, int rowCacheSize) {
        this.streamingWorkbookReader = streamingWorkbookReader;
        this.packagePart = packagePart;
        this.sst = sst;
        this.stylesTable = stylesTable;
        this.commentsTable = commentsTable;
        this.use1904Dates = use1904Dates;
        this.rowCacheSize = rowCacheSize;
    }

    void setSheet(StreamingSheet sheet) {
        this.sheet = sheet;
    }

    void removeIterator(StreamingRowIterator iterator) {
        this.iterators.remove(iterator);
    }

    Map<String, SharedFormula> getSharedFormulaMap() {
        if (this.getBuilder().readSharedFormulas()) {
            if (this.sharedFormulaMap == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.sharedFormulaMap);
        }
        throw new IllegalStateException("The reading of shared formulas has been disabled. Enable using StreamingReader.Builder.");
    }

    void addSharedFormula(String siValue, SharedFormula sharedFormula) {
        if (this.getBuilder().readSharedFormulas()) {
            if (this.sharedFormulaMap == null) {
                this.sharedFormulaMap = new HashMap<String, SharedFormula>();
            }
            this.sharedFormulaMap.put(siValue, sharedFormula);
        }
    }

    SharedFormula removeSharedFormula(String siValue) {
        if (this.sharedFormulaMap != null) {
            return this.sharedFormulaMap.remove(siValue);
        }
        return null;
    }

    boolean isUse1904Dates() {
        return this.use1904Dates;
    }

    float getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    void setDefaultRowHeight(float defaultRowHeight) {
        this.defaultRowHeight = defaultRowHeight;
    }

    int getBaseColWidth() {
        return this.baseColWidth;
    }

    void setBaseColWidth(int baseColWidth) {
        this.baseColWidth = baseColWidth;
    }

    boolean isColumnHidden(int columnIndex) {
        if (this.iterators.isEmpty()) {
            this.iterator();
        }
        return this.hiddenColumns.contains(columnIndex);
    }

    float getColumnWidth(int columnIndex) {
        Float width;
        if (this.iterators.isEmpty()) {
            this.iterator();
        }
        return (width = this.columnWidths.get(columnIndex)) == null ? (float)this.getBaseColWidth() : width.floatValue();
    }

    int getFirstRowNum() {
        if (this.iterators.isEmpty()) {
            this.iterator();
        }
        return this.firstRowNum;
    }

    void setFirstRowNum(int firstRowNum) {
        this.firstRowNum = firstRowNum;
    }

    int getLastRowNum() {
        if (this.iterators.isEmpty()) {
            this.iterator();
        }
        return this.lastRowNum;
    }

    void setLastRowNum(int lastRowNum) {
        this.lastRowNum = lastRowNum;
    }

    void setFormatString(StartElement startElement, StreamingCell cell) {
        Attribute cellStyle = startElement.getAttributeByName(new QName("s"));
        String cellStyleString = cellStyle != null ? cellStyle.getValue() : null;
        XSSFCellStyle style = null;
        if (this.stylesTable != null) {
            if (cellStyleString != null) {
                style = this.stylesTable.getStyleAt(Integer.parseInt(cellStyleString));
            } else if (this.stylesTable.getNumCellStyles() > 0) {
                style = this.stylesTable.getStyleAt(0);
            }
        }
        if (style != null) {
            cell.setNumericFormatIndex(style.getDataFormat());
            String formatString = style.getDataFormatString();
            if (formatString != null) {
                cell.setNumericFormat(formatString);
            } else {
                cell.setNumericFormat(BuiltinFormats.getBuiltinFormat(cell.getNumericFormatIndex().shortValue()));
            }
        } else {
            cell.setNumericFormatIndex(null);
            cell.setNumericFormat(null);
        }
    }

    CellAddress getActiveCell() {
        return this.activeCell;
    }

    void setActiveCell(CellAddress activeCell) {
        this.activeCell = activeCell;
    }

    PaneInformation getPane() {
        if (this.iterators.isEmpty()) {
            this.iterator();
        }
        return this.pane;
    }

    void setPane(PaneInformation pane) {
        this.pane = pane;
    }

    @Override
    public CloseableIterator<Row> iterator() {
        try {
            XMLEventReader parser = StreamingSheetReader.getXmlInputFactory().createXMLEventReader(this.packagePart.getInputStream());
            StreamingRowIterator iterator = new StreamingRowIterator(this, this.sst, this.stylesTable, parser, this.use1904Dates, this.rowCacheSize, this.hiddenColumns, this.columnWidths, this.mergedCells, this.hyperlinks, this.sharedFormulaMap, this.defaultRowHeight, this.sheet);
            this.iterators.add(iterator);
            return iterator;
        }
        catch (IOException e) {
            throw new OpenException("Failed to open stream", e);
        }
        catch (XMLStreamException e) {
            throw new ReadException("Unable to read sheet", e);
        }
    }

    Comments getCellComments() {
        if (!this.streamingWorkbookReader.getBuilder().readComments()) {
            throw new IllegalStateException("getCellComments() only works if StreamingWorking.Builder setReadComments is set to true");
        }
        return this.commentsTable;
    }

    List<CellRangeAddress> getMergedCells() {
        return new ArrayList<CellRangeAddress>(this.mergedCells);
    }

    XSSFDrawing getDrawingPatriarch() {
        Iterator<XSSFShape> shapesIter;
        List<XSSFShape> shapes;
        if (!this.streamingWorkbookReader.getBuilder().readShapes()) {
            throw new IllegalStateException("getDrawingPatriarch() only works if StreamingWorking.Builder setReadShapes is set to true");
        }
        if (this.sheet != null && (shapes = this.streamingWorkbookReader.getShapes(this.sheet.getSheetName())) != null && (shapesIter = shapes.iterator()).hasNext()) {
            return shapesIter.next().getDrawing();
        }
        return null;
    }

    public void close() {
        this.iterators.forEach(iter -> iter.close(false));
    }

    StreamingReader.Builder getBuilder() {
        return this.streamingWorkbookReader.getBuilder();
    }

    Workbook getWorkbook() {
        return this.streamingWorkbookReader.getWorkbook();
    }

    List<XlsxHyperlink> getHyperlinks() {
        if (!this.getBuilder().readHyperlinks()) {
            throw new IllegalStateException("getHyperlinks() only works if StreamingWorking.Builder setReadHyperlinks is set to true");
        }
        this.initHyperlinks();
        return this.xlsxHyperlinks;
    }

    private void initHyperlinks() {
        if (this.xlsxHyperlinks == null || this.xlsxHyperlinks.isEmpty()) {
            ArrayList<XlsxHyperlink> links = new ArrayList<XlsxHyperlink>();
            try {
                PackageRelationshipCollection hyperRels = this.packagePart.getRelationshipsByType(XSSFRelation.SHEET_HYPERLINKS.getRelation());
                for (HyperlinkData hyperlink : this.hyperlinks) {
                    PackageRelationship hyperRel = null;
                    if (hyperlink.getId() != null) {
                        hyperRel = hyperRels.getRelationshipByID(hyperlink.getId());
                    }
                    links.add(new XlsxHyperlink(hyperlink, hyperRel));
                }
            }
            catch (InvalidFormatException e) {
                throw new POIXMLException(e);
            }
            this.xlsxHyperlinks = links;
        }
    }

    private static XMLInputFactory getXmlInputFactory() {
        if (xmlInputFactory == null) {
            try {
                xmlInputFactory = XMLHelper.newXMLInputFactory();
            }
            catch (Exception e) {
                LOG.error("Issue creating XMLInputFactory", (Throwable)e);
                throw e;
            }
        }
        return xmlInputFactory;
    }
}

