/*
 * Decompiled with CFR 0.152.
 */
package shadeio.pjfanning.xlsx.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import shadeio.pjfanning.xlsx.exceptions.MissingSheetException;
import shadeio.pjfanning.xlsx.exceptions.ReadException;
import shadeio.pjfanning.xlsx.impl.StreamingSheet;
import shadeio.pjfanning.xlsx.impl.StreamingWorkbookReader;
import shadeio.pjfanning.xlsx.impl.XlsxPictureData;
import shadeio.poi.ooxml.POIXMLProperties;
import shadeio.poi.openxml4j.opc.PackagePart;
import shadeio.poi.ss.SpreadsheetVersion;
import shadeio.poi.ss.formula.EvaluationWorkbook;
import shadeio.poi.ss.formula.udf.UDFFinder;
import shadeio.poi.ss.usermodel.CellReferenceType;
import shadeio.poi.ss.usermodel.CellStyle;
import shadeio.poi.ss.usermodel.CreationHelper;
import shadeio.poi.ss.usermodel.DataFormat;
import shadeio.poi.ss.usermodel.Date1904Support;
import shadeio.poi.ss.usermodel.Font;
import shadeio.poi.ss.usermodel.Name;
import shadeio.poi.ss.usermodel.PictureData;
import shadeio.poi.ss.usermodel.Row;
import shadeio.poi.ss.usermodel.Sheet;
import shadeio.poi.ss.usermodel.SheetVisibility;
import shadeio.poi.ss.usermodel.Workbook;
import shadeio.poi.xssf.usermodel.XSSFPictureData;

public class StreamingWorkbook
implements Workbook,
Date1904Support,
AutoCloseable {
    private final StreamingWorkbookReader reader;
    private POIXMLProperties.CoreProperties coreProperties = null;
    private List<XSSFPictureData> pictures;

    public StreamingWorkbook(StreamingWorkbookReader reader) {
        this.reader = reader;
        reader.setWorkbook(this);
    }

    int findSheetByName(String name) {
        List<Map<String, String>> props = this.reader.getSheetProperties();
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            if (!name.equalsIgnoreCase(props.get(i).get("name"))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<Sheet> iterator() {
        return this.reader.iterator();
    }

    @Override
    public Iterator<Sheet> sheetIterator() {
        return this.iterator();
    }

    @Override
    public Spliterator<Sheet> spliterator() {
        return this.reader.spliterator();
    }

    @Override
    public String getSheetName(int sheet) {
        return this.reader.getSheetProperties().get(sheet).get("name");
    }

    @Override
    public int getSheetIndex(String name) {
        return this.findSheetByName(name);
    }

    @Override
    public int getSheetIndex(Sheet sheet) {
        if (sheet instanceof StreamingSheet) {
            return this.findSheetByName(sheet.getSheetName());
        }
        throw new UnsupportedOperationException("Cannot use non-StreamingSheet sheets");
    }

    @Override
    public int getNumberOfSheets() {
        return this.reader.getSheetProperties().size();
    }

    @Override
    public Sheet getSheetAt(int index) {
        try {
            return this.reader.getSheetAt(index);
        }
        catch (IOException | XMLStreamException e) {
            throw new ReadException(e);
        }
    }

    @Override
    public Sheet getSheet(String name) {
        try {
            return this.reader.getSheet(name);
        }
        catch (IOException | XMLStreamException e) {
            throw new ReadException(e);
        }
        catch (NoSuchElementException nse) {
            throw new MissingSheetException("Failed to find sheet: " + name);
        }
    }

    @Override
    public boolean isSheetHidden(int sheetIx) {
        return "hidden".equals(this.reader.getSheetProperties().get(sheetIx).get("state"));
    }

    @Override
    public boolean isSheetVeryHidden(int sheetIx) {
        return "veryHidden".equals(this.reader.getSheetProperties().get(sheetIx).get("state"));
    }

    @Override
    public SpreadsheetVersion getSpreadsheetVersion() {
        return SpreadsheetVersion.EXCEL2007;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public POIXMLProperties.CoreProperties getCoreProperties() {
        if (this.reader.getBuilder().readCoreProperties()) {
            return this.coreProperties;
        }
        throw new IllegalStateException("getCoreProperties() only works if StreamingWorking.Builder setReadCoreProperties is set to true");
    }

    void setCoreProperties(POIXMLProperties.CoreProperties coreProperties) {
        this.coreProperties = coreProperties;
    }

    @Override
    public List<? extends PictureData> getAllPictures() {
        if (this.pictures == null) {
            List<PackagePart> mediaParts = this.reader.getOPCPackage().getPartsByName(Pattern.compile("/xl/media/.*?"));
            this.pictures = new ArrayList<XSSFPictureData>(mediaParts.size());
            for (PackagePart part : mediaParts) {
                this.pictures.add(new XlsxPictureData(part));
            }
        }
        return Collections.unmodifiableList(this.pictures);
    }

    @Override
    public boolean isDate1904() {
        return this.reader.isDate1904();
    }

    @Override
    public int getActiveSheetIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setActiveSheet(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFirstVisibleTab() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFirstVisibleTab(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetOrder(String sheetname, int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedTab(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetName(int sheet, String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sheet createSheet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sheet createSheet(String sheetname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sheet cloneSheet(int sheetNum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSheetAt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Font createFont() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Font findFont(boolean b, short i, short i1, String s, boolean b1, boolean b2, short i2, byte b3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfFonts() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfFontsAsInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Font getFontAt(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellStyle createCellStyle() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumCellStyles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellStyle getCellStyleAt(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name getName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends Name> getNames(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends Name> getAllNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name createName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeName(Name name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int linkExternalWorkbook(String name, Workbook workbook) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrintArea(int sheetIndex, String reference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPrintArea(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removePrintArea(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Row.MissingCellPolicy getMissingCellPolicy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataFormat createDataFormat() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int addPicture(byte[] pictureData, int format) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CreationHelper getCreationHelper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHidden() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHidden(boolean hiddenFlag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetHidden(int sheetIx, boolean hidden) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SheetVisibility getSheetVisibility(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetVisibility(int i, SheetVisibility sheetVisibility) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolPack(UDFFinder toopack) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setForceFormulaRecalculation(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int addOlePackage(byte[] bytes, String s, String s1, String s2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EvaluationWorkbook createEvaluationWorkbook() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellReferenceType getCellReferenceType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCellReferenceType(CellReferenceType cellReferenceType) {
        throw new UnsupportedOperationException();
    }
}

