/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.record;

import shadeio.commons.io.input.UnsynchronizedByteArrayInputStream;
import shadeio.poi.common.Duplicatable;
import shadeio.poi.common.usermodel.GenericRecord;
import shadeio.poi.hssf.record.HSSFRecordTypes;
import shadeio.poi.hssf.record.RecordBase;
import shadeio.poi.hssf.record.RecordFactory;
import shadeio.poi.hssf.record.RecordInputStream;
import shadeio.poi.util.GenericRecordJsonWriter;

public abstract class Record
extends RecordBase
implements Duplicatable,
GenericRecord {
    protected Record() {
    }

    protected Record(Record other) {
    }

    public final byte[] serialize() {
        byte[] retval = new byte[this.getRecordSize()];
        this.serialize(0, retval);
        return retval;
    }

    public final String toString() {
        return GenericRecordJsonWriter.marshal(this);
    }

    public abstract short getSid();

    public Record cloneViaReserialise() {
        byte[] b = this.serialize();
        RecordInputStream rinp = new RecordInputStream(new UnsynchronizedByteArrayInputStream(b));
        rinp.nextRecord();
        Record[] r = RecordFactory.createRecord(rinp);
        if (r.length != 1) {
            throw new IllegalStateException("Re-serialised a record to clone it, but got " + r.length + " records back!");
        }
        return r[0];
    }

    @Override
    public abstract Record copy();

    public abstract HSSFRecordTypes getGenericRecordType();
}

