/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.usermodel;

import java.util.Map;
import shadeio.poi.hssf.usermodel.HSSFCell;
import shadeio.poi.hssf.usermodel.HSSFEvaluationCell;
import shadeio.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import shadeio.poi.hssf.usermodel.HSSFRichTextString;
import shadeio.poi.hssf.usermodel.HSSFWorkbook;
import shadeio.poi.ss.formula.BaseFormulaEvaluator;
import shadeio.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import shadeio.poi.ss.formula.IStabilityClassifier;
import shadeio.poi.ss.formula.WorkbookEvaluator;
import shadeio.poi.ss.formula.eval.BoolEval;
import shadeio.poi.ss.formula.eval.ErrorEval;
import shadeio.poi.ss.formula.eval.NumericValueEval;
import shadeio.poi.ss.formula.eval.StringValueEval;
import shadeio.poi.ss.formula.eval.ValueEval;
import shadeio.poi.ss.formula.udf.UDFFinder;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.CellValue;
import shadeio.poi.ss.usermodel.FormulaEvaluator;
import shadeio.poi.ss.usermodel.RichTextString;
import shadeio.poi.ss.usermodel.Workbook;

public class HSSFFormulaEvaluator
extends BaseFormulaEvaluator {
    private final HSSFWorkbook _book;

    public HSSFFormulaEvaluator(HSSFWorkbook workbook) {
        this(workbook, null);
    }

    public HSSFFormulaEvaluator(HSSFWorkbook workbook, IStabilityClassifier stabilityClassifier) {
        this(workbook, stabilityClassifier, null);
    }

    private HSSFFormulaEvaluator(HSSFWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        super(new WorkbookEvaluator(HSSFEvaluationWorkbook.create(workbook), stabilityClassifier, udfFinder));
        this._book = workbook;
    }

    public static HSSFFormulaEvaluator create(HSSFWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        return new HSSFFormulaEvaluator(workbook, stabilityClassifier, udfFinder);
    }

    @Override
    protected RichTextString createRichTextString(String str) {
        return new HSSFRichTextString(str);
    }

    public static void setupEnvironment(String[] workbookNames, HSSFFormulaEvaluator[] evaluators) {
        BaseFormulaEvaluator.setupEnvironment(workbookNames, evaluators);
    }

    @Override
    public void setupReferencedWorkbooks(Map<String, FormulaEvaluator> evaluators) {
        CollaboratingWorkbooksEnvironment.setupFormulaEvaluator(evaluators);
    }

    public void notifyUpdateCell(HSSFCell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell(cell));
    }

    @Override
    public void notifyUpdateCell(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell((HSSFCell)cell));
    }

    public void notifyDeleteCell(HSSFCell cell) {
        this._bookEvaluator.notifyDeleteCell(new HSSFEvaluationCell(cell));
    }

    @Override
    public void notifyDeleteCell(Cell cell) {
        this._bookEvaluator.notifyDeleteCell(new HSSFEvaluationCell((HSSFCell)cell));
    }

    @Override
    public void notifySetFormula(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell((HSSFCell)cell));
    }

    @Override
    public HSSFCell evaluateInCell(Cell cell) {
        return (HSSFCell)super.evaluateInCell(cell);
    }

    public static void evaluateAllFormulaCells(HSSFWorkbook wb) {
        HSSFFormulaEvaluator.evaluateAllFormulaCells(wb, new HSSFFormulaEvaluator(wb));
    }

    public static void evaluateAllFormulaCells(Workbook wb) {
        BaseFormulaEvaluator.evaluateAllFormulaCells(wb);
    }

    @Override
    public void evaluateAll() {
        HSSFFormulaEvaluator.evaluateAllFormulaCells(this._book, this);
    }

    @Override
    protected CellValue evaluateFormulaCellValue(Cell cell) {
        ValueEval eval = this._bookEvaluator.evaluate(new HSSFEvaluationCell((HSSFCell)cell));
        if (eval instanceof BoolEval) {
            BoolEval be = (BoolEval)eval;
            return CellValue.valueOf(be.getBooleanValue());
        }
        if (eval instanceof NumericValueEval) {
            NumericValueEval ne = (NumericValueEval)eval;
            return new CellValue(ne.getNumberValue());
        }
        if (eval instanceof StringValueEval) {
            StringValueEval ne = (StringValueEval)eval;
            return new CellValue(ne.getStringValue());
        }
        if (eval instanceof ErrorEval) {
            return CellValue.getError(((ErrorEval)eval).getErrorCode());
        }
        throw new RuntimeException("Unexpected eval class (" + eval.getClass().getName() + ")");
    }

    @Override
    public void setIgnoreMissingWorkbooks(boolean ignore) {
        this._bookEvaluator.setIgnoreMissingWorkbooks(ignore);
    }

    @Override
    public void setDebugEvaluationOutputForNextEval(boolean value) {
        this._bookEvaluator.setDebugEvaluationOutputForNextEval(value);
    }
}

