/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.usermodel.helpers;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Unbox;
import shadeio.poi.hssf.usermodel.HSSFCell;
import shadeio.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import shadeio.poi.hssf.usermodel.HSSFRow;
import shadeio.poi.hssf.usermodel.HSSFSheet;
import shadeio.poi.hssf.usermodel.HSSFWorkbook;
import shadeio.poi.ss.formula.FormulaParseException;
import shadeio.poi.ss.formula.FormulaParser;
import shadeio.poi.ss.formula.FormulaRenderer;
import shadeio.poi.ss.formula.FormulaShifter;
import shadeio.poi.ss.formula.FormulaType;
import shadeio.poi.ss.formula.ptg.Ptg;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.Row;
import shadeio.poi.ss.usermodel.Sheet;
import shadeio.poi.ss.usermodel.Workbook;
import shadeio.poi.util.Internal;

@Internal
final class HSSFRowColShifter {
    private static final Logger LOG = LogManager.getLogger(HSSFRowColShifter.class);

    private HSSFRowColShifter() {
    }

    static void updateFormulas(Sheet sheet, FormulaShifter formulaShifter) {
        HSSFRowColShifter.updateSheetFormulas(sheet, formulaShifter);
        Workbook wb = sheet.getWorkbook();
        for (Sheet sh : wb) {
            if (sheet == sh) continue;
            HSSFRowColShifter.updateSheetFormulas(sh, formulaShifter);
        }
    }

    static void updateSheetFormulas(Sheet sh, FormulaShifter formulashifter) {
        for (Row r : sh) {
            HSSFRow row = (HSSFRow)r;
            HSSFRowColShifter.updateRowFormulas(row, formulashifter);
        }
    }

    static void updateRowFormulas(HSSFRow row, FormulaShifter formulaShifter) {
        HSSFSheet sheet = row.getSheet();
        for (Cell c : row) {
            HSSFCell cell = (HSSFCell)c;
            String formula = cell.getCellFormula();
            if (formula.length() <= 0) continue;
            String shiftedFormula = HSSFRowColShifter.shiftFormula(row, formula, formulaShifter);
            cell.setCellFormula(shiftedFormula);
        }
    }

    static String shiftFormula(Row row, String formula, FormulaShifter formulaShifter) {
        Sheet sheet = row.getSheet();
        Workbook wb = sheet.getWorkbook();
        int sheetIndex = wb.getSheetIndex(sheet);
        int rowIndex = row.getRowNum();
        HSSFEvaluationWorkbook fpb = HSSFEvaluationWorkbook.create((HSSFWorkbook)wb);
        try {
            Ptg[] ptgs = FormulaParser.parse(formula, fpb, FormulaType.CELL, sheetIndex, rowIndex);
            String shiftedFmla = formulaShifter.adjustFormula(ptgs, sheetIndex) ? FormulaRenderer.toFormulaString(fpb, ptgs) : formula;
            return shiftedFmla;
        }
        catch (FormulaParseException fpe) {
            LOG.atWarn().withThrowable((Throwable)fpe).log("Error shifting formula on row {}", (Object)Unbox.box((int)row.getRowNum()));
            return formula;
        }
    }
}

