/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.poifs.filesystem;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import shadeio.poi.EncryptedDocumentException;
import shadeio.poi.poifs.crypt.Decryptor;
import shadeio.poi.poifs.crypt.EncryptionInfo;
import shadeio.poi.poifs.filesystem.DirectoryNode;
import shadeio.poi.poifs.filesystem.FileMagic;
import shadeio.poi.poifs.filesystem.POIFSFileSystem;
import shadeio.poi.util.Internal;
import shadeio.poi.util.Removal;

@Internal
public final class DocumentFactoryHelper {
    private DocumentFactoryHelper() {
    }

    public static InputStream getDecryptedStream(final POIFSFileSystem fs, String password) throws IOException {
        return new FilterInputStream(DocumentFactoryHelper.getDecryptedStream(fs.getRoot(), password)){

            @Override
            public void close() throws IOException {
                fs.close();
                super.close();
            }
        };
    }

    public static InputStream getDecryptedStream(DirectoryNode root, String password) throws IOException {
        if (root.hasEntry("Package")) {
            return root.createDocumentInputStream("Package");
        }
        EncryptionInfo info = new EncryptionInfo(root);
        Decryptor d = Decryptor.getInstance(info);
        try {
            boolean passwordCorrect = false;
            if (password != null && d.verifyPassword(password)) {
                passwordCorrect = true;
            }
            if (!passwordCorrect && d.verifyPassword("VelvetSweatshop")) {
                passwordCorrect = true;
            }
            if (passwordCorrect) {
                return d.getDataStream(root);
            }
            if (password != null) {
                throw new EncryptedDocumentException("Password incorrect");
            }
            throw new EncryptedDocumentException("The supplied spreadsheet is protected, but no password was supplied");
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    @Removal(version="4.0")
    public static boolean hasOOXMLHeader(InputStream inp) throws IOException {
        return FileMagic.valueOf(inp) == FileMagic.OOXML;
    }
}

