/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.ss.formula.functions;

import shadeio.poi.ss.formula.OperationEvaluationContext;
import shadeio.poi.ss.formula.eval.ErrorEval;
import shadeio.poi.ss.formula.eval.EvaluationException;
import shadeio.poi.ss.formula.eval.NumberEval;
import shadeio.poi.ss.formula.eval.OperandResolver;
import shadeio.poi.ss.formula.eval.ValueEval;
import shadeio.poi.ss.formula.functions.Fixed1ArgFunction;
import shadeio.poi.ss.formula.functions.FreeRefFunction;
import shadeio.poi.ss.formula.functions.NormInv;

public final class NormSInv
extends Fixed1ArgFunction
implements FreeRefFunction {
    public static final NormSInv instance = new NormSInv();

    private NormSInv() {
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg1) {
        try {
            Double probability = NormSInv.evaluateValue(arg1, srcRowIndex, srcColumnIndex);
            if (probability == null) {
                return ErrorEval.VALUE_INVALID;
            }
            if (probability <= 0.0 || probability >= 1.0) {
                return ErrorEval.NUM_ERROR;
            }
            return new NumberEval(NormInv.inverse(probability, 0.0, 1.0));
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        if (args.length == 1) {
            return this.evaluate(ec.getRowIndex(), ec.getColumnIndex(), args[0]);
        }
        return ErrorEval.VALUE_INVALID;
    }

    private static Double evaluateValue(ValueEval arg, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
        ValueEval veText = OperandResolver.getSingleValue(arg, srcRowIndex, srcColumnIndex);
        String strText1 = OperandResolver.coerceValueToString(veText);
        return OperandResolver.parseDouble(strText1);
    }
}

