/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xssf.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.SAXException;
import shadeio.poi.openxml4j.exceptions.OpenXML4JException;
import shadeio.poi.openxml4j.opc.OPCPackage;
import shadeio.poi.ss.usermodel.DataFormatter;
import shadeio.poi.xssf.binary.XSSFBCommentsTable;
import shadeio.poi.xssf.binary.XSSFBHyperlinksTable;
import shadeio.poi.xssf.binary.XSSFBSharedStringsTable;
import shadeio.poi.xssf.binary.XSSFBSheetHandler;
import shadeio.poi.xssf.binary.XSSFBStylesTable;
import shadeio.poi.xssf.eventusermodel.XSSFBReader;
import shadeio.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import shadeio.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import shadeio.poi.xssf.model.SharedStrings;
import shadeio.poi.xssf.usermodel.XSSFRelation;

public class XSSFBEventBasedExcelExtractor
extends XSSFEventBasedExcelExtractor {
    private static final Logger LOGGER = LogManager.getLogger(XSSFBEventBasedExcelExtractor.class);
    public static final List<XSSFRelation> SUPPORTED_TYPES = Collections.singletonList(XSSFRelation.XLSB_BINARY_WORKBOOK);
    private boolean handleHyperlinksInCells;

    public XSSFBEventBasedExcelExtractor(String path) throws XmlException, OpenXML4JException, IOException {
        super(path);
    }

    public XSSFBEventBasedExcelExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        super(container);
    }

    public void setHandleHyperlinksInCells(boolean handleHyperlinksInCells) {
        this.handleHyperlinksInCells = handleHyperlinksInCells;
    }

    @Override
    public void setFormulasNotResults(boolean formulasNotResults) {
        throw new IllegalArgumentException("Not currently supported");
    }

    public void processSheet(XSSFSheetXMLHandler.SheetContentsHandler sheetContentsExtractor, XSSFBStylesTable styles, XSSFBCommentsTable comments, SharedStrings strings, InputStream sheetInputStream) throws IOException {
        DataFormatter formatter = this.getLocale() == null ? new DataFormatter() : new DataFormatter(this.getLocale());
        XSSFBSheetHandler xssfbSheetHandler = new XSSFBSheetHandler(sheetInputStream, styles, comments, strings, sheetContentsExtractor, formatter, this.getFormulasNotResults());
        xssfbSheetHandler.parse();
    }

    @Override
    public String getText() {
        try {
            XSSFBSharedStringsTable strings = new XSSFBSharedStringsTable(this.getPackage());
            XSSFBReader xssfbReader = new XSSFBReader(this.getPackage());
            XSSFBStylesTable styles = xssfbReader.getXSSFBStylesTable();
            XSSFBReader.SheetIterator iter = (XSSFBReader.SheetIterator)xssfbReader.getSheetsData();
            StringBuilder text = new StringBuilder(64);
            XSSFEventBasedExcelExtractor.SheetTextExtractor sheetExtractor = new XSSFEventBasedExcelExtractor.SheetTextExtractor(this);
            XSSFBHyperlinksTable hyperlinksTable = null;
            while (iter.hasNext()) {
                InputStream stream = iter.next();
                Throwable throwable = null;
                try {
                    if (this.getIncludeSheetNames()) {
                        text.append(iter.getSheetName());
                        text.append('\n');
                    }
                    if (this.handleHyperlinksInCells) {
                        hyperlinksTable = new XSSFBHyperlinksTable(iter.getSheetPart());
                    }
                    XSSFBCommentsTable comments = this.getIncludeCellComments() ? iter.getXSSFBSheetComments() : null;
                    this.processSheet((XSSFSheetXMLHandler.SheetContentsHandler)sheetExtractor, styles, comments, (SharedStrings)strings, stream);
                    if (this.getIncludeHeadersFooters()) {
                        sheetExtractor.appendHeaderText(text);
                    }
                    sheetExtractor.appendCellText(text);
                    if (this.getIncludeTextBoxes()) {
                        this.processShapes(iter.getShapes(), text);
                    }
                    if (this.getIncludeHeadersFooters()) {
                        sheetExtractor.appendFooterText(text);
                    }
                    sheetExtractor.reset();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            return text.toString();
        }
        catch (IOException | SAXException | OpenXML4JException e) {
            LOGGER.atWarn().withThrowable((Throwable)e).log("Failed to load text");
            return "";
        }
    }
}

