/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xssf.streaming;

import shadeio.poi.ss.formula.EvaluationCell;
import shadeio.poi.ss.formula.EvaluationSheet;
import shadeio.poi.ss.formula.FormulaParser;
import shadeio.poi.ss.formula.FormulaType;
import shadeio.poi.ss.formula.ptg.Ptg;
import shadeio.poi.util.Internal;
import shadeio.poi.xssf.streaming.SXSSFCell;
import shadeio.poi.xssf.streaming.SXSSFEvaluationCell;
import shadeio.poi.xssf.streaming.SXSSFEvaluationSheet;
import shadeio.poi.xssf.streaming.SXSSFSheet;
import shadeio.poi.xssf.streaming.SXSSFWorkbook;
import shadeio.poi.xssf.usermodel.BaseXSSFEvaluationWorkbook;

@Internal
public final class SXSSFEvaluationWorkbook
extends BaseXSSFEvaluationWorkbook {
    private final SXSSFWorkbook _sxssfBook;

    public static SXSSFEvaluationWorkbook create(SXSSFWorkbook book) {
        if (book == null) {
            return null;
        }
        return new SXSSFEvaluationWorkbook(book);
    }

    private SXSSFEvaluationWorkbook(SXSSFWorkbook book) {
        super(book.getXSSFWorkbook());
        this._sxssfBook = book;
    }

    @Override
    public int getSheetIndex(EvaluationSheet evalSheet) {
        SXSSFSheet sheet = ((SXSSFEvaluationSheet)evalSheet).getSXSSFSheet();
        return this._sxssfBook.getSheetIndex(sheet);
    }

    @Override
    public EvaluationSheet getSheet(int sheetIndex) {
        return new SXSSFEvaluationSheet(this._sxssfBook.getSheetAt(sheetIndex));
    }

    @Override
    public Ptg[] getFormulaTokens(EvaluationCell evalCell) {
        SXSSFCell cell = ((SXSSFEvaluationCell)evalCell).getSXSSFCell();
        return FormulaParser.parse(cell.getCellFormula(), this, FormulaType.CELL, this._sxssfBook.getSheetIndex(cell.getSheet()));
    }
}

