/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xssf.usermodel;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataBar;
import shadeio.poi.ss.usermodel.Color;
import shadeio.poi.ss.usermodel.DataBarFormatting;
import shadeio.poi.xssf.usermodel.IndexedColorMap;
import shadeio.poi.xssf.usermodel.XSSFColor;
import shadeio.poi.xssf.usermodel.XSSFConditionalFormattingThreshold;

public class XSSFDataBarFormatting
implements DataBarFormatting {
    IndexedColorMap _colorMap;
    CTDataBar _databar;

    XSSFDataBarFormatting(CTDataBar databar, IndexedColorMap colorMap) {
        this._databar = databar;
        this._colorMap = colorMap;
    }

    @Override
    public boolean isIconOnly() {
        if (this._databar.isSetShowValue()) {
            return !this._databar.getShowValue();
        }
        return false;
    }

    @Override
    public void setIconOnly(boolean only) {
        this._databar.setShowValue(!only);
    }

    @Override
    public boolean isLeftToRight() {
        return true;
    }

    @Override
    public void setLeftToRight(boolean ltr) {
    }

    @Override
    public int getWidthMin() {
        return (int)this._databar.getMinLength();
    }

    @Override
    public void setWidthMin(int width) {
        this._databar.setMinLength((long)width);
    }

    @Override
    public int getWidthMax() {
        return (int)this._databar.getMaxLength();
    }

    @Override
    public void setWidthMax(int width) {
        this._databar.setMaxLength((long)width);
    }

    @Override
    public XSSFColor getColor() {
        return XSSFColor.from(this._databar.getColor(), this._colorMap);
    }

    @Override
    public void setColor(Color color) {
        this._databar.setColor(((XSSFColor)color).getCTColor());
    }

    @Override
    public XSSFConditionalFormattingThreshold getMinThreshold() {
        return new XSSFConditionalFormattingThreshold(this._databar.getCfvoArray(0));
    }

    @Override
    public XSSFConditionalFormattingThreshold getMaxThreshold() {
        return new XSSFConditionalFormattingThreshold(this._databar.getCfvoArray(1));
    }

    public XSSFConditionalFormattingThreshold createThreshold() {
        return new XSSFConditionalFormattingThreshold(this._databar.addNewCfvo());
    }
}

