/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xwpf.usermodel;

import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;
import shadeio.poi.ooxml.POIXMLDocumentPart;
import shadeio.poi.openxml4j.opc.PackageRelationship;
import shadeio.poi.util.Units;
import shadeio.poi.xwpf.usermodel.XWPFPictureData;
import shadeio.poi.xwpf.usermodel.XWPFRun;

public class XWPFPicture {
    private final CTPicture ctPic;
    private final String description;
    private final XWPFRun run;

    public XWPFPicture(CTPicture ctPic, XWPFRun run) {
        this.run = run;
        this.ctPic = ctPic;
        this.description = ctPic.getNvPicPr().getCNvPr().getDescr();
    }

    public void setPictureReference(PackageRelationship rel) {
        this.ctPic.getBlipFill().getBlip().setEmbed(rel.getId());
    }

    public CTPicture getCTPicture() {
        return this.ctPic;
    }

    public XWPFPictureData getPictureData() {
        POIXMLDocumentPart relatedPart;
        CTBlipFillProperties blipProps = this.ctPic.getBlipFill();
        if (blipProps == null || !blipProps.isSetBlip()) {
            return null;
        }
        String blipId = blipProps.getBlip().getEmbed();
        POIXMLDocumentPart part = this.run.getParent().getPart();
        if (part != null && (relatedPart = part.getRelationById(blipId)) instanceof XWPFPictureData) {
            return (XWPFPictureData)relatedPart;
        }
        return null;
    }

    public double getWidth() {
        return Units.toPoints(this.ctPic.getSpPr().getXfrm().getExt().getCx());
    }

    public double getDepth() {
        return Units.toPoints(this.ctPic.getSpPr().getXfrm().getExt().getCy());
    }

    public String getDescription() {
        return this.description;
    }
}

