/*
 * Decompiled with CFR 0.152.
 */
package com.crealytics.spark.v2.excel;

import com.crealytics.spark.v2.excel.DataLocator;
import com.crealytics.spark.v2.excel.DataLocator$;
import com.crealytics.spark.v2.excel.ExcelHelper$;
import com.crealytics.spark.v2.excel.ExcelOptions;
import com.crealytics.spark.v2.excel.PlainNumberFormat$;
import com.github.pjfanning.xlsx.StreamingReader;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.text.Format;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\n\u0014\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006U\u0001!Ia\u000b\u0005\t]\u0001A)\u0019!C\u0005_!)a\b\u0001C\u0001\u007f!)\u0001\u000b\u0001C\u0001#\")\u0001\u000e\u0001C\u0001S\")\u0001\u0010\u0001C\u0001s\")Q\u0010\u0001C\u0001}\u001e9\u00111B\n\t\u0002\u00055aA\u0002\n\u0014\u0011\u0003\ty\u0001\u0003\u0004+\u0015\u0011\u0005\u0011\u0011\u0003\u0005\n\u0003'Q!\u0019!C\u0005\u0003+A\u0001\"!\u000b\u000bA\u0003%\u0011q\u0003\u0005\n\u0003WQ!\u0019!C\u0005\u0003+A\u0001\"!\f\u000bA\u0003%\u0011q\u0003\u0005\b\u0003_QA\u0011AA\u0019\u0011\u001d\t)D\u0003C\u0001\u0003o\u00111\"\u0012=dK2DU\r\u001c9fe*\u0011A#F\u0001\u0006Kb\u001cW\r\u001c\u0006\u0003-]\t!A\u001e\u001a\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003)\u0019'/Z1msRL7m\u001d\u0006\u00029\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\u000f=\u0004H/[8ogB\u0011q\u0005K\u0007\u0002'%\u0011\u0011f\u0005\u0002\r\u000bb\u001cW\r\\(qi&|gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051j\u0003CA\u0014\u0001\u0011\u0015)#\u00011\u0001'\u00035!\u0017\r^1G_Jl\u0017\r\u001e;feV\t\u0001\u0007\u0005\u00022y5\t!G\u0003\u00024i\u0005IQo]3s[>$W\r\u001c\u0006\u0003kY\n!a]:\u000b\u0005]B\u0014a\u00019pS*\u0011\u0011HO\u0001\u0007CB\f7\r[3\u000b\u0003m\n1a\u001c:h\u0013\ti$GA\u0007ECR\fgi\u001c:nCR$XM]\u0001\u0014g\u00064WmQ3mYN#(/\u001b8h-\u0006dW/\u001a\u000b\u0003\u0001.\u0003\"!\u0011%\u000f\u0005\t3\u0005CA\"\"\u001b\u0005!%BA#\u001e\u0003\u0019a$o\\8u}%\u0011q)I\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002HC!)A\n\u0002a\u0001\u001b\u0006!1-\u001a7m!\t\td*\u0003\u0002Pe\t!1)\u001a7m\u0003-9W\r^,pe.\u0014wn\\6\u0015\u0007I+f\f\u0005\u00022'&\u0011AK\r\u0002\t/>\u00148NY8pW\")a+\u0002a\u0001/\u0006!1m\u001c8g!\tAF,D\u0001Z\u0015\t1&L\u0003\u0002\\q\u00051\u0001.\u00193p_BL!!X-\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015yV\u00011\u0001a\u0003\r)(/\u001b\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\f1A\\3u\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\u0007U\u0013\u0016*A\u0004hKR\u0014vn^:\u0015\u0007)4x\u000fE\u0002laNt!\u0001\u001c8\u000f\u0005\rk\u0017\"\u0001\u0012\n\u0005=\f\u0013a\u00029bG.\fw-Z\u0005\u0003cJ\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003_\u0006\u00022a\u001b;N\u0013\t)(O\u0001\u0004WK\u000e$xN\u001d\u0005\u0006-\u001a\u0001\ra\u0016\u0005\u0006?\u001a\u0001\r\u0001Y\u0001\u000fO\u0016$8i\u001c7v[:t\u0015-\\3t)\tQ8\u0010E\u0002li\u0002CQ\u0001`\u0004A\u0002M\f\u0001BZ5sgR\u0014vn^\u0001\u0013a\u0006\u00148/\u001a3SC:<W-\u00113ee\u0016\u001c8\u000fF\u0001\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003i\u0005!Q\u000f^5m\u0013\u0011\tI!a\u0001\u0003\u001b\u0005\u0013X-\u0019*fM\u0016\u0014XM\\2f\u0003-)\u0005pY3m\u0011\u0016d\u0007/\u001a:\u0011\u0005\u001dR1C\u0001\u0006 )\t\ti!A\nd_:4\u0017nZ;sCRLwN\u001c(fK\u0012,G-\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0013\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011AB1u_6L7M\u0003\u0003\u0002\"\u0005\r\u0012AC2p]\u000e,(O]3oi*\u0019\u0011Q\u00013\n\t\u0005\u001d\u00121\u0004\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002)\r|gNZ5hkJ\fG/[8o\u001d\u0016,G-\u001a3!\u0003M\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u001bHi\u001c8f\u0003Q\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u001bHi\u001c8fA\u0005)\u0011\r\u001d9msR\u0019A&a\r\t\u000b\u0015\u0002\u0002\u0019\u0001\u0014\u0002-\r|gNZ5hkJ,\u0007K]8wS\u0012,'o](oG\u0016$\"!!\u000f\u0011\u0007\u0001\nY$C\u0002\u0002>\u0005\u0012A!\u00168ji\u0002")
public class ExcelHelper {
    private DataFormatter dataFormatter;
    private final ExcelOptions options;
    private volatile boolean bitmap$0;

    public static void configureProvidersOnce() {
        ExcelHelper$.MODULE$.configureProvidersOnce();
    }

    public static ExcelHelper apply(ExcelOptions options) {
        return ExcelHelper$.MODULE$.apply(options);
    }

    /*
     * WARNING - void declaration
     */
    private DataFormatter dataFormatter$lzycompute() {
        ExcelHelper excelHelper = this;
        synchronized (excelHelper) {
            if (!this.bitmap$0) {
                void var2_2;
                DataFormatter r = new DataFormatter();
                if (this.options.usePlainNumberFormat()) {
                    PlainNumberFormat$ plainNumberFormat = PlainNumberFormat$.MODULE$;
                    r.addFormat("General", (Format)plainNumberFormat);
                    r.addFormat("@", (Format)plainNumberFormat);
                }
                this.dataFormatter = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.dataFormatter;
    }

    private DataFormatter dataFormatter() {
        if (!this.bitmap$0) {
            return this.dataFormatter$lzycompute();
        }
        return this.dataFormatter;
    }

    public String safeCellStringValue(Cell cell) {
        CellType cellType = cell.getCellType();
        if (CellType.BLANK.equals(cellType) ? true : CellType._NONE.equals(cellType)) {
            return "";
        }
        if (CellType.STRING.equals(cellType)) {
            return cell.getStringCellValue();
        }
        if (CellType.FORMULA.equals(cellType)) {
            CellType cellType2 = cell.getCachedFormulaResultType();
            if (CellType.BLANK.equals(cellType2) ? true : CellType._NONE.equals(cellType2)) {
                return "";
            }
            if (CellType.ERROR.equals(cellType2)) {
                return FormulaError.forInt((byte)cell.getErrorCellValue()).getString();
            }
            if (CellType.STRING.equals(cellType2)) {
                return cell.getStringCellValue();
            }
            if (CellType.NUMERIC.equals(cellType2)) {
                return Double.toString(cell.getNumericCellValue());
            }
            return this.dataFormatter().formatCellValue(cell);
        }
        return this.dataFormatter().formatCellValue(cell);
    }

    public Workbook getWorkbook(Configuration conf, URI uri) {
        Workbook workbook;
        block7: {
            try (FSDataInputStream ins = FileSystem.get((URI)uri, (Configuration)conf).open(new Path(uri));){
                Option<Object> option = this.options.maxRowsInMemory();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int maxRows = BoxesRunTime.unboxToInt((Object)some.value());
                    StreamingReader.Builder builder = StreamingReader.builder().bufferSize(maxRows);
                    Option<String> option2 = this.options.workbookPassword();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        String password = (String)some2.value();
                        builder.password(password);
                    }
                    workbook = builder.open((InputStream)ins);
                    break block7;
                }
                Option<String> option3 = this.options.workbookPassword();
                if (option3 instanceof Some) {
                    Some some = (Some)option3;
                    String password = (String)some.value();
                    workbook = WorkbookFactory.create((InputStream)ins, (String)password);
                } else {
                    workbook = WorkbookFactory.create((InputStream)ins);
                }
            }
        }
        return workbook;
    }

    public Iterator<Vector<Cell>> getRows(Configuration conf, URI uri) {
        Iterator<Vector<Cell>> iterator;
        DataLocator excelReader = DataLocator$.MODULE$.apply(this.options);
        try (Workbook workbook = this.getWorkbook(conf, uri);){
            iterator = excelReader.readFrom(workbook);
        }
        return iterator;
    }

    public Vector<String> getColumnNames(Vector<Cell> firstRow) {
        Vector vector;
        Vector rowNumColumn;
        Vector vector2 = rowNumColumn = this.options.columnNameOfRowNumber().isDefined() ? (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.options.columnNameOfRowNumber().get()})) : package$.MODULE$.Vector().empty();
        if (this.options.header()) {
            Vector headerNames = (Vector)firstRow.map((Function1 & Serializable)x$1 -> this.dataFormatter().formatCellValue(x$1));
            Vector nonNullHeaderNames = (Vector)headerNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExcelHelper.$anonfun$getColumnNames$2(x$1)));
            Set duplicates = ((MapOps)nonNullHeaderNames.groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExcelHelper.$anonfun$getColumnNames$4(x$2)))).keySet();
            vector = (Vector)((StrictOptimizedIterableOps)firstRow.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2;
                block4: {
                    String value;
                    int index;
                    block6: {
                        block5: {
                            CellType cellType;
                            tuple2 = x0$1;
                            if (tuple2 == null) break block4;
                            Cell cell = (Cell)tuple2._1();
                            index = tuple2._2$mcI$sp();
                            value = this.dataFormatter().formatCellValue(cell);
                            CellType cellType2 = cellType = cell.getCellType();
                            CellType cellType3 = CellType.ERROR;
                            if (!(cellType2 == null ? cellType3 != null : !cellType2.equals(cellType3))) break block5;
                            CellType cellType4 = cellType;
                            CellType cellType5 = CellType.BLANK;
                            if (!(cellType4 == null ? cellType5 != null : !cellType4.equals(cellType5))) break block5;
                            CellType cellType6 = cellType;
                            CellType cellType7 = CellType._NONE;
                            if ((cellType6 == null ? cellType7 != null : !cellType6.equals(cellType7)) && !value.isEmpty()) break block6;
                        }
                        return new StringBuilder(2).append("_c").append(index).toString();
                    }
                    if (duplicates.contains((Object)value)) {
                        return new StringBuilder(0).append(value).append(index).toString();
                    }
                    return value;
                }
                throw new MatchError((Object)tuple2);
            });
        } else {
            vector = (Vector)((StrictOptimizedIterableOps)firstRow.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    int index = tuple2._2$mcI$sp();
                    return new StringBuilder(2).append("_c").append(index).toString();
                }
                throw new MatchError((Object)tuple2);
            });
        }
        Vector dataColumns = vector;
        return (Vector)rowNumColumn.$plus$plus((IterableOnce)dataColumns);
    }

    public AreaReference parsedRangeAddress() {
        return (AreaReference)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            CellReference cellRef = new CellReference($this.options.dataAddress());
            return new AreaReference(cellRef, new CellReference(cellRef.getSheetName(), SpreadsheetVersion.EXCEL2007.getLastRowIndex(), SpreadsheetVersion.EXCEL2007.getLastColumnIndex(), false, false), SpreadsheetVersion.EXCEL2007);
        }).getOrElse((Function0 & Serializable)() -> new AreaReference($this.options.dataAddress(), SpreadsheetVersion.EXCEL2007));
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$2(String x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$4(Tuple2 x$2) {
        return ((SeqOps)x$2._2()).size() > 1;
    }

    public ExcelHelper(ExcelOptions options) {
        this.options = options;
    }
}

