/*
 * Decompiled with CFR 0.152.
 */
package com.crealytics.spark.excel.v2;

import com.crealytics.spark.excel.v2.ExcelDateTimeStringUtils$;
import com.crealytics.spark.excel.v2.ExcelInferSchema$;
import com.crealytics.spark.excel.v2.ExcelOptions;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001B\u000f\u001f\u0001%B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005}!)1\t\u0001C\u0001\t\"9q\t\u0001b\u0001\n\u0013A\u0005B\u0002-\u0001A\u0003%\u0011\nC\u0003Z\u0001\u0011\u0005!\fC\u0003\u007f\u0001\u0011%q\u0010C\u0004\u0002\u0018\u0001!I!!\u0007\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u0011q\u0006\u0001\u0005\n\u0005E\u0002bBA\u001f\u0001\u0011%\u0011q\b\u0005\n\u0003\u000f\u0002!\u0019!C\u0005\u0003\u0013B\u0001\"!\u0019\u0001A\u0003%\u00111\n\u0005\b\u0003G\u0002A\u0011BA3\u0011\u001d\ty\u0007\u0001C\u0005\u0003cBq!!\u001e\u0001\t\u0013\t9\bC\u0004\u0002|\u0001!I!! \t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011q\u0011\u0001\u0005\n\u0005%\u0005bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0011%\t)\u000b\u0001b\u0001\n\u0013\t9\u000b\u0003\u0005\u00020\u0002\u0001\u000b\u0011BAU\u000f\u001d\t\tL\bE\u0001\u0003g3a!\b\u0010\t\u0002\u0005U\u0006BB\"\u001a\t\u0003\t\t\rC\u0004\u0002Df!\t!!2\t\u0013\u0005%\u0017$!A\u0005\n\u0005-'\u0001E#yG\u0016d\u0017J\u001c4feN\u001b\u0007.Z7b\u0015\ty\u0002%\u0001\u0002we)\u0011\u0011EI\u0001\u0006Kb\u001cW\r\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\u0015\r\u0014X-\u00197zi&\u001c7OC\u0001(\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0006\r\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005EJdB\u0001\u001a8\u001d\t\u0019d'D\u00015\u0015\t)\u0004&\u0001\u0004=e>|GOP\u0005\u0002[%\u0011\u0001\bL\u0001\ba\u0006\u001c7.Y4f\u0013\tQ4H\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00029Y\u00059q\u000e\u001d;j_:\u001cX#\u0001 \u0011\u0005}\u0002U\"\u0001\u0010\n\u0005\u0005s\"\u0001D#yG\u0016dw\n\u001d;j_:\u001c\u0018\u0001C8qi&|gn\u001d\u0011\u0002\rqJg.\u001b;?)\t)e\t\u0005\u0002@\u0001!)Ah\u0001a\u0001}\u0005yA/[7fgR\fW\u000e\u001d)beN,'/F\u0001J!\tQe+D\u0001L\u0015\taU*\u0001\u0003vi&d'B\u0001(P\u0003!\u0019\u0017\r^1msN$(B\u0001)R\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003GIS!a\u0015+\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0016aA8sO&\u0011qk\u0013\u0002\u0013)&lWm\u001d;b[B4uN]7biR,'/\u0001\tuS6,7\u000f^1naB\u000b'o]3sA\u0005)\u0011N\u001c4feR\u00191,Y:\u0011\u0005q{V\"A/\u000b\u0005y{\u0015!\u0002;za\u0016\u001c\u0018B\u00011^\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006E\u001a\u0001\raY\u0001\u0007i>\\WM\\:\u0011\u0007E\"g-\u0003\u0002fw\tA\u0011\n^3sCR|'\u000fE\u00022O&L!\u0001[\u001e\u0003\rY+7\r^8s!\tQ\u0017/D\u0001l\u0015\taW.A\u0005vg\u0016\u0014Xn\u001c3fY*\u0011an\\\u0001\u0003gNT!\u0001\u001d*\u0002\u0007A|\u0017.\u0003\u0002sW\n!1)\u001a7m\u0011\u0015!h\u00011\u0001v\u0003\u0019AW-\u00193feB\u0019\u0011g\u001a<\u0011\u0005]\\hB\u0001=z!\t\u0019D&\u0003\u0002{Y\u00051\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQH&\u0001\bu_N#(/^2u\r&,G\u000eZ:\u0015\r\u0005\u0005\u0011\u0011BA\u000b!\u0011\tt-a\u0001\u0011\u0007q\u000b)!C\u0002\u0002\bu\u00131b\u0015;sk\u000e$h)[3mI\"9\u00111B\u0004A\u0002\u00055\u0011A\u00034jK2$G+\u001f9fgB!\u0011gZA\b!\ra\u0016\u0011C\u0005\u0004\u0003'i&\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000bQ<\u0001\u0019A;\u0002\u0019%tg-\u001a:S_^$\u0016\u0010]3\u0015\r\u00055\u00111DA\u0010\u0011\u001d\ti\u0002\u0003a\u0001\u0003\u001b\t\u0001B]8x'>4\u0015M\u001d\u0005\u0007\u0003CA\u0001\u0019\u00014\u0002\t9,\u0007\u0010^\u0001\u0017S:4WM\u001d+za\u0016|em\u0015;sS:<g+\u00197vKR1\u0011qBA\u0014\u0003WAq!!\u000b\n\u0001\u0004\ty!A\u0005usB,7k\u001c$be\"1\u0011QF\u0005A\u0002Y\fQA^1mk\u0016\fa#\u001b8gKJ$\u0016\u0010]3PM\u0012{WO\u00197f-\u0006dW/\u001a\u000b\u0007\u0003\u001f\t\u0019$!\u000e\t\u000f\u0005%\"\u00021\u0001\u0002\u0010!9\u0011Q\u0006\u0006A\u0002\u0005]\u0002cA\u0016\u0002:%\u0019\u00111\b\u0017\u0003\r\u0011{WO\u00197f\u0003)IgNZ3s\r&,G\u000e\u001a\u000b\u0007\u0003\u001f\t\t%a\u0011\t\u000f\u0005%2\u00021\u0001\u0002\u0010!1\u0011QI\u0006A\u0002%\fQAZ5fY\u0012\fQ\u0002Z3dS6\fG\u000eU1sg\u0016\u0014XCAA&!\u0019Y\u0013Q\n<\u0002R%\u0019\u0011q\n\u0017\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0005[\u0006$\bN\u0003\u0002\u0002\\\u0005!!.\u0019<b\u0013\u0011\ty&!\u0016\u0003\u0015\tKw\rR3dS6\fG.\u0001\beK\u000eLW.\u00197QCJ\u001cXM\u001d\u0011\u0002\u0015%\u001c\u0018J\u001c4Pe:\u000bg\u000e\u0006\u0003\u0002h\u00055\u0004cA\u0016\u0002j%\u0019\u00111\u000e\u0017\u0003\u000f\t{w\u000e\\3b]\"1\u0011Q\t\bA\u0002Y\fq\u0002\u001e:z!\u0006\u00148/Z%oi\u0016<WM\u001d\u000b\u0005\u0003\u001f\t\u0019\b\u0003\u0004\u0002F=\u0001\rA^\u0001\riJL\b+\u0019:tK2{gn\u001a\u000b\u0005\u0003\u001f\tI\b\u0003\u0004\u0002FA\u0001\rA^\u0001\u0010iJL\b+\u0019:tK\u0012+7-[7bYR!\u0011qBA@\u0011\u0019\t)%\u0005a\u0001m\u0006qAO]=QCJ\u001cX\rR8vE2,G\u0003BA\b\u0003\u000bCa!!\u0012\u0013\u0001\u00041\u0018!\u0005;ssB\u000b'o]3US6,7\u000f^1naR!\u0011qBAF\u0011\u0019\t)e\u0005a\u0001m\u0006yAO]=QCJ\u001cXMQ8pY\u0016\fg\u000e\u0006\u0003\u0002\u0010\u0005E\u0005BBA#)\u0001\u0007a/\u0001\bd_6\u0004\u0018\r^5cY\u0016$\u0016\u0010]3\u0015\r\u0005]\u0015QTAQ!\u0015Y\u0013\u0011TA\b\u0013\r\tY\n\f\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005}U\u00031\u0001\u0002\u0010\u0005\u0011A/\r\u0005\b\u0003G+\u0002\u0019AA\b\u0003\t!('\u0001\u000egS:$7i\\7qCRL'\r\\3UsB,gi\u001c:Fq\u000e,G.\u0006\u0002\u0002*BI1&a+\u0002\u0010\u0005=\u0011qS\u0005\u0004\u0003[c#!\u0003$v]\u000e$\u0018n\u001c83\u0003m1\u0017N\u001c3D_6\u0004\u0018\r^5cY\u0016$\u0016\u0010]3G_J,\u0005pY3mA\u0005\u0001R\t_2fY&sg-\u001a:TG\",W.\u0019\t\u0003\u007fe\u0019B!\u0007\u0016\u00028B!\u0011\u0011XA`\u001b\t\tYL\u0003\u0003\u0002>\u0006e\u0013AA5p\u0013\rQ\u00141\u0018\u000b\u0003\u0003g\u000bQ!\u00199qYf$2!RAd\u0011\u0015a4\u00041\u0001?\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ti\r\u0005\u0003\u0002P\u0006UWBAAi\u0015\u0011\t\u0019.!\u0017\u0002\t1\fgnZ\u0005\u0005\u0003/\f\tN\u0001\u0004PE*,7\r\u001e")
public class ExcelInferSchema
implements Serializable {
    private final ExcelOptions options;
    private final TimestampFormatter timestampParser;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForExcel;

    public static ExcelInferSchema apply(ExcelOptions options) {
        return ExcelInferSchema$.MODULE$.apply(options);
    }

    public ExcelOptions options() {
        return this.options;
    }

    private TimestampFormatter timestampParser() {
        return this.timestampParser;
    }

    public StructType infer(Iterator<Vector<Cell>> tokens, Vector<String> header) {
        Vector<StructField> vector;
        Object dataHeader;
        Object rowNumField = this.options().columnNameOfRowNumber().isDefined() ? (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(this.options().columnNameOfRowNumber().get(), (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})) : package$.MODULE$.Vector().empty();
        Object object = dataHeader = this.options().columnNameOfRowNumber().isDefined() ? header.tail() : header;
        if (this.options().inferSchema()) {
            Vector startType = (Vector)package$.MODULE$.Vector().fill(((Vector)dataHeader).length(), (Function0<NullType$> & Serializable)() -> NullType$.MODULE$);
            Vector rootTypes = tokens.foldLeft(startType, (Function2<Vector, Vector, Vector> & Serializable)(rowSoFar, next) -> this.inferRowType((Vector<DataType>)rowSoFar, (Vector<Cell>)next));
            vector = this.toStructFields(rootTypes, (Vector<String>)dataHeader);
        } else {
            vector = (Vector<StructField>)((Vector)dataHeader).map((Function1<String, StructField> & Serializable)fieldName -> new StructField(fieldName, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()));
        }
        Vector<StructField> dataFields = vector;
        return StructType$.MODULE$.apply((Seq)((AbstractIterable)rowNumField).$plus$plus(dataFields));
    }

    private Vector<StructField> toStructFields(Vector<DataType> fieldTypes, Vector<String> header) {
        return (Vector)((StrictOptimizedIterableOps)header.zip(fieldTypes)).map((Function1<Tuple2, StructField> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String thisHeader = (String)tuple2._1();
                DataType rootType = (DataType)tuple2._2();
                DataType dataType = rootType;
                StringType$ dType = dataType instanceof NullType ? StringType$.MODULE$ : dataType;
                return new StructField(thisHeader, (DataType)dType, true, StructField$.MODULE$.apply$default$4());
            }
            throw new MatchError(tuple2);
        });
    }

    private Vector<DataType> inferRowType(Vector<DataType> rowSoFar, Vector<Cell> next) {
        return package$.MODULE$.Range().apply(0, rowSoFar.length()).map((Function1<Object, DataType> & Serializable)i -> ExcelInferSchema.$anonfun$inferRowType$1(this, next, rowSoFar, BoxesRunTime.unboxToInt(i))).toVector();
    }

    private DataType inferTypeOfStringValue(DataType typeSoFar, String value) {
        DataType dataType;
        block21: {
            block20: {
                if (value == null || value.isEmpty()) break block20;
                String string = value;
                String string2 = this.options().nullValue();
                if (string != null ? !string.equals(string2) : string2 != null) break block21;
            }
            return typeSoFar;
        }
        DataType dataType2 = typeSoFar;
        if (NullType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseInteger(value);
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseInteger(value);
        } else if (LongType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseLong(value);
        } else if (dataType2 instanceof DecimalType) {
            dataType = this.tryParseDecimal(value);
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseDouble(value);
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseTimestamp(value);
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseBoolean(value);
        } else if (StringType$.MODULE$.equals(dataType2)) {
            dataType = StringType$.MODULE$;
        } else {
            if (dataType2 != null) {
                DataType dataType3 = dataType2;
                throw new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType3).toString());
            }
            throw new MatchError(dataType2);
        }
        DataType typeElemInfer = dataType;
        return (DataType)this.compatibleType(typeSoFar, typeElemInfer).getOrElse((Function0<StringType$> & Serializable)() -> StringType$.MODULE$);
    }

    private DataType inferTypeOfDoubleValue(DataType typeSoFar, double value) {
        IntegerType$ typeElemInfer = RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(value)) ? IntegerType$.MODULE$ : (value == (double)((long)value) ? LongType$.MODULE$ : DoubleType$.MODULE$);
        return (DataType)this.compatibleType(typeSoFar, (DataType)typeElemInfer).getOrElse((Function0<DoubleType$> & Serializable)() -> DoubleType$.MODULE$);
    }

    private DataType inferField(DataType typeSoFar, Cell field2) {
        Object object;
        CellType cellType = field2.getCellType();
        if (((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
            CellType cellType2 = field2.getCachedFormulaResultType();
            object = ((Object)((Object)CellType.STRING)).equals((Object)cellType2) ? this.inferTypeOfStringValue(typeSoFar, field2.getStringCellValue()) : (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType2) ? this.inferTypeOfDoubleValue(typeSoFar, field2.getNumericCellValue()) : NullType$.MODULE$);
        } else if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : (((Object)((Object)CellType.ERROR)).equals((Object)cellType) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType))) {
            object = NullType$.MODULE$;
        } else if (((Object)((Object)CellType.BOOLEAN)).equals((Object)cellType)) {
            object = BooleanType$.MODULE$;
        } else if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType)) {
            object = DateUtil.isCellDateFormatted(field2) ? TimestampType$.MODULE$ : this.inferTypeOfDoubleValue(typeSoFar, field2.getNumericCellValue());
        } else if (((Object)((Object)CellType.STRING)).equals((Object)cellType)) {
            object = this.inferTypeOfStringValue(typeSoFar, field2.getStringCellValue());
        } else {
            throw new MatchError((Object)cellType);
        }
        NullType$ typeElemInfer = object;
        return (DataType)this.compatibleType(typeSoFar, (DataType)typeElemInfer).getOrElse((Function0<StringType$> & Serializable)() -> StringType$.MODULE$);
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInfOrNan(String field2) {
        String string = field2;
        String string2 = this.options().nanValue();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field2;
        String string4 = this.options().negativeInf();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = field2;
        String string6 = this.options().positiveInf();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    private DataType tryParseInteger(String field2) {
        if (Exception$.MODULE$.allCatch().opt(() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(field2))).isDefined()) {
            return IntegerType$.MODULE$;
        }
        return this.tryParseLong(field2);
    }

    private DataType tryParseLong(String field2) {
        if (Exception$.MODULE$.allCatch().opt(() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(field2))).isDefined()) {
            return LongType$.MODULE$;
        }
        return this.tryParseDecimal(field2);
    }

    private DataType tryParseDecimal(String field2) {
        Option decimalTry = Exception$.MODULE$.allCatch().opt((Function0<DataType> & Serializable)() -> {
            BigDecimal bigDecimal = this.decimalParser().apply(field2);
            if (bigDecimal.scale() <= 0) {
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }
            return this.tryParseDouble(field2);
        });
        return (DataType)decimalTry.getOrElse((Function0<DataType> & Serializable)() -> this.tryParseDouble(field2));
    }

    private DataType tryParseDouble(String field2) {
        if (Exception$.MODULE$.allCatch().opt(() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(field2))).isDefined() || this.isInfOrNan(field2)) {
            return DoubleType$.MODULE$;
        }
        return this.tryParseTimestamp(field2);
    }

    private DataType tryParseTimestamp(String field2) {
        if (Exception$.MODULE$.allCatch().opt(() -> this.timestampParser().parse(field2)).isDefined()) {
            return TimestampType$.MODULE$;
        }
        return this.tryParseBoolean(field2);
    }

    private DataType tryParseBoolean(String field2) {
        if (Exception$.MODULE$.allCatch().opt(() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(field2))).isDefined()) {
            return BooleanType$.MODULE$;
        }
        return StringType$.MODULE$;
    }

    private Option<DataType> compatibleType(DataType t1, DataType t2) {
        return ((Option)TypeCoercion$.MODULE$.findTightestCommonType().apply(t1, t2)).orElse((Function0<Option> & Serializable)() -> this.findCompatibleTypeForExcel().apply(t1, t2));
    }

    private Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForExcel() {
        return this.findCompatibleTypeForExcel;
    }

    public static final /* synthetic */ DataType $anonfun$inferRowType$1(ExcelInferSchema $this, Vector next$1, Vector rowSoFar$1, int i) {
        if (i < next$1.length()) {
            return $this.inferField((DataType)rowSoFar$1.apply(i), (Cell)next$1.apply(i));
        }
        return (DataType)$this.compatibleType((DataType)rowSoFar$1.apply(i), (DataType)NullType$.MODULE$).getOrElse((Function0<StringType$> & Serializable)() -> StringType$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$findCompatibleTypeForExcel$1(DataType x0$1, DataType x1$1) {
        block10: {
            block9: {
                var4_2 = new Tuple2<DataType, DataType>(x0$1, x1$1);
                if (var4_2 != null && StringType$.MODULE$.equals(var5_3 = var4_2._1())) {
                    return new Some<StringType$>(StringType$.MODULE$);
                }
                if (var4_2 != null && StringType$.MODULE$.equals(var6_4 = var4_2._2())) {
                    return new Some<StringType$>(StringType$.MODULE$);
                }
                if (var4_2 == null || !DoubleType$.MODULE$.equals(var7_5 = var4_2._1()) || !(var4_2._2() instanceof DecimalType)) break block9;
                v0 = true;
                break block10;
            }
            if (var4_2 == null) ** GOTO lbl-1000
            var8_6 = var4_2._2();
            if (var4_2._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var8_6)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            return new Some<DoubleType$>(DoubleType$.MODULE$);
        }
        if (var4_2 != null) {
            t1 = var4_2._1();
            t2 = var4_2._2();
            if (t1 instanceof DecimalType) {
                var11_9 = (DecimalType)t1;
                if (t2 instanceof DecimalType) {
                    var12_10 = (DecimalType)t2;
                    scale = scala.math.package$.MODULE$.max(var11_9.scale(), var12_10.scale());
                    range = scala.math.package$.MODULE$.max(var11_9.precision() - var11_9.scale(), var12_10.precision() - var12_10.scale());
                    if (range + scale > 38) {
                        return new Some<DoubleType$>(DoubleType$.MODULE$);
                    }
                    return new Some<DecimalType>(new DecimalType(range + scale, scale));
                }
            }
        }
        return None$.MODULE$;
    }

    public ExcelInferSchema(ExcelOptions options) {
        this.options = options;
        this.timestampParser = ExcelDateTimeStringUtils$.MODULE$.getTimestampFormatter(options);
        this.decimalParser = (Function1<String, BigDecimal> & Serializable)s -> new BigDecimal((String)s);
        this.findCompatibleTypeForExcel = ExcelInferSchema::$anonfun$findCompatibleTypeForExcel$1;
    }
}

