/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.xlsx.CloseableIterator;
import com.github.pjfanning.xlsx.SharedFormula;
import com.github.pjfanning.xlsx.impl.StreamingSheetReader;
import com.github.pjfanning.xlsx.impl.WrappedComment;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import org.apache.poi.ss.usermodel.AutoFilter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.PageMargin;
import org.apache.poi.ss.usermodel.PaneType;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.usermodel.XSSFComment;

public class StreamingSheet
implements Sheet {
    private final String name;
    private final StreamingSheetReader reader;

    public StreamingSheet(String name, StreamingSheetReader reader) {
        this.name = name;
        this.reader = reader;
        reader.setSheet(this);
    }

    StreamingSheetReader getReader() {
        return this.reader;
    }

    @Override
    public Workbook getWorkbook() {
        return this.reader.getWorkbook();
    }

    @Override
    public CloseableIterator<Row> iterator() {
        return this.reader.iterator();
    }

    public CloseableIterator<Row> rowIterator() {
        return this.reader.iterator();
    }

    @Override
    public Spliterator<Row> spliterator() {
        return Spliterators.spliterator(this.rowIterator(), Long.MAX_VALUE, 16);
    }

    @Override
    public String getSheetName() {
        return this.name;
    }

    @Override
    public boolean isColumnHidden(int columnIndex) {
        return this.reader.isColumnHidden(columnIndex);
    }

    @Override
    public int getFirstRowNum() {
        return this.reader.getFirstRowNum();
    }

    @Override
    public int getLastRowNum() {
        return this.reader.getLastRowNum();
    }

    @Override
    public Comment getCellComment(CellAddress cellAddress) {
        Comments sheetComments = this.reader.getCellComments();
        if (sheetComments == null) {
            return null;
        }
        XSSFComment xssfComment = sheetComments.findCellComment(cellAddress);
        if (xssfComment != null && this.reader.getBuilder().adjustLegacyComments()) {
            return new WrappedComment(xssfComment);
        }
        return xssfComment;
    }

    @Override
    public Map<CellAddress, ? extends Comment> getCellComments() {
        Comments sheetComments = this.reader.getCellComments();
        if (sheetComments == null) {
            return Collections.emptyMap();
        }
        HashMap<CellAddress, Comment> map = new HashMap<CellAddress, Comment>();
        Iterator<CellAddress> iter = sheetComments.getCellAddresses();
        while (iter.hasNext()) {
            CellAddress address = iter.next();
            map.put(address, this.getCellComment(address));
        }
        return map;
    }

    @Override
    public CellRangeAddress getMergedRegion(int index) {
        List<CellRangeAddress> regions = this.getMergedRegions();
        if (index > regions.size()) {
            throw new NoSuchElementException("index " + index + " is out of range");
        }
        return regions.get(index);
    }

    @Override
    public List<CellRangeAddress> getMergedRegions() {
        return this.reader.getMergedCells();
    }

    @Override
    public int getNumMergedRegions() {
        List<CellRangeAddress> mergedCells = this.reader.getMergedCells();
        return mergedCells == null ? 0 : mergedCells.size();
    }

    @Override
    public Drawing<?> getDrawingPatriarch() {
        return this.reader.getDrawingPatriarch();
    }

    @Override
    public Hyperlink getHyperlink(int row, int column) {
        return this.getHyperlink(new CellAddress(row, column));
    }

    @Override
    public Hyperlink getHyperlink(CellAddress cellAddress) {
        for (Hyperlink hyperlink : this.getHyperlinkList()) {
            if (cellAddress.getRow() < hyperlink.getFirstRow() || cellAddress.getRow() > hyperlink.getLastRow() || cellAddress.getColumn() < hyperlink.getFirstColumn() || cellAddress.getColumn() > hyperlink.getLastColumn()) continue;
            return hyperlink;
        }
        return null;
    }

    @Override
    public List<? extends Hyperlink> getHyperlinkList() {
        return this.reader.getHyperlinks();
    }

    @Override
    public CellAddress getActiveCell() {
        return this.reader.getActiveCell();
    }

    @Override
    public int getDefaultColumnWidth() {
        return this.reader.getBaseColWidth();
    }

    @Override
    public short getDefaultRowHeight() {
        return (short)(this.getDefaultRowHeightInPoints() * 20.0f);
    }

    @Override
    public float getDefaultRowHeightInPoints() {
        return this.reader.getDefaultRowHeight();
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return Math.round(this.reader.getColumnWidth(columnIndex) * 256.0f);
    }

    @Override
    public float getColumnWidthInPixels(int columnIndex) {
        float widthIn256 = this.getColumnWidth(columnIndex);
        return (float)((double)widthIn256 / 256.0 * (double)7.0017f);
    }

    @Override
    public PaneInformation getPaneInformation() {
        return this.reader.getPane();
    }

    public Map<String, SharedFormula> getSharedFormulaMap() {
        return this.reader.getSharedFormulaMap();
    }

    public void addSharedFormula(String siValue, SharedFormula sharedFormula) {
        this.reader.addSharedFormula(siValue, sharedFormula);
    }

    public SharedFormula removeSharedFormula(String siValue) {
        return this.reader.removeSharedFormula(siValue);
    }

    @Override
    public Row createRow(int rownum) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void removeRow(Row row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public Row getRow(int rownum) {
        throw new UnsupportedOperationException("use iterator() or rowIterator() instead");
    }

    @Override
    public int getPhysicalNumberOfRows() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setColumnHidden(int columnIndex, boolean hidden) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setRightToLeft(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean isRightToLeft() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setColumnWidth(int columnIndex, int width) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setDefaultColumnWidth(int width) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setDefaultRowHeight(short height) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setDefaultRowHeightInPoints(float height) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public CellStyle getColumnStyle(int column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int addMergedRegion(CellRangeAddress region) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public int addMergedRegionUnsafe(CellRangeAddress cellRangeAddress) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void validateMergedRegions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVerticallyCenter(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setHorizontallyCenter(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean getHorizontallyCenter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getVerticallyCenter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeMergedRegion(int index) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void removeMergedRegions(Collection<Integer> collection) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setForceFormulaRecalculation(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAutobreaks(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setDisplayGuts(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setDisplayZeros(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean isDisplayZeros() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFitToPage(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setRowSumsBelow(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setRowSumsRight(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean getAutobreaks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getDisplayGuts() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getFitToPage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getRowSumsBelow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getRowSumsRight() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPrintGridlines() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrintGridlines(boolean show) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean isPrintRowAndColumnHeadings() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrintRowAndColumnHeadings(boolean b) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public PrintSetup getPrintSetup() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Header getHeader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Footer getFooter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelected(boolean value) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public double getMargin(short margin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getMargin(PageMargin margin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMargin(short margin, double size) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setMargin(PageMargin margin, double size) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean getProtect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void protectSheet(String password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getScenarioProtect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setZoom(int i) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public short getTopRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getLeftCol() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void showInPane(int toprow, int leftcol) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void shiftColumns(int startColumn, int endColumn, int n) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, PaneType activePane) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDisplayGridlines(boolean show) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean isDisplayGridlines() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDisplayFormulas(boolean show) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean isDisplayFormulas() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDisplayRowColHeadings(boolean show) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean isDisplayRowColHeadings() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRowBreak(int row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean isRowBroken(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeRowBreak(int row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public int[] getRowBreaks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getColumnBreaks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setColumnBreak(int column) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public boolean isColumnBroken(int column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeColumnBreak(int column) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void groupColumn(int fromColumn, int toColumn) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void ungroupColumn(int fromColumn, int toColumn) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void groupRow(int fromRow, int toRow) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void ungroupRow(int fromRow, int toRow) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setRowGroupCollapsed(int row, boolean collapse) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setDefaultColumnStyle(int column, CellStyle style) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void autoSizeColumn(int column) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void autoSizeColumn(int column, boolean useMergedCells) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public Drawing createDrawingPatriarch() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSelected() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellRange<? extends Cell> setArrayFormula(String formula, CellRangeAddress range) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public CellRange<? extends Cell> removeArrayFormula(Cell cell) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public DataValidationHelper getDataValidationHelper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends DataValidation> getDataValidations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addValidationData(DataValidation dataValidation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AutoFilter setAutoFilter(CellRangeAddress range) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public SheetConditionalFormatting getSheetConditionalFormatting() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellRangeAddress getRepeatingRows() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellRangeAddress getRepeatingColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRepeatingRows(CellRangeAddress rowRangeRef) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public void setRepeatingColumns(CellRangeAddress columnRangeRef) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    @Override
    public int getColumnOutlineLevel(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setActiveCell(CellAddress cellAddress) {
        throw new UnsupportedOperationException("update operations are not supported");
    }
}

