/*
 * Decompiled with CFR 0.152.
 */
package com.crealytics.spark.excel.v2;

import com.crealytics.spark.excel.v2.ExcelHelper$;
import com.crealytics.spark.excel.v2.ExcelOptions;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001B\u0012%\u0001=B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005q!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003G\u0011!!\u0006A!b\u0001\n\u0003)\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006K\u0002!\tA\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019A\b\u0001)A\u0005]\"Q\u0011\u0010\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002>\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001bBA\u0006\u0001\u0001\u0006I! \u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"!\u0005\u0001A\u0003%\u0011\u0011\u0001\u0005\n\u0003'\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"!\u0006\u0001A\u0003%\u0011\u0011A\u0003\u0007\u0003/\u0001A!!\u0007\t\u0013\u0005]\u0002A1A\u0005\n\u0005e\u0002\u0002CA#\u0001\u0001\u0006I!a\u000f\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!Q\u0011Q\u000b\u0001\t\u0006\u0004%I!a\u0016\t\u0015\u0005e\u0003\u0001#b\u0001\n\u0013\t9\u0006\u0003\u0006\u0002\\\u0001A)\u0019!C\u0005\u0003/B!\"!\u0018\u0001\u0011\u000b\u0007I\u0011BA,\u0011)\ty\u0006\u0001EC\u0002\u0013%\u0011q\u000b\u0005\b\u0003C\u0002A\u0011BA2\u0011%\ty\u0007\u0001a\u0001\n\u0013\ty\u0001C\u0005\u0002r\u0001\u0001\r\u0011\"\u0003\u0002t!A\u0011q\u000f\u0001!B\u0013\t\t\u0001C\u0004\u0002z\u0001!\t!a\u001f\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u0011Q\u0011\u0001\u0005\u0002\u0005m$AD#yG\u0016dw)\u001a8fe\u0006$xN\u001d\u0006\u0003K\u0019\n!A\u001e\u001a\u000b\u0005\u001dB\u0013!B3yG\u0016d'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0006de\u0016\fG.\u001f;jGNT\u0011!L\u0001\u0004G>l7\u0001A\n\u0003\u0001A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0017\u0001\u00029bi\",\u0012\u0001\u000f\t\u0003s\u0001s!A\u000f \u0011\u0005m\u0012T\"\u0001\u001f\u000b\u0005ur\u0013A\u0002\u001fs_>$h(\u0003\u0002@e\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\ty$'A\u0003qCRD\u0007%\u0001\u0006eCR\f7k\u00195f[\u0006,\u0012A\u0012\t\u0003\u000fFk\u0011\u0001\u0013\u0006\u0003\u0013*\u000bQ\u0001^=qKNT!a\u0013'\u0002\u0007M\fHN\u0003\u0002*\u001b*\u0011ajT\u0001\u0007CB\f7\r[3\u000b\u0003A\u000b1a\u001c:h\u0013\t\u0011\u0006J\u0001\u0006TiJ,8\r\u001e+za\u0016\f1\u0002Z1uCN\u001b\u0007.Z7bA\u0005!1m\u001c8g+\u00051\u0006CA,\\\u001b\u0005A&B\u0001+Z\u0015\tQV*\u0001\u0004iC\u0012|w\u000e]\u0005\u00039b\u0013QbQ8oM&<WO]1uS>t\u0017!B2p]\u001a\u0004\u0013aB8qi&|gn]\u000b\u0002AB\u0011\u0011MY\u0007\u0002I%\u00111\r\n\u0002\r\u000bb\u001cW\r\\(qi&|gn]\u0001\t_B$\u0018n\u001c8tA\u00051A(\u001b8jiz\"Ra\u001a5jU.\u0004\"!\u0019\u0001\t\u000bYJ\u0001\u0019\u0001\u001d\t\u000b\u0011K\u0001\u0019\u0001$\t\u000bQK\u0001\u0019\u0001,\t\u000byK\u0001\u0019\u00011\u0002\u0005]\u0014W#\u00018\u0011\u0005=4X\"\u00019\u000b\u0005E\u0014\u0018!C;tKJlw\u000eZ3m\u0015\t\u0019H/\u0001\u0002tg*\u0011Q/T\u0001\u0004a>L\u0017BA<q\u0005!9vN]6c_>\\\u0017aA<cA\u0005\u0019\u0001\u0010J\u0019\u0011\u000fEZX0!\u0001\u0002\u0002%\u0011AP\r\u0002\u0007)V\u0004H.Z\u001a\u0011\u0005=t\u0018BA@q\u0005\u0015\u0019\u0006.Z3u!\r\t\u00141A\u0005\u0004\u0003\u000b\u0011$aA%oi\u0006)1\u000f[3fiV\tQ0\u0001\u0004tQ\u0016,G\u000fI\u0001\tM&\u00148\u000f^\"pYV\u0011\u0011\u0011A\u0001\nM&\u00148\u000f^\"pY\u0002\n\u0001BZ5sgR\u0014vn^\u0001\nM&\u00148\u000f\u001e*po\u0002\u0012aBV1mk\u0016\u001cuN\u001c<feR,'\u000fE\u00062\u00037\ty\"!\u0001\u0002,\u0005E\u0012bAA\u000fe\tIa)\u001e8di&|gn\r\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005&\u0002\u0011\r\fG/\u00197zgRLA!!\u000b\u0002$\tY\u0011J\u001c;fe:\fGNU8x!\ry\u0017QF\u0005\u0004\u0003_\u0001(\u0001B\"fY2\u00042!MA\u001a\u0013\r\t)D\r\u0002\u0005+:LG/A\bwC2,XmQ8om\u0016\u0014H/\u001a:t+\t\tY\u0004E\u00032\u0003{\t\t%C\u0002\u0002@I\u0012Q!\u0011:sCf\u00042!a\u0011\u0014\u001b\u0005\u0001\u0011\u0001\u0005<bYV,7i\u001c8wKJ$XM]:!\u0003-\u0019'/Z1uKN#\u0018\u0010\\3\u0015\t\u0005-\u0013\u0011\u000b\t\u0004_\u00065\u0013bAA(a\nI1)\u001a7m'RLH.\u001a\u0005\u0007\u0003'2\u0002\u0019\u0001\u001d\u0002\r\u0019|'/\\1u\u00035!\u0015\r^3DK2d7\u000b^=mKV\u0011\u00111J\u0001\u0013)&lWm\u001d;b[B\u001cU\r\u001c7TifdW-\u0001\u000bXQ>dWMT;nE\u0016\u00148)\u001a7m'RLH.Z\u0001\u0017\t\u0016\u001c\u0017.\\1m\u001dVl'-\u001a:DK2d7\u000b^=mK\u0006y1\u000b\u001e:j]\u001e\u001cU\r\u001c7TifdW-A\u0007nC.,7i\u001c8wKJ$XM\u001d\u000b\u0005\u0003\u0003\n)\u0007C\u0004\u0002hq\u0001\r!!\u001b\u0002\u0011\u0011\fG/\u0019+za\u0016\u00042aRA6\u0013\r\ti\u0007\u0013\u0002\t\t\u0006$\u0018\rV=qK\u0006\u0019!o\\<\u0002\u000fI|wo\u0018\u0013fcR!\u0011\u0011GA;\u0011!Ih$!AA\u0002\u0005\u0005\u0011\u0001\u0002:po\u0002\nAb\u001e:ji\u0016DU-\u00193feN$\"!!\r\u0002\u000b]\u0014\u0018\u000e^3\u0015\t\u0005E\u0012\u0011\u0011\u0005\b\u0003\u0007\u000b\u0003\u0019AA\u0010\u0003\u0019\u0011XmY8sI\u0006)1\r\\8tK\u0002")
public class ExcelGenerator {
    private CellStyle DateCellStyle;
    private CellStyle TimestampCellStyle;
    private CellStyle WholeNumberCellStyle;
    private CellStyle DecimalNumberCellStyle;
    private CellStyle StringCellStyle;
    private final String path;
    private final StructType dataSchema;
    private final Configuration conf;
    private final ExcelOptions options;
    private final Workbook wb;
    private final /* synthetic */ Tuple3 x$1;
    private final Sheet sheet;
    private final int firstCol;
    private final int firstRow;
    private final Function3<InternalRow, Object, Cell, BoxedUnit>[] valueConverters;
    private int row;
    private volatile byte bitmap$0;

    public String path() {
        return this.path;
    }

    public StructType dataSchema() {
        return this.dataSchema;
    }

    public Configuration conf() {
        return this.conf;
    }

    public ExcelOptions options() {
        return this.options;
    }

    private Workbook wb() {
        return this.wb;
    }

    private Sheet sheet() {
        return this.sheet;
    }

    private int firstCol() {
        return this.firstCol;
    }

    private int firstRow() {
        return this.firstRow;
    }

    private Function3<InternalRow, Object, Cell, BoxedUnit>[] valueConverters() {
        return this.valueConverters;
    }

    private CellStyle createStyle(String format) {
        CreationHelper createHelper = this.wb().getCreationHelper();
        CellStyle r = this.wb().createCellStyle();
        r.setDataFormat(createHelper.createDataFormat().getFormat(format));
        return r;
    }

    private CellStyle DateCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.DateCellStyle = this.createStyle(this.options().dateFormat());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.DateCellStyle;
    }

    private CellStyle DateCellStyle() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.DateCellStyle$lzycompute();
        }
        return this.DateCellStyle;
    }

    private CellStyle TimestampCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.TimestampCellStyle = this.createStyle(this.options().timestampFormat());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.TimestampCellStyle;
    }

    private CellStyle TimestampCellStyle() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.TimestampCellStyle$lzycompute();
        }
        return this.TimestampCellStyle;
    }

    private CellStyle WholeNumberCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.WholeNumberCellStyle = this.createStyle("General");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.WholeNumberCellStyle;
    }

    private CellStyle WholeNumberCellStyle() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.WholeNumberCellStyle$lzycompute();
        }
        return this.WholeNumberCellStyle;
    }

    private CellStyle DecimalNumberCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.DecimalNumberCellStyle = this.options().usePlainNumberFormat() ? this.createStyle("General") : this.createStyle("0.00E+000");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.DecimalNumberCellStyle;
    }

    private CellStyle DecimalNumberCellStyle() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.DecimalNumberCellStyle$lzycompute();
        }
        return this.DecimalNumberCellStyle;
    }

    private CellStyle StringCellStyle$lzycompute() {
        ExcelGenerator excelGenerator = this;
        synchronized (excelGenerator) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.StringCellStyle = this.createStyle("@");
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.StringCellStyle;
    }

    private CellStyle StringCellStyle() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.StringCellStyle$lzycompute();
        }
        return this.StringCellStyle;
    }

    private Function3<InternalRow, Object, Cell, BoxedUnit> makeConverter(DataType dataType) {
        DataType dataType2 = dataType;
        if (ByteType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$1(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$2(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$3(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$4(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$5(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$6(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return (Function3<InternalRow, Object, Cell, Object> & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$7(this, decimalType, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$8(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$9(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$10(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return (Function3<InternalRow, Object, Cell, Object> & Serializable)(row, ordinal, cell) -> {
                ExcelGenerator.$anonfun$makeConverter$11(this, row, BoxesRunTime.unboxToInt(ordinal), cell);
                return BoxedUnit.UNIT;
            };
        }
        throw new RuntimeException(new StringBuilder(18).append("Unsupported type: ").append(dataType.typeName()).toString());
    }

    private int row() {
        return this.row;
    }

    private void row_$eq(int x$1) {
        this.row = x$1;
    }

    public void writeHeaders() {
        Row excelRow = this.sheet().createRow(this.row());
        ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(this.dataSchema().fields()), (Function1<StructField, String> & Serializable)x$3 -> x$3.name(), ClassTag$.MODULE$.apply(String.class))))), (Function1<Tuple2, Object> & Serializable)x0$1 -> {
            ExcelGenerator.$anonfun$writeHeaders$2(this, excelRow, x0$1);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.Unit());
        this.row_$eq(this.row() + 1);
    }

    public void write(InternalRow record) {
        Row excelRow = this.sheet().createRow(this.row());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), record.numFields()).foreach$mVc$sp(idx -> {
            Cell cell = excelRow.createCell(idx + this.firstCol());
            if (record.isNullAt(idx)) {
                cell.setBlank();
                return;
            }
            this.valueConverters()[idx].apply(record, BoxesRunTime.boxToInteger(idx), cell);
        });
        this.row_$eq(this.row() + 1);
    }

    public void close() {
        Path hdfsPath = new Path(this.path());
        FileSystem fs = hdfsPath.getFileSystem(this.conf());
        FSDataOutputStream fos = fs.create(hdfsPath, true);
        this.wb().write((OutputStream)fos);
        this.wb().close();
        fos.close();
    }

    public static final /* synthetic */ void $anonfun$makeConverter$1(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getByte(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$2(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getShort(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$3(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getInt(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$4(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getLong(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$5(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getFloat(ordinal));
        cell.setCellStyle($this.DecimalNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$6(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getDouble(ordinal));
        cell.setCellStyle($this.DecimalNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$7(ExcelGenerator $this, DecimalType x8$1, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getDecimal(ordinal, x8$1.precision(), x8$1.scale()).toDouble());
        cell.setCellStyle($this.DecimalNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$8(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(DateTimeUtils$.MODULE$.toJavaDate(row.getInt(ordinal)));
        cell.setCellStyle($this.DateCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$9(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(DateTimeUtils$.MODULE$.toJavaTimestamp(row.getLong(ordinal)));
        cell.setCellStyle($this.TimestampCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$10(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getString(ordinal));
        cell.setCellStyle($this.StringCellStyle());
    }

    public static final /* synthetic */ void $anonfun$makeConverter$11(ExcelGenerator $this, InternalRow row, int ordinal, Cell cell) {
        cell.setCellValue(row.getBoolean(ordinal));
        cell.setCellStyle($this.WholeNumberCellStyle());
    }

    public static final /* synthetic */ void $anonfun$writeHeaders$2(ExcelGenerator $this, Row excelRow$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            excelRow$1.createCell(idx + $this.firstCol()).setCellValue(name);
            return;
        }
        throw new MatchError(tuple2);
    }

    public ExcelGenerator(String path, StructType dataSchema, Configuration conf, ExcelOptions options) {
        Workbook workbook;
        this.path = path;
        this.dataSchema = dataSchema;
        this.conf = conf;
        this.options = options;
        String string = options.fileExtension().toLowerCase();
        String string2 = "xlsx";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Option<Object> option = options.maxRowsInMemory();
            if (option instanceof Some) {
                Some some = (Some)option;
                int maxRows = BoxesRunTime.unboxToInt(some.value());
                workbook = new SXSSFWorkbook(maxRows);
            } else {
                workbook = new XSSFWorkbook();
            }
        } else {
            workbook = new HSSFWorkbook();
        }
        this.wb = workbook;
        AreaReference dataAddress = ExcelHelper$.MODULE$.apply(options).parsedRangeAddress();
        String ret = dataAddress.getFirstCell().getSheetName();
        String sheetname = ret == null || ret.isEmpty() ? "Sheet1" : WorkbookUtil.createSafeSheetName(ret);
        short col = dataAddress.getFirstCell().getCol();
        int row = dataAddress.getFirstCell().getRow();
        Tuple3<Sheet, Integer, Integer> tuple3 = new Tuple3<Sheet, Integer, Integer>(this.wb().createSheet(sheetname), BoxesRunTime.boxToInteger(col), BoxesRunTime.boxToInteger(row));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Sheet sheet = tuple3._1();
        int firstCol = BoxesRunTime.unboxToInt(tuple3._2());
        int firstRow = BoxesRunTime.unboxToInt(tuple3._3());
        this.x$1 = new Tuple3<Sheet, Integer, Integer>(sheet, BoxesRunTime.boxToInteger(firstCol), BoxesRunTime.boxToInteger(firstRow));
        this.sheet = (Sheet)this.x$1._1();
        this.firstCol = BoxesRunTime.unboxToInt(this.x$1._2());
        this.firstRow = BoxesRunTime.unboxToInt(this.x$1._3());
        this.valueConverters = (Function3[])((IterableOnceOps)((IterableOps)dataSchema.map((Function1<StructField, DataType> & Serializable)x$2 -> x$2.dataType())).map((Function1<DataType, Function3> & Serializable)dataType -> this.makeConverter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function3.class));
        this.row = this.firstRow();
    }
}

