/*
 * Decompiled with CFR 0.152.
 */
package com.crealytics.spark.excel.v2;

import com.crealytics.spark.excel.v2.ExcelHelper;
import com.crealytics.spark.excel.v2.ExcelOptions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.poi.hssf.usermodel.HSSFWorkbookFactory;
import org.apache.poi.openxml4j.util.ZipInputStreamZipEntrySource;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbookFactory;

public final class ExcelHelper$ {
    public static final ExcelHelper$ MODULE$ = new ExcelHelper$();
    private static final AtomicBoolean configurationNeeded = new AtomicBoolean();
    private static final AtomicBoolean configurationIsDone = new AtomicBoolean();

    private AtomicBoolean configurationNeeded() {
        return configurationNeeded;
    }

    private AtomicBoolean configurationIsDone() {
        return configurationIsDone;
    }

    public ExcelHelper apply(ExcelOptions options) {
        this.configureProvidersOnce();
        options.maxByteArraySize().foreach(maxSize -> IOUtils.setByteArrayMaxOverride(maxSize));
        options.tempFileThreshold().foreach(threshold -> ZipInputStreamZipEntrySource.setThresholdBytesForTempFiles(threshold));
        return new ExcelHelper(options);
    }

    public void configureProvidersOnce() {
        if (!this.configurationIsDone().get()) {
            if (!this.configurationNeeded().getAndSet(true)) {
                WorkbookFactory.removeProvider(HSSFWorkbookFactory.class);
                WorkbookFactory.addProvider(new HSSFWorkbookFactory());
                WorkbookFactory.removeProvider(XSSFWorkbookFactory.class);
                WorkbookFactory.addProvider(new XSSFWorkbookFactory());
                this.configurationIsDone().set(true);
                return;
            }
            while (!this.configurationIsDone().get()) {
                Thread.sleep(100L);
            }
            return;
        }
    }

    private ExcelHelper$() {
    }
}

