/*
 * Decompiled with CFR 0.152.
 */
package com.crealytics.spark.excel.v2;

import com.crealytics.spark.excel.v2.DataLocator;
import com.crealytics.spark.excel.v2.DataLocator$;
import com.crealytics.spark.excel.v2.ExcelHelper$;
import com.crealytics.spark.excel.v2.ExcelOptions;
import com.crealytics.spark.excel.v2.PlainNumberFormat$;
import com.crealytics.spark.excel.v2.SheetData;
import com.github.pjfanning.xlsx.StreamingReader;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\n\u0015\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006W\u0001!I\u0001\f\u0005\t_\u0001A)\u0019!C\u0005a!)q\b\u0001C\u0001\u0001\")\u0011\u000b\u0001C\u0001%\")\u0011\u000e\u0001C\u0001U\")\u0011\u0010\u0001C\u0001u\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\n\u0001\u0011\u0005\u0011QC\u0004\b\u0003G!\u0002\u0012AA\u0013\r\u0019\u0019B\u0003#\u0001\u0002(!11f\u0003C\u0001\u0003SA\u0011\"a\u000b\f\u0005\u0004%I!!\f\t\u0011\u0005\u00053\u0002)A\u0005\u0003_A\u0011\"a\u0011\f\u0005\u0004%I!!\f\t\u0011\u0005\u00153\u0002)A\u0005\u0003_Aq!a\u0012\f\t\u0003\tI\u0005C\u0004\u0002N-!\t!a\u0014\u0003\u0017\u0015C8-\u001a7IK2\u0004XM\u001d\u0006\u0003+Y\t!A\u001e\u001a\u000b\u0005]A\u0012!B3yG\u0016d'BA\r\u001b\u0003\u0015\u0019\b/\u0019:l\u0015\tYB$\u0001\u0006de\u0016\fG.\u001f;jGNT\u0011!H\u0001\u0004G>l7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017aB8qi&|gn\u001d\t\u0003Q%j\u0011\u0001F\u0005\u0003UQ\u0011A\"\u0012=dK2|\u0005\u000f^5p]N\fa\u0001P5oSRtDCA\u0017/!\tA\u0003\u0001C\u0003'\u0005\u0001\u0007q%A\u0007eCR\fgi\u001c:nCR$XM]\u000b\u0002cA\u0011!'P\u0007\u0002g)\u0011A'N\u0001\nkN,'/\\8eK2T!AN\u001c\u0002\u0005M\u001c(B\u0001\u001d:\u0003\r\u0001x.\u001b\u0006\u0003um\na!\u00199bG\",'\"\u0001\u001f\u0002\u0007=\u0014x-\u0003\u0002?g\tiA)\u0019;b\r>\u0014X.\u0019;uKJ\f1c]1gK\u000e+G\u000e\\*ue&twMV1mk\u0016$\"!\u0011'\u0011\u0005\tKeBA\"H!\t!%%D\u0001F\u0015\t1e$\u0001\u0004=e>|GOP\u0005\u0003\u0011\n\na\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001J\t\u0005\u0006\u001b\u0012\u0001\rAT\u0001\u0005G\u0016dG\u000e\u0005\u00023\u001f&\u0011\u0001k\r\u0002\u0005\u0007\u0016dG.A\u0006hKR<vN]6c_>\\GcA*W?B\u0011!\u0007V\u0005\u0003+N\u0012\u0001bV8sW\n|wn\u001b\u0005\u0006/\u0016\u0001\r\u0001W\u0001\u0005G>tg\r\u0005\u0002Z;6\t!L\u0003\u0002X7*\u0011A,O\u0001\u0007Q\u0006$wn\u001c9\n\u0005yS&!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003a\u000b\u0001\u0007\u0011-A\u0002ve&\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\u00079,GOC\u0001g\u0003\u0011Q\u0017M^1\n\u0005!\u001c'aA+S\u0013\u0006aq-\u001a;TQ\u0016,G\u000fR1uCR\u00191n\u001e=\u0011\u0007!bg.\u0003\u0002n)\tI1\u000b[3fi\u0012\u000bG/\u0019\t\u0004_RteB\u00019s\u001d\t!\u0015/C\u0001$\u0013\t\u0019(%A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(A\u0002,fGR|'O\u0003\u0002tE!)qK\u0002a\u00011\")\u0001M\u0002a\u0001C\u0006q\u0001/\u0019:tKNCW-\u001a;ECR\fG\u0003B>\u0000\u0003\u0003\u0001B!\t?l}&\u0011QP\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007=$\u0018\tC\u0003X\u000f\u0001\u0007\u0001\fC\u0004\u0002\u0004\u001d\u0001\r!!\u0002\u0002\tU\u0014\u0018n\u001d\t\u0005_\u0006\u001d\u0011-C\u0002\u0002\nY\u00141aU3r\u000399W\r^\"pYVlgNT1nKN$2A`A\b\u0011\u0019\t\t\u0002\u0003a\u0001]\u0006Aa-\u001b:tiJ{w/\u0001\nqCJ\u001cX\r\u001a*b]\u001e,\u0017\t\u001a3sKN\u001cHCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fk\u0005!Q\u000f^5m\u0013\u0011\t\t#a\u0007\u0003\u001b\u0005\u0013X-\u0019*fM\u0016\u0014XM\\2f\u0003-)\u0005pY3m\u0011\u0016d\u0007/\u001a:\u0011\u0005!Z1CA\u0006!)\t\t)#A\nd_:4\u0017nZ;sCRLwN\u001c(fK\u0012,G-\u0006\u0002\u00020A!\u0011\u0011GA\u001f\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012AB1u_6L7M\u0003\u0003\u0002:\u0005m\u0012AC2p]\u000e,(O]3oi*\u0019\u0011QD3\n\t\u0005}\u00121\u0007\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002)\r|gNZ5hkJ\fG/[8o\u001d\u0016,G-\u001a3!\u0003M\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u001bHi\u001c8f\u0003Q\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u001bHi\u001c8fA\u0005)\u0011\r\u001d9msR\u0019Q&a\u0013\t\u000b\u0019\n\u0002\u0019A\u0014\u0002-\r|gNZ5hkJ,\u0007K]8wS\u0012,'o](oG\u0016$\"!!\u0015\u0011\u0007\u0005\n\u0019&C\u0002\u0002V\t\u0012A!\u00168ji\u0002")
public class ExcelHelper {
    private DataFormatter dataFormatter;
    private final ExcelOptions options;
    private volatile boolean bitmap$0;

    public static void configureProvidersOnce() {
        ExcelHelper$.MODULE$.configureProvidersOnce();
    }

    public static ExcelHelper apply(ExcelOptions options) {
        return ExcelHelper$.MODULE$.apply(options);
    }

    /*
     * WARNING - void declaration
     */
    private DataFormatter dataFormatter$lzycompute() {
        ExcelHelper excelHelper = this;
        synchronized (excelHelper) {
            if (!this.bitmap$0) {
                void var2_2;
                DataFormatter r = new DataFormatter();
                if (this.options.usePlainNumberFormat()) {
                    PlainNumberFormat$ plainNumberFormat = PlainNumberFormat$.MODULE$;
                    r.addFormat("General", plainNumberFormat);
                    r.addFormat("@", plainNumberFormat);
                }
                this.dataFormatter = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.dataFormatter;
    }

    private DataFormatter dataFormatter() {
        if (!this.bitmap$0) {
            return this.dataFormatter$lzycompute();
        }
        return this.dataFormatter;
    }

    public String safeCellStringValue(Cell cell) {
        CellType cellType = cell.getCellType();
        if (((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType)) {
            return "";
        }
        if (((Object)((Object)CellType.STRING)).equals((Object)cellType)) {
            return cell.getStringCellValue();
        }
        if (((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
            CellType cellType2 = cell.getCachedFormulaResultType();
            if (((Object)((Object)CellType.BLANK)).equals((Object)cellType2) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType2)) {
                return "";
            }
            if (((Object)((Object)CellType.ERROR)).equals((Object)cellType2)) {
                return FormulaError.forInt(cell.getErrorCellValue()).getString();
            }
            if (((Object)((Object)CellType.STRING)).equals((Object)cellType2)) {
                return cell.getStringCellValue();
            }
            if (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType2)) {
                return Double.toString(cell.getNumericCellValue());
            }
            return this.dataFormatter().formatCellValue(cell);
        }
        return this.dataFormatter().formatCellValue(cell);
    }

    public Workbook getWorkbook(Configuration conf, URI uri) {
        Workbook workbook;
        block7: {
            try (FSDataInputStream ins = FileSystem.get((URI)uri, (Configuration)conf).open(new Path(uri));){
                Option<Object> option = this.options.maxRowsInMemory();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int maxRows = BoxesRunTime.unboxToInt(some.value());
                    StreamingReader.Builder builder = StreamingReader.builder().bufferSize(maxRows);
                    Option<String> option2 = this.options.workbookPassword();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        String password = (String)some2.value();
                        builder.password(password);
                    }
                    workbook = builder.open((InputStream)ins);
                    break block7;
                }
                Option<String> option3 = this.options.workbookPassword();
                if (option3 instanceof Some) {
                    Some some = (Some)option3;
                    String password = (String)some.value();
                    workbook = WorkbookFactory.create((InputStream)ins, password);
                } else {
                    workbook = WorkbookFactory.create((InputStream)ins);
                }
            }
        }
        return workbook;
    }

    public SheetData<Vector<Cell>> getSheetData(Configuration conf, URI uri) {
        SheetData<Vector<Cell>> sheetData;
        Workbook workbook = this.getWorkbook(conf, uri);
        DataLocator excelReader = DataLocator$.MODULE$.apply(this.options);
        try {
            Iterator<Vector<Cell>> rowIter = excelReader.readFrom(workbook);
            sheetData = new SheetData<Vector<Cell>>(rowIter, new $colon$colon<Nothing$>((Nothing$)((Object)workbook), Nil$.MODULE$));
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable t = option.get();
                workbook.close();
                throw t;
            }
            throw throwable;
        }
        return sheetData;
    }

    public Tuple2<SheetData<Vector<Cell>>, Vector<String>> parseSheetData(Configuration conf, Seq<URI> uris) {
        Vector<String> vector;
        ObjectRef<SheetData<Vector<Cell>>> sheetData = ObjectRef.create(this.getSheetData(conf, (URI)uris.head()));
        if (((SheetData)sheetData.elem).rowIterator().isEmpty()) {
            vector = package$.MODULE$.Vector().empty();
        } else {
            try {
                Vector<String> vector2;
                if (this.options.header()) {
                    Vector<String> r = this.getColumnNames((Vector)((SheetData)sheetData.elem).rowIterator().next());
                    sheetData.elem = ((SheetData)sheetData.elem).modifyIterator((Function1<Iterator, Iterator> & Serializable)x$1 -> x$1.drop($this.options.ignoreAfterHeader()));
                    vector2 = r;
                } else {
                    Vector headerRow = (Vector)((SheetData)sheetData.elem).rowIterator().next();
                    Vector<String> r = this.getColumnNames(headerRow);
                    sheetData.elem = ((SheetData)sheetData.elem).modifyIterator((Function1<Iterator, Iterator> & Serializable)iter -> package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vector[]{headerRow})).$plus$plus((Function0<Iterator> & Serializable)() -> iter));
                    vector2 = r;
                }
                Vector<String> colNames = vector2;
                int numberOfRowToIgnore = this.options.header() ? this.options.ignoreAfterHeader() + 1 : 0;
                sheetData.elem = ((IterableOnceOps)uris.tail()).foldLeft((SheetData)sheetData.elem, (Function2<SheetData, URI, SheetData> & Serializable)(x0$1, x1$1) -> {
                    Tuple2<SheetData, URI> tuple2 = new Tuple2<SheetData, URI>((SheetData)x0$1, (URI)x1$1);
                    if (tuple2 != null) {
                        SheetData rs = tuple2._1();
                        URI path = tuple2._2();
                        SheetData<Vector<Cell>> newRows = this.getSheetData(conf, path).modifyIterator((Function1<Iterator<Vector<Cell>>, Iterator<Vector<Cell>>>)(Function1<Iterator, Iterator> & Serializable)x$2 -> x$2.drop(numberOfRowToIgnore));
                        return rs.append(newRows);
                    }
                    throw new MatchError(tuple2);
                });
                this.options.excerptSize().foreach(excerptSize -> {
                    sheetData$1.elem = ((SheetData)sheetData$1.elem).modifyIterator((Function1<Iterator, Iterator> & Serializable)x$3 -> x$3.take(excerptSize));
                });
                vector = colNames;
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable t = option.get();
                    ((SheetData)sheetData.elem).close();
                    throw t;
                }
                throw throwable;
            }
        }
        Vector<String> colNames = vector;
        return new Tuple2<SheetData, Object>((SheetData)sheetData.elem, colNames);
    }

    public Vector<String> getColumnNames(Vector<Cell> firstRow) {
        Vector vector;
        Object rowNumColumn;
        Object object = rowNumColumn = this.options.columnNameOfRowNumber().isDefined() ? (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.options.columnNameOfRowNumber().get()})) : package$.MODULE$.Vector().empty();
        if (this.options.header()) {
            Vector headerNames = (Vector)firstRow.map((Function1<Cell, String> & Serializable)x$1 -> this.dataFormatter().formatCellValue((Cell)x$1));
            Vector nonNullHeaderNames = (Vector)headerNames.filter((Function1<String, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(ExcelHelper.$anonfun$getColumnNames$2(x$4)));
            Set duplicates = ((MapOps)nonNullHeaderNames.groupBy((Function1<String, String> & Serializable)x -> Predef$.MODULE$.identity(x)).filter((Function1<Tuple2, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(ExcelHelper.$anonfun$getColumnNames$4(x$5)))).keySet();
            vector = (Vector)((StrictOptimizedIterableOps)firstRow.zipWithIndex()).map((Function1<Tuple2, String> & Serializable)x0$1 -> {
                Tuple2 tuple2;
                block4: {
                    String value;
                    int index;
                    block6: {
                        block5: {
                            CellType cellType;
                            tuple2 = x0$1;
                            if (tuple2 == null) break block4;
                            Cell cell = (Cell)tuple2._1();
                            index = tuple2._2$mcI$sp();
                            value = this.dataFormatter().formatCellValue(cell);
                            CellType cellType2 = cellType = cell.getCellType();
                            CellType cellType3 = CellType.ERROR;
                            if (!(cellType2 == null ? cellType3 != null : !((Object)((Object)cellType2)).equals((Object)cellType3))) break block5;
                            CellType cellType4 = cellType;
                            CellType cellType5 = CellType.BLANK;
                            if (!(cellType4 == null ? cellType5 != null : !((Object)((Object)cellType4)).equals((Object)cellType5))) break block5;
                            CellType cellType6 = cellType;
                            CellType cellType7 = CellType._NONE;
                            if ((cellType6 == null ? cellType7 != null : !((Object)((Object)cellType6)).equals((Object)cellType7)) && !value.isEmpty()) break block6;
                        }
                        return new StringBuilder(2).append("_c").append(index).toString();
                    }
                    if (duplicates.contains(value)) {
                        return new StringBuilder(0).append(value).append(index).toString();
                    }
                    return value;
                }
                throw new MatchError(tuple2);
            });
        } else {
            vector = (Vector)((StrictOptimizedIterableOps)firstRow.zipWithIndex()).map((Function1<Tuple2, String> & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    int index = tuple2._2$mcI$sp();
                    return new StringBuilder(2).append("_c").append(index).toString();
                }
                throw new MatchError(tuple2);
            });
        }
        Vector dataColumns = vector;
        return (Vector)((AbstractIterable)rowNumColumn).$plus$plus((IterableOnce)dataColumns);
    }

    public AreaReference parsedRangeAddress() {
        return (AreaReference)Try$.MODULE$.apply((Function0<AreaReference> & Serializable)() -> {
            CellReference cellRef = new CellReference($this.options.dataAddress());
            return new AreaReference(cellRef, new CellReference(cellRef.getSheetName(), SpreadsheetVersion.EXCEL2007.getLastRowIndex(), SpreadsheetVersion.EXCEL2007.getLastColumnIndex(), false, false), SpreadsheetVersion.EXCEL2007);
        }).getOrElse((Function0<AreaReference> & Serializable)() -> new AreaReference($this.options.dataAddress(), SpreadsheetVersion.EXCEL2007));
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$2(String x$4) {
        return x$4 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$4(Tuple2 x$5) {
        return ((SeqOps)x$5._2()).size() > 1;
    }

    public ExcelHelper(ExcelOptions options) {
        this.options = options;
    }
}

