/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.combiner.config;

import com.credibledoc.combiner.config.Config;
import com.credibledoc.combiner.config.TacticConfig;
import com.credibledoc.combiner.exception.CombinerRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigService.class);
    private static final String LOG_COMBINER_PROPERTIES = "log-combiner.properties";
    private Config config;
    private boolean loadingHasBeenTried;

    public Config loadConfig(String configAbsolutePath) {
        File propertiesFile;
        if (this.loadingHasBeenTried) {
            return this.config;
        }
        this.config = new Config();
        if (configAbsolutePath != null) {
            propertiesFile = new File(configAbsolutePath);
            if (!propertiesFile.exists()) {
                throw new CombinerRuntimeException("Configuration file cannot be found. File: '" + propertiesFile.getAbsolutePath() + "'");
            }
            logger.info("Configuration file will be loaded from command-line parameter. File: '{}'", (Object)propertiesFile.getAbsolutePath());
        } else {
            File jarPath = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
            String nextToJar = jarPath.getParent() + File.separator + LOG_COMBINER_PROPERTIES;
            logger.info("Trying to find configuration file next to jar file: '{}'", (Object)nextToJar);
            propertiesFile = new File(nextToJar);
            if (propertiesFile.exists()) {
                logger.info("Configuration file is found next to jar file. File: {}", (Object)propertiesFile.getAbsolutePath());
            }
        }
        if (propertiesFile.exists()) {
            this.loadProperties(propertiesFile);
            logger.info("Configuration loaded: {}", (Object)this.config);
        } else {
            logger.info("Configuration file not found, default Config will be returned.");
        }
        this.loadingHasBeenTried = true;
        return this.config;
    }

    private void loadProperties(File propertiesFile) {
        try (FileInputStream input = new FileInputStream(propertiesFile);){
            String targetFileName;
            String printNodeName;
            Properties properties = new Properties();
            properties.load(input);
            String insertLineSeparatorBetweenFiles = properties.getProperty("insertLineSeparatorBetweenFiles");
            if ("true".equals(insertLineSeparatorBetweenFiles)) {
                this.config.setInsertLineSeparatorBetweenFiles(true);
            }
            if ("false".equals(printNodeName = properties.getProperty("printNodeName"))) {
                this.config.setPrintNodeName(false);
            }
            if ((targetFileName = properties.getProperty("targetFileName")) != null) {
                this.config.setTargetFileName(targetFileName);
            }
            this.loadTacticConfigurations(properties);
        }
        catch (Exception e) {
            throw new CombinerRuntimeException("Configuration file cannot be loaded. File: '" + propertiesFile.getAbsolutePath() + "'", e);
        }
    }

    private void loadTacticConfigurations(Properties properties) {
        int index = 0;
        boolean foundNext = true;
        while (foundNext) {
            String regex = properties.getProperty("regex[" + index + "]");
            String simpleDateFormat = properties.getProperty("simpleDateFormat[" + index + "]");
            if (regex != null && simpleDateFormat != null) {
                TacticConfig tacticConfig = new TacticConfig();
                tacticConfig.setRegex(regex);
                tacticConfig.setSimpleDateFormat(simpleDateFormat);
                String maxIndexEndOfTime = properties.getProperty("maxIndexEndOfTime[" + index + "]");
                tacticConfig.setMaxIndexEndOfTime(Integer.valueOf(maxIndexEndOfTime));
                String applicationName = properties.getProperty("applicationName[" + index + "]");
                tacticConfig.setApplicationName(applicationName);
                this.config.getTacticConfigs().add(tacticConfig);
                ++index;
                continue;
            }
            foundNext = false;
        }
    }
}

