/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.combiner.date;

import com.credibledoc.combiner.exception.CombinerRuntimeException;
import com.credibledoc.combiner.log.buffered.LogBufferedReader;
import com.credibledoc.combiner.log.buffered.LogFileReader;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateService {
    private static final DateService instance = new DateService();

    public static DateService getInstance() {
        return instance;
    }

    public Date parseDateTimeFromLine(String line, SimpleDateFormat simpleDateFormat, Pattern dateTimePattern, int maxIndexEndOfTime) {
        if (line == null) {
            return null;
        }
        try {
            String dateString = this.findDateTime(line, dateTimePattern, maxIndexEndOfTime);
            if (dateString != null) {
                return simpleDateFormat.parse(dateString);
            }
            return null;
        }
        catch (Exception e) {
            throw new CombinerRuntimeException("Cannot parse a date from the line: " + line, e);
        }
    }

    public String findDateTime(String line, Pattern dateTimePattern, int maxIndexEndOfTime) {
        int maxLength = Math.min(line.length(), maxIndexEndOfTime);
        String dateString = null;
        Matcher matcher = dateTimePattern.matcher(line.substring(0, maxLength));
        if (matcher.find()) {
            dateString = matcher.group();
        }
        return dateString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date findDateInFile(File file, SimpleDateFormat simpleDateTimeFormat, Pattern dateTimePattern, int maxIndexEndOfDate) {
        try (LogBufferedReader logBufferedReader = new LogBufferedReader(new LogFileReader(file));){
            String line = logBufferedReader.readLine();
            while (line != null) {
                Date dateTime = this.parseDateTimeFromLine(line, simpleDateTimeFormat, dateTimePattern, maxIndexEndOfDate);
                if (dateTime != null) {
                    Date date = dateTime;
                    return date;
                }
                line = logBufferedReader.readLine();
            }
            Date date = null;
            return date;
        }
        catch (Exception e) {
            throw new CombinerRuntimeException("Cannot find date. File: " + file.getAbsolutePath(), e);
        }
    }
}

