/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.combiner.file;

import com.credibledoc.combiner.context.CombinerContext;
import com.credibledoc.combiner.exception.CombinerRuntimeException;
import com.credibledoc.combiner.file.FileWithSources;
import com.credibledoc.combiner.tactic.Tactic;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileService {
    private static final Logger logger = LoggerFactory.getLogger(FileService.class);
    private static final int MAX_FILE_NAME_LENGTH_255 = 255;
    private static final String SEVEN_ZIP_7Z = ".7z";
    private static final String GZ = ".gz";
    private static final Set<String> extensions;
    public static final String LINUX_LINE_ENDING = "\n";
    public static final String MAC_LINE_ENDING = "\r";
    public static final String WINDOWS_LINE_ENDING = "\r\n";
    public static final String ANY_LINE_ENDING = "\r\n|\n|\r";
    private static final FileService instance;

    public static FileService getInstance() {
        return instance;
    }

    /*
     * Exception decompiling
     */
    public Tactic findTactic(File file, CombinerContext combinerContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Date findDate(File file, Tactic tactic) {
        return tactic.findDate(file);
    }

    public List<File> un7zipIfNotExists(File zipFile, File targetDirectory) {
        ArrayList<File> result = new ArrayList<File>();
        String targetPath = targetDirectory.getAbsolutePath() + File.separator;
        try (SevenZFile sevenZFile = new SevenZFile(zipFile);){
            SevenZArchiveEntry entry;
            while ((entry = sevenZFile.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File dir = new File(targetPath + entry.getName());
                    if (dir.exists()) continue;
                    logger.trace("Creating directory: '{}'", (Object)dir.getAbsolutePath());
                    Files.createDirectories(dir.toPath(), new FileAttribute[0]);
                    continue;
                }
                byte[] content = new byte[(int)entry.getSize()];
                sevenZFile.read(content);
                File nextFile = new File(targetPath + entry.getName());
                if (!nextFile.exists()) {
                    Files.write(nextFile.toPath(), content, new OpenOption[0]);
                    logger.trace("File unzipped: {}", (Object)nextFile.getAbsolutePath());
                } else {
                    logger.trace("File already exists: {}", (Object)nextFile.getAbsolutePath());
                }
                result.add(nextFile);
            }
        }
        catch (IOException e) {
            throw new CombinerRuntimeException("Cannot un7zip " + zipFile.getAbsolutePath(), e);
        }
        return result;
    }

    public List<File> decompressGzIfNotExists(File gzFile, File targetDirectory) {
        ArrayList<File> result = new ArrayList<File>();
        String targetPath = targetDirectory.getAbsolutePath() + File.separator;
        try (FileInputStream fis = new FileInputStream(gzFile);
             GZIPInputStream gzipInputStream = new GZIPInputStream(fis);){
            String oldFileName = gzFile.getName();
            String oldFileNameLower = gzFile.getName().toLowerCase();
            int beginIndex = oldFileNameLower.lastIndexOf(GZ);
            String newFileName = oldFileName.substring(0, beginIndex);
            File decompressedFile = new File(targetPath + newFileName);
            if (!decompressedFile.exists()) {
                this.copyBytes(gzipInputStream, decompressedFile);
                logger.trace("File .gz decompressed: {}", (Object)decompressedFile.getAbsolutePath());
            } else {
                logger.trace("Decompressed file already exists: {}", (Object)decompressedFile.getAbsolutePath());
            }
            result.add(decompressedFile);
        }
        catch (IOException e) {
            throw new CombinerRuntimeException("Cannot un7zip " + gzFile.getAbsolutePath(), e);
        }
        return result;
    }

    public void copyBytes(GZIPInputStream gzipInputStream, File targetFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetFile);){
            IOUtils.copy((InputStream)gzipInputStream, (OutputStream)fos);
        }
    }

    public List<File> decompressIfNotExists(File compressedFile, File targetDirectory) {
        ArrayList<File> result = new ArrayList<File>();
        String targetPath = targetDirectory.getAbsolutePath() + File.separator;
        try (ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(compressedFile)));){
            ArchiveEntry entry;
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                if (!archiveInputStream.canReadEntryData(entry)) {
                    throw new CombinerRuntimeException("Cannot decompress entry '" + entry.getName() + "' from file '" + compressedFile.getAbsolutePath() + "'");
                }
                if (entry.isDirectory()) {
                    File dir = new File(targetPath + entry.getName());
                    this.mkdirsIfNotExists(dir);
                    continue;
                }
                File nextFile = new File(targetPath + entry.getName());
                File dir = nextFile.getParentFile();
                this.mkdirsIfNotExists(dir);
                if (!nextFile.exists()) {
                    try (OutputStream o = Files.newOutputStream(nextFile.toPath(), new OpenOption[0]);){
                        IOUtils.copy((InputStream)archiveInputStream, (OutputStream)o);
                    }
                    logger.trace("File unzipped: {}", (Object)nextFile.getAbsolutePath());
                } else {
                    logger.trace("File already exists: {}", (Object)nextFile.getAbsolutePath());
                }
                result.add(nextFile);
            }
        }
        catch (Exception e) {
            throw new CombinerRuntimeException("Cannot decompress file '" + compressedFile.getAbsolutePath() + "'. Target path: '" + targetPath + "'", e);
        }
        return result;
    }

    public void mkdirsIfNotExists(File dir) throws IOException {
        if (!dir.exists()) {
            logger.trace("Directory will be created: '{}'", (Object)dir.getAbsolutePath());
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
    }

    public Set<File> collectFiles(Set<File> logDirectoriesOrFiles, boolean decompressFiles, File targetDirectory) {
        this.createTargetDirectoryIfNotExists(targetDirectory);
        TreeSet<File> result = new TreeSet<File>();
        for (File file : logDirectoriesOrFiles) {
            if (targetDirectory == null) {
                this.copyAndCollectFilesRecursively(file, decompressFiles, file.getParentFile(), result, false);
                continue;
            }
            this.copyAndCollectFilesRecursively(file, decompressFiles, targetDirectory, result, true);
        }
        return result;
    }

    public List<FileWithSources> collectFiles(List<FileWithSources> logDirectoriesOrFiles, boolean decompressFiles, File targetDirectory) {
        this.validateSources(logDirectoriesOrFiles);
        this.createTargetDirectoryIfNotExists(targetDirectory);
        ArrayList<FileWithSources> result = new ArrayList<FileWithSources>();
        for (FileWithSources fileWithSources : logDirectoriesOrFiles) {
            if (targetDirectory == null) {
                File source = fileWithSources.getSources().get(fileWithSources.getSources().size() - 1);
                this.copyAndCollectFilesRecursively(fileWithSources, decompressFiles, source.getParentFile(), result, false);
                continue;
            }
            this.copyAndCollectFilesRecursively(fileWithSources, decompressFiles, targetDirectory, result, true);
        }
        return result;
    }

    public void createTargetDirectoryIfNotExists(File targetDirectory) {
        if (targetDirectory != null && !targetDirectory.exists()) {
            if (targetDirectory.getAbsolutePath().length() > 255) {
                throw new CombinerRuntimeException("TargetDirectory name length is greater than 255 chars. File name: " + targetDirectory.getAbsolutePath());
            }
            boolean created = targetDirectory.mkdirs();
            if (!created) {
                throw new CombinerRuntimeException("Cannot create directory: '" + targetDirectory.getAbsolutePath() + "'");
            }
        }
    }

    private void copyAndCollectFilesRecursively(File sourceFileOrDirectory, boolean decompressFiles, File targetDirectory, Set<File> result, boolean copyFiles) {
        if (sourceFileOrDirectory.isFile()) {
            this.decompressAndCopyFile(sourceFileOrDirectory, decompressFiles, targetDirectory, result, copyFiles);
        } else {
            File[] files = sourceFileOrDirectory.listFiles();
            if (files == null) {
                return;
            }
            File innerTargetDirectory = new File(targetDirectory, sourceFileOrDirectory.getName());
            this.createTargetDirectoryIfNotExists(innerTargetDirectory);
            for (File file : files) {
                this.copyAndCollectFilesRecursively(file, decompressFiles, innerTargetDirectory, result, copyFiles);
            }
        }
    }

    private void copyAndCollectFilesRecursively(FileWithSources sourceFileOrDirectory, boolean decompressFiles, File targetDirectory, List<FileWithSources> result, boolean copyFiles) {
        File lastSource = sourceFileOrDirectory.getSources().get(sourceFileOrDirectory.getSources().size() - 1);
        if (lastSource.isFile()) {
            this.decompressAndCopyFile(sourceFileOrDirectory, decompressFiles, targetDirectory, result, copyFiles);
        } else {
            File[] files = lastSource.listFiles();
            if (files == null) {
                return;
            }
            File innerTargetDirectory = new File(targetDirectory, lastSource.getName());
            for (File file : files) {
                FileWithSources fileWithSources = new FileWithSources();
                fileWithSources.getSources().addAll(sourceFileOrDirectory.getSources());
                fileWithSources.getSources().add(file);
                this.copyAndCollectFilesRecursively(fileWithSources, decompressFiles, innerTargetDirectory, result, copyFiles);
            }
        }
    }

    private void decompressAndCopyFile(File fileOrDirectory, boolean decompressFiles, File targetDirectory, Set<File> result, boolean copyFiles) {
        boolean isFile = fileOrDirectory.isFile();
        boolean shouldBeDecompressed = false;
        if (isFile && decompressFiles) {
            shouldBeDecompressed = this.canBeDecompressed(fileOrDirectory.getName());
        }
        if (shouldBeDecompressed) {
            try {
                List<File> decompressed = this.decompress(fileOrDirectory, targetDirectory);
                result.addAll(decompressed);
                for (File file : decompressed) {
                    if (!this.canBeDecompressed(file.getName())) continue;
                    this.decompressAndCopyFile(file, true, file.getParentFile(), result, copyFiles);
                    result.remove(file);
                }
            }
            catch (Exception e) {
                logger.error("Cannot decompress file '{}'", (Object)fileOrDirectory.getAbsolutePath(), (Object)e);
                result.add(fileOrDirectory);
            }
            return;
        }
        if (copyFiles) {
            File file = this.copyFile(fileOrDirectory, targetDirectory);
            result.add(file);
        } else {
            result.add(fileOrDirectory);
        }
    }

    private void decompressAndCopyFile(FileWithSources fileOrDirectory, boolean decompressFiles, File targetDirectory, List<FileWithSources> result, boolean copyFiles) {
        File lastSource = fileOrDirectory.getSources().get(fileOrDirectory.getSources().size() - 1);
        boolean isFile = lastSource.isFile();
        boolean shouldBeDecompressed = false;
        if (isFile && decompressFiles) {
            shouldBeDecompressed = this.canBeDecompressed(lastSource.getName());
        }
        if (shouldBeDecompressed) {
            try {
                this.tryToDecompress(fileOrDirectory, targetDirectory, result, copyFiles, lastSource);
            }
            catch (Exception e) {
                logger.error("Cannot decompress file '{}'", (Object)lastSource.getAbsolutePath(), (Object)e);
                if (fileOrDirectory.getFile() != null) {
                    throw new CombinerRuntimeException("Expected that fileOrDirectory.file is null, but found: " + fileOrDirectory);
                }
                fileOrDirectory.setFile(lastSource);
                result.add(fileOrDirectory);
            }
            return;
        }
        if (fileOrDirectory.getFile() != null) {
            throw new CombinerRuntimeException("Expected that fileOrDirectory.file is null, but found: " + fileOrDirectory);
        }
        if (copyFiles) {
            File file = this.copyFile(lastSource, targetDirectory);
            fileOrDirectory.setFile(file);
        } else {
            fileOrDirectory.setFile(lastSource);
        }
        result.add(fileOrDirectory);
    }

    private void tryToDecompress(FileWithSources fileOrDirectory, File targetDirectory, List<FileWithSources> result, boolean copyFiles, File lastSource) {
        List<File> decompressed = this.decompress(lastSource, targetDirectory);
        for (File next : decompressed) {
            if (this.canBeDecompressed(next.getName())) {
                fileOrDirectory.getSources().add(next);
                this.decompressAndCopyFile(fileOrDirectory, true, next.getParentFile(), result, copyFiles);
                continue;
            }
            FileWithSources fileWithSources = new FileWithSources();
            fileWithSources.setFile(next);
            fileWithSources.getSources().addAll(fileOrDirectory.getSources());
            result.add(fileWithSources);
        }
    }

    private List<File> decompress(File compressed, File targetDirectory) {
        String lowerCase = compressed.getName().toLowerCase();
        if (lowerCase.endsWith(SEVEN_ZIP_7Z)) {
            return this.un7zipIfNotExists(compressed, targetDirectory);
        }
        if (lowerCase.endsWith(GZ)) {
            return this.decompressGzIfNotExists(compressed, targetDirectory);
        }
        for (String extension : extensions) {
            if (!lowerCase.endsWith(extension)) continue;
            return this.decompressIfNotExists(compressed, targetDirectory);
        }
        throw new CombinerRuntimeException("Cannot decompress file. Unknown file extension. File: " + compressed.getAbsolutePath());
    }

    private boolean canBeDecompressed(String name) {
        String lowerCase = name.toLowerCase();
        for (String extension : extensions) {
            if (!lowerCase.endsWith(extension)) continue;
            return true;
        }
        return lowerCase.endsWith(SEVEN_ZIP_7Z) || lowerCase.endsWith(GZ);
    }

    private File copyFile(File file, File targetDirectory) {
        try {
            this.createTargetDirectoryIfNotExists(targetDirectory);
            File copied = new File(targetDirectory, file.getName());
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                 BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(copied));){
                int lengthRead;
                byte[] buffer = new byte[1024];
                while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, lengthRead);
                }
                ((OutputStream)out).flush();
            }
            return copied;
        }
        catch (Exception e) {
            throw new CombinerRuntimeException("Cannot copy file '" + file.getAbsolutePath() + "' to the directory '" + targetDirectory.getAbsolutePath() + "'", e);
        }
    }

    public Set<File> collectFiles(File logDirectoryOrFile, boolean decompressFiles, File targetDirectory) {
        TreeSet<File> files = new TreeSet<File>(Collections.singletonList(logDirectoryOrFile));
        return this.collectFiles(files, decompressFiles, targetDirectory);
    }

    public List<FileWithSources> collectFiles(FileWithSources logDirectoryOrFile, boolean decompressFiles, File targetDirectory) {
        List<FileWithSources> files = Collections.singletonList(logDirectoryOrFile);
        return this.collectFiles(files, decompressFiles, targetDirectory);
    }

    private void validateSources(FileWithSources logDirectoryOrFile) {
        if (logDirectoryOrFile.getFile() != null) {
            throw new CombinerRuntimeException("Expected 'null' FileWithSources.file, but found non-nul value in " + logDirectoryOrFile);
        }
        if (logDirectoryOrFile.getSources().isEmpty()) {
            throw new CombinerRuntimeException("Expected at lease one existing source file or directory in FileWithSources.sources list. The last one will be used as a source. " + logDirectoryOrFile);
        }
        File sourceFile = logDirectoryOrFile.getSources().get(logDirectoryOrFile.getSources().size() - 1);
        if (!sourceFile.exists()) {
            throw new CombinerRuntimeException("Source file '" + sourceFile.getAbsolutePath() + "' doesn't exist. " + logDirectoryOrFile);
        }
    }

    protected void validateSources(List<FileWithSources> sources) {
        for (FileWithSources fileWithSources : sources) {
            this.validateSources(fileWithSources);
        }
    }

    public Set<File> collectFiles(Set<File> logDirectoriesOrFiles, boolean decompressFiles) {
        try {
            Path tempPath = Files.createTempDirectory("log-combiner-core", new FileAttribute[0]);
            File tempDirectory = tempPath.toFile();
            tempDirectory.deleteOnExit();
            return this.collectFiles(logDirectoriesOrFiles, decompressFiles, tempDirectory);
        }
        catch (Exception e) {
            throw new CombinerRuntimeException("Cannot collect files.", e);
        }
    }

    public List<FileWithSources> collectFiles(List<FileWithSources> logDirectoriesOrFiles, boolean decompressFiles) {
        try {
            Path tempPath = Files.createTempDirectory("log-combiner-core", new FileAttribute[0]);
            File tempDirectory = tempPath.toFile();
            tempDirectory.deleteOnExit();
            return this.collectFiles(logDirectoriesOrFiles, decompressFiles, tempDirectory);
        }
        catch (Exception e) {
            throw new CombinerRuntimeException("Cannot collect files.", e);
        }
    }

    public Set<File> collectFiles(File logDirectoryOrFile, boolean decompressFiles) {
        TreeSet<File> files = new TreeSet<File>(Collections.singletonList(logDirectoryOrFile));
        return this.collectFiles(files, decompressFiles);
    }

    public List<FileWithSources> collectFiles(FileWithSources logDirectoryOrFile, boolean decompressFiles) {
        List<FileWithSources> files = Collections.singletonList(logDirectoryOrFile);
        return this.collectFiles(files, decompressFiles);
    }

    public Set<File> collectFiles(Set<File> logDirectoriesOrFiles) {
        return this.collectFiles(logDirectoriesOrFiles, false);
    }

    public List<FileWithSources> collectFiles(List<FileWithSources> logDirectoriesOrFiles) {
        return this.collectFiles(logDirectoriesOrFiles, false);
    }

    public Set<File> collectFiles(File logDirectoryOrFile) {
        TreeSet<File> files = new TreeSet<File>(Collections.singletonList(logDirectoryOrFile));
        return this.collectFiles(files, false);
    }

    public List<FileWithSources> collectFiles(FileWithSources logDirectoryOrFile) {
        List<FileWithSources> fileWithSources = Collections.singletonList(logDirectoryOrFile);
        return this.collectFiles(fileWithSources, false);
    }

    public static String findLineEnding(String content) {
        String lineEnding = FileService.findLineEndingIfExists(content);
        if (lineEnding != null) {
            return lineEnding;
        }
        return System.lineSeparator();
    }

    public static String findLineEndingIfExists(String content) {
        if (content == null) {
            return null;
        }
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(content.indexOf(MAC_LINE_ENDING), MAC_LINE_ENDING);
        map.put(content.indexOf(LINUX_LINE_ENDING), LINUX_LINE_ENDING);
        map.put(content.indexOf(WINDOWS_LINE_ENDING), WINDOWS_LINE_ENDING);
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getKey() <= -1) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findLineEndingIfExists(File file) {
        if (file == null) return null;
        if (!file.exists()) {
            return null;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            StringBuilder stringBuilder = new StringBuilder(100);
            char[] buf = new char[1];
            boolean containsLineEnding = false;
            while (true) {
                int read;
                if ((read = bufferedReader.read(buf, 0, 1)) == -1) {
                    String string = FileService.findLineEndingIfExists(stringBuilder.toString());
                    return string;
                }
                String character = new String(buf);
                stringBuilder.append(character);
                if (MAC_LINE_ENDING.equals(character)) {
                    containsLineEnding = true;
                    continue;
                }
                if (LINUX_LINE_ENDING.equals(character)) {
                    containsLineEnding = true;
                }
                if (containsLineEnding) {
                    String string = FileService.findLineEndingIfExists(stringBuilder.toString());
                    return string;
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String findLineEnding(File file) {
        String lineEnding = FileService.findLineEndingIfExists(file);
        if (lineEnding != null) {
            return lineEnding;
        }
        return System.lineSeparator();
    }

    static {
        instance = new FileService();
        extensions = new HashSet<String>();
        extensions.add(".zip");
        extensions.add(".tar");
        extensions.add(".ar");
        extensions.add(".arj");
        extensions.add(".cpio");
        extensions.add(".dump");
    }
}

