/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.combiner.log.buffered;

import com.credibledoc.combiner.exception.CombinerRuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Date;

public class LogBufferedReader
extends BufferedReader {
    private final Reader reader;
    private boolean closed;
    private Date lineDate;

    public LogBufferedReader(Reader reader) {
        super(reader);
        this.reader = reader;
    }

    public String toString() {
        return "LogBufferedReader{reader=\"" + this.reader + "\", lineDate=\"" + this.lineDate + "\", closed=\"" + this.closed + "\"}";
    }

    @Override
    public void mark(int maxCharactersInOneLine) {
        try {
            super.mark(maxCharactersInOneLine);
        }
        catch (IOException e) {
            throw new CombinerRuntimeException(e);
        }
    }

    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void close() {
        try {
            this.closed = true;
            super.close();
        }
        catch (IOException e) {
            throw new CombinerRuntimeException(e);
        }
    }

    public boolean isNotClosed() {
        return !this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public String readLine() throws IOException {
        this.lineDate = null;
        if (this.closed) {
            return null;
        }
        return super.readLine();
    }

    @Override
    public int read() throws IOException {
        this.lineDate = null;
        return super.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.lineDate = null;
        return super.read(cbuf, off, len);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        this.lineDate = null;
        return super.read(target);
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        this.lineDate = null;
        return super.read(cbuf);
    }

    public Date getLineDate() {
        return this.lineDate;
    }

    public void setLineDate(Date lineDate) {
        this.lineDate = lineDate;
    }
}

