/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.combiner.log.buffered;

import com.credibledoc.combiner.exception.CombinerRuntimeException;
import com.credibledoc.combiner.log.buffered.LogFileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class LogConcatenatedInputStream
extends InputStream {
    private Enumeration<LogFileInputStream> enumeration;
    private LogFileInputStream currentInputStream;
    private LogFileInputStream lastInputStream;

    public LogConcatenatedInputStream(Enumeration<LogFileInputStream> enumeration) {
        this.enumeration = enumeration;
        try {
            this.closeAndGetNextStream();
        }
        catch (IOException e) {
            throw new CombinerRuntimeException(e);
        }
    }

    @Override
    public int available() throws IOException {
        if (this.currentInputStream == null) {
            return 0;
        }
        return this.currentInputStream.available();
    }

    @Override
    public int read() throws IOException {
        while (this.currentInputStream != null) {
            int read = this.currentInputStream.read();
            if (read != -1) {
                return read;
            }
            this.closeAndGetNextStream();
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.currentInputStream == null) {
            return -1;
        }
        if (bytes == null) {
            throw new CombinerRuntimeException("Parameter 'bytes' is null");
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        do {
            int read;
            if ((read = this.currentInputStream.read(bytes, offset, length)) > 0) {
                return read;
            }
            this.closeAndGetNextStream();
        } while (this.currentInputStream != null);
        return -1;
    }

    @Override
    public void close() throws IOException {
        do {
            this.closeAndGetNextStream();
        } while (this.currentInputStream != null);
    }

    private void closeAndGetNextStream() throws IOException {
        if (this.currentInputStream != null) {
            this.currentInputStream.close();
        }
        if (this.enumeration.hasMoreElements()) {
            this.lastInputStream = this.currentInputStream = this.enumeration.nextElement();
            if (this.currentInputStream == null) {
                throw new NullPointerException();
            }
        } else {
            this.currentInputStream = null;
        }
    }

    public LogFileInputStream getCurrentStream() {
        return this.lastInputStream;
    }
}

