/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.combiner.log.reader;

import com.credibledoc.combiner.context.CombinerContext;
import com.credibledoc.combiner.exception.CombinerRuntimeException;
import com.credibledoc.combiner.log.buffered.LogBufferedReader;
import com.credibledoc.combiner.log.buffered.LogConcatenatedInputStream;
import com.credibledoc.combiner.log.buffered.LogFileInputStream;
import com.credibledoc.combiner.log.buffered.LogInputStreamReader;
import com.credibledoc.combiner.node.file.NodeFile;
import com.credibledoc.combiner.node.file.NodeFileTreeSet;
import com.credibledoc.combiner.state.FilesMergerState;
import com.credibledoc.combiner.tactic.Tactic;
import com.credibledoc.combiner.tactic.TacticService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderService {
    private static final Logger logger = LoggerFactory.getLogger(ReaderService.class);
    private static final int MAX_CHARACTERS_IN_ONE_LINE = 99999;
    public static final String COMBINER_CORE_MODULE_NAME = "log-combiner-core";
    private static final ReaderService instance = new ReaderService();
    public static final String IGNORE_EXCEPTIONS = "ignore.exceptions";

    public static ReaderService getInstance() {
        return instance;
    }

    public List<String> readMultiline(String line, LogBufferedReader logBufferedReader, CombinerContext combinerContext) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Date lineDate = logBufferedReader.getLineDate();
            result.add(this.cutIfLonger(line));
            logBufferedReader.mark(99999);
            line = logBufferedReader.readLine();
            while (line != null) {
                boolean tooLongLine;
                boolean bl = tooLongLine = line.length() > 99999;
                if (tooLongLine) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Line is longer than {} chars. Line begins with: '{}'.", (Object)99999, (Object)this.cutIfLonger(line));
                    }
                    return result;
                }
                if (this.containsStartPattern(line, logBufferedReader, combinerContext)) {
                    logBufferedReader.reset();
                    logBufferedReader.setLineDate(lineDate);
                    return result;
                }
                result.add(this.cutIfLonger(line));
                logBufferedReader.mark(99999);
                line = logBufferedReader.readLine();
            }
            logBufferedReader.setLineDate(lineDate);
            return result;
        }
        catch (IOException e) {
            String message = "ReadMultiline failed. Line: '" + this.cutIfLonger(line) + "', Result: " + ((Object)result).toString();
            throw new CombinerRuntimeException(message, e);
        }
    }

    public String cutIfLonger(String line) {
        if (line == null) {
            return null;
        }
        return line.length() > 99999 ? line.substring(0, 99999) : line;
    }

    private boolean containsStartPattern(String line, LogBufferedReader logBufferedReader, CombinerContext combinerContext) {
        Tactic tactic = TacticService.getInstance().findTactic(logBufferedReader, combinerContext);
        return tactic.containsDate(line);
    }

    public String readLineFromReaders(FilesMergerState filesMergerState) {
        File file = null;
        try {
            NodeFile actualNodeFile;
            NodeFile currentNodeFile = filesMergerState.getCurrentNodeFile();
            if (currentNodeFile != null) {
                currentNodeFile.getLogBufferedReader().setLineDate(null);
            }
            if ((actualNodeFile = this.findTheOldest(filesMergerState)) == null) {
                return null;
            }
            LogBufferedReader logBufferedReader = actualNodeFile.getLogBufferedReader();
            file = ReaderService.getInstance().getFile(logBufferedReader);
            Date lineDate = logBufferedReader.getLineDate();
            String line = logBufferedReader.readLine();
            if (line != null) {
                if (lineDate == null) {
                    lineDate = actualNodeFile.getNodeLog().getTactic().findDate(line);
                }
                logBufferedReader.setLineDate(lineDate);
            }
            filesMergerState.setCurrentNodeFile(actualNodeFile);
            return line;
        }
        catch (IOException e) {
            if ("true".equals(System.getProperty(IGNORE_EXCEPTIONS))) {
                String path = file == null ? null : file.getAbsolutePath();
                logger.info("Exception: {}. File: '{}'", (Object)e.getMessage(), (Object)path);
                return null;
            }
            throw new CombinerRuntimeException(e);
        }
    }

    public NodeFile findTheOldest(FilesMergerState filesMergerState) {
        try {
            NodeFile result = filesMergerState.getCurrentNodeFile();
            for (NodeFile nodeFile : filesMergerState.getNodeFiles()) {
                if (result == null) {
                    result = nodeFile;
                    continue;
                }
                if (nodeFile == result || nodeFile.getLogBufferedReader() == null || !nodeFile.getLogBufferedReader().isNotClosed()) continue;
                result = this.getOlderNodeFile(result, nodeFile);
            }
            return result;
        }
        catch (Exception e) {
            throw new CombinerRuntimeException(e);
        }
    }

    private NodeFile getOlderNodeFile(NodeFile actual, NodeFile next) throws IOException {
        boolean isNextLineOlder;
        LogBufferedReader nextLogBufferedReader = next.getLogBufferedReader();
        LogBufferedReader actualLogBufferedReader = actual.getLogBufferedReader();
        Date actualLineDate = actualLogBufferedReader.getLineDate();
        if (actualLogBufferedReader.isNotClosed()) {
            actualLogBufferedReader.mark(1);
            if (actualLogBufferedReader.read() == -1) {
                actualLogBufferedReader.close();
                return next;
            }
        } else {
            return next;
        }
        actualLogBufferedReader.reset();
        actualLogBufferedReader.setLineDate(actualLineDate);
        Date nextLineDate = nextLogBufferedReader.getLineDate();
        if (nextLineDate == null) {
            this.readLineDate(next, nextLogBufferedReader);
            nextLineDate = nextLogBufferedReader.getLineDate();
        }
        if (actualLineDate == null) {
            this.readLineDate(actual, actualLogBufferedReader);
            actualLineDate = actualLogBufferedReader.getLineDate();
        }
        boolean isNextLast = false;
        nextLogBufferedReader.mark(1);
        if (nextLogBufferedReader.read() == -1) {
            isNextLast = true;
        }
        nextLogBufferedReader.reset();
        nextLogBufferedReader.setLineDate(nextLineDate);
        boolean isNextLineWithoutDate = nextLineDate == null && !isNextLast;
        boolean isNextNodeFileOlder = actualLineDate != null && isNextLineWithoutDate && next.getDate().before(actualLineDate);
        boolean bl = isNextLineOlder = nextLineDate != null && actualLineDate != null && nextLineDate.before(actualLineDate);
        if (isNextNodeFileOlder || isNextLineOlder) {
            return next;
        }
        return actual;
    }

    private void readLineDate(NodeFile nodeFile, LogBufferedReader nextLogBufferedReader) throws IOException {
        nextLogBufferedReader.mark(99999);
        String nextLine = nextLogBufferedReader.readLine();
        try {
            nextLogBufferedReader.reset();
        }
        catch (Exception e) {
            File file = ReaderService.getInstance().getFile(nextLogBufferedReader);
            if ("true".equals(System.getProperty(IGNORE_EXCEPTIONS))) {
                String path = file == null ? null : file.getAbsolutePath();
                logger.info("Exception: {}. File: '{}'", (Object)e.getMessage(), (Object)path);
                return;
            }
            throw e;
        }
        if (nextLine != null) {
            Tactic nextTactic = nodeFile.getNodeLog().getTactic();
            Date date = nextTactic.findDate(nextLine, nodeFile);
            nextLogBufferedReader.setLineDate(date);
        }
    }

    public File getFile(LogBufferedReader logBufferedReader) {
        if (logBufferedReader == null) {
            return null;
        }
        LogInputStreamReader logInputStreamReader = (LogInputStreamReader)logBufferedReader.getReader();
        LogConcatenatedInputStream logConcatenatedInputStream = (LogConcatenatedInputStream)logInputStreamReader.getInputStream();
        if (logConcatenatedInputStream == null) {
            return null;
        }
        LogFileInputStream logFileInputStream = logConcatenatedInputStream.getCurrentStream();
        if (logFileInputStream == null) {
            return null;
        }
        return logFileInputStream.getFile();
    }

    public void prepareBufferedReaders(CombinerContext combinerContext) {
        NodeFileTreeSet<NodeFile> nodeFiles = combinerContext.getNodeFileRepository().getNodeFiles();
        this.prepareBufferedReaders(combinerContext, nodeFiles);
    }

    public void prepareBufferedReaders(CombinerContext combinerContext, NodeFileTreeSet<NodeFile> nodeFiles) {
        try {
            long startNanos = System.nanoTime();
            for (NodeFile nodeFile : nodeFiles) {
                ArrayList<LogFileInputStream> inputStreams = new ArrayList<LogFileInputStream>();
                inputStreams.add(new LogFileInputStream(nodeFile.getFileWithSources().getFile()));
                Enumeration<LogFileInputStream> enumeration = Collections.enumeration(inputStreams);
                LogConcatenatedInputStream logConcatenatedInputStream = new LogConcatenatedInputStream(enumeration);
                LogInputStreamReader logInputStreamReader = new LogInputStreamReader((InputStream)logConcatenatedInputStream, StandardCharsets.UTF_8);
                LogBufferedReader logBufferedReader = new LogBufferedReader(logInputStreamReader);
                if (nodeFile.getLogBufferedReader() != null && nodeFile.getLogBufferedReader().isNotClosed()) {
                    throw new CombinerRuntimeException("LogBufferedReader is not closed yet. Expected 'null' or closed LogBufferedReader.");
                }
                nodeFile.setLogBufferedReader(logBufferedReader);
            }
            long durationInNanoseconds = System.nanoTime() - startNanos;
            String durationInMs = durationInNanoseconds / 1000000L + "," + durationInNanoseconds % 1000000L;
            logger.trace("Duration of prepareBufferedReaders is {} milliseconds", (Object)durationInMs);
        }
        catch (Exception e) {
            throw new CombinerRuntimeException(e);
        }
    }
}

