/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.combiner.node.log;

import com.credibledoc.combiner.context.CombinerContext;
import com.credibledoc.combiner.exception.CombinerRuntimeException;
import com.credibledoc.combiner.file.FileWithSources;
import com.credibledoc.combiner.log.buffered.LogBufferedReader;
import com.credibledoc.combiner.node.file.NodeFile;
import com.credibledoc.combiner.node.log.NodeLog;
import com.credibledoc.combiner.node.log.NodeLogTreeSet;
import com.credibledoc.combiner.tactic.Tactic;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class NodeLogService {
    private static final NodeLogService instance = new NodeLogService();

    public static NodeLogService getInstance() {
        return instance;
    }

    public NodeLog createNodeLog(FileWithSources nodeFileFile, CombinerContext combinerContext, Tactic tactic) {
        NodeLog nodeLog = new NodeLog();
        nodeLog.setTactic(tactic);
        nodeLog.setName(nodeFileFile.getFile().getParentFile().getName());
        combinerContext.getNodeLogRepository().getNodeLogs().add(nodeLog);
        return nodeLog;
    }

    public Set<NodeLog> findNodeLogs(Tactic tactic, CombinerContext combinerContext) {
        NodeLogTreeSet<NodeLog> nodeLogs = combinerContext.getNodeLogRepository().getNodeLogs();
        TreeSet<NodeLog> treeSet = nodeLogs.get(tactic);
        if (treeSet == null) {
            return Collections.emptySet();
        }
        return treeSet;
    }

    private NodeLog findNodeLog(LogBufferedReader logBufferedReader, CombinerContext combinerContext) {
        for (NodeFile nodeFile : combinerContext.getNodeFileRepository().getNodeFiles()) {
            if (nodeFile.getLogBufferedReader() != logBufferedReader) continue;
            return nodeFile.getNodeLog();
        }
        throw new CombinerRuntimeException("NodeLog cannot be 'null'");
    }

    public String findNodeName(LogBufferedReader logBufferedReader, CombinerContext combinerContext) {
        return this.findNodeLog(logBufferedReader, combinerContext).getName();
    }
}

