/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.combiner.tactic;

import com.credibledoc.combiner.context.CombinerContext;
import com.credibledoc.combiner.exception.CombinerRuntimeException;
import com.credibledoc.combiner.file.FileService;
import com.credibledoc.combiner.file.FileWithSources;
import com.credibledoc.combiner.log.buffered.LogBufferedReader;
import com.credibledoc.combiner.log.reader.ReaderService;
import com.credibledoc.combiner.node.file.NodeFile;
import com.credibledoc.combiner.node.file.NodeFileService;
import com.credibledoc.combiner.tactic.Tactic;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class TacticService {
    private static final TacticService instance = new TacticService();

    public static TacticService getInstance() {
        return instance;
    }

    public Tactic findTactic(String line, LogBufferedReader logBufferedReader, CombinerContext combinerContext) {
        Set<Tactic> tactics = combinerContext.getTacticRepository().getTactics();
        if (tactics.isEmpty()) {
            throw new CombinerRuntimeException("TacticRepository is empty.");
        }
        for (Tactic tactic : tactics) {
            if (!tactic.identifyApplication(line, logBufferedReader)) continue;
            return tactic;
        }
        return null;
    }

    public Tactic findTactic(LogBufferedReader logBufferedReader, CombinerContext combinerContext) {
        for (NodeFile nodeFile : combinerContext.getNodeFileRepository().getNodeFiles()) {
            if (nodeFile.getLogBufferedReader() != logBufferedReader) continue;
            return nodeFile.getNodeLog().getTactic();
        }
        throw new CombinerRuntimeException("Tactic cannot be found. LogBufferedReader: " + logBufferedReader);
    }

    public void prepareReaders(List<FileWithSources> sources, CombinerContext combinerContext) {
        NodeFileService nodeFileService = NodeFileService.getInstance();
        for (FileWithSources fileWithSources : sources) {
            File file = fileWithSources.getFile();
            Tactic tactic = FileService.getInstance().findTactic(file, combinerContext);
            Date date = FileService.getInstance().findDate(file, tactic);
            if (date == null) {
                throw new CombinerRuntimeException("Cannot find a date in the file: " + file.getAbsolutePath());
            }
            nodeFileService.appendToNodeLogs(fileWithSources, date, tactic, combinerContext);
        }
        ReaderService readerService = ReaderService.getInstance();
        readerService.prepareBufferedReaders(combinerContext);
    }
}

