/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.enricher.line;

import com.credibledoc.enricher.context.EnricherContext;
import com.credibledoc.enricher.line.LineProcessor;
import com.credibledoc.enricher.printable.Printable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineProcessorService {
    private static final LineProcessorService instance = new LineProcessorService();

    public static LineProcessorService getInstance() {
        return instance;
    }

    public List<LineProcessor> getLineProcessors(EnricherContext enricherContext) {
        return enricherContext.getLineProcessorRepository().getLineProcessors();
    }

    public List<LineProcessor> getLineProcessors(Printable printable, EnricherContext enricherContext) {
        if (enricherContext.getPrintableToLineProcessorsMap().isEmpty()) {
            this.initializeCache(enricherContext);
        }
        if (enricherContext.getPrintableToLineProcessorsMap().containsKey(printable)) {
            return enricherContext.getPrintableToLineProcessorsMap().get(printable);
        }
        return Collections.emptyList();
    }

    public void addAll(List<LineProcessor> lineProcessors, EnricherContext enricherContext) {
        enricherContext.getPrintableToLineProcessorsMap().clear();
        enricherContext.getLineProcessorRepository().getLineProcessors().addAll(lineProcessors);
    }

    private void initializeCache(EnricherContext enricherContext) {
        for (LineProcessor lineProcessor : this.getLineProcessors(enricherContext)) {
            Printable printable = lineProcessor.getPrintable();
            if (enricherContext.getPrintableToLineProcessorsMap().containsKey(printable)) {
                enricherContext.getPrintableToLineProcessorsMap().get(printable).add(lineProcessor);
                continue;
            }
            ArrayList<LineProcessor> list = new ArrayList<LineProcessor>();
            list.add(lineProcessor);
            enricherContext.getPrintableToLineProcessorsMap().put(printable, list);
        }
    }
}

