/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.enricher.transformer;

import com.credibledoc.combiner.context.CombinerContext;
import com.credibledoc.combiner.log.buffered.LogBufferedReader;
import com.credibledoc.enricher.context.EnricherContext;
import com.credibledoc.enricher.line.LineProcessor;
import com.credibledoc.enricher.line.LineProcessorService;
import com.credibledoc.enricher.printable.Printable;
import java.util.List;

public class TransformerService {
    private static final TransformerService instance = new TransformerService();

    public static TransformerService getInstance() {
        return instance;
    }

    public void transformToReport(Printable printable, List<String> multiline, LogBufferedReader logBufferedReader, CombinerContext combinerContext, EnricherContext enricherContext) {
        List<LineProcessor> lineProcessors = LineProcessorService.getInstance().getLineProcessors(printable, enricherContext);
        for (LineProcessor lineProcessor : lineProcessors) {
            boolean isApplicable = lineProcessor.getSearchCommand().isApplicable(printable, multiline, logBufferedReader);
            if (!isApplicable) continue;
            String transformed = lineProcessor.getTransformer().transform(printable, multiline, logBufferedReader, combinerContext);
            if (transformed != null) {
                printable.getPrintWriter().write(transformed + System.lineSeparator());
            }
            if (printable.checkAllLineProcessors()) continue;
            break;
        }
    }
}

