/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.enricher.xml;

import com.credibledoc.combiner.exception.CombinerRuntimeException;
import com.credibledoc.combiner.file.FileService;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class XmlFormatter {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final LSSerializer writer;

    private XmlFormatter() {
        throw new CombinerRuntimeException("Don't instantiate this static helper, please");
    }

    public static String getPrettyString(String xml, boolean suppressException) {
        try {
            boolean hasHeader = xml.contains("?xml");
            String lineEnding = FileService.findLineEndingIfExists(xml);
            int headerEndIndex = 0;
            if (hasHeader) {
                int headerEnd = xml.indexOf(">");
                headerEndIndex = xml.indexOf("<", headerEnd);
            }
            String formattedXml = XmlFormatter.format(xml, false);
            String header = xml.substring(0, headerEndIndex);
            String headerAndXml = header + formattedXml;
            if (lineEnding != null) {
                return headerAndXml.replaceAll("\r\n|\n|\r", lineEnding);
            }
            return headerAndXml;
        }
        catch (Exception e) {
            if (suppressException) {
                return xml;
            }
            throw new CombinerRuntimeException(e);
        }
    }

    public static String getPrettyString(String xml) {
        return XmlFormatter.getPrettyString(xml, true);
    }

    public static String format(String xml, boolean keepDeclaration) {
        try {
            InputSource src = new InputSource(new StringReader(xml));
            Element document = documentBuilderFactory.newDocumentBuilder().parse(src).getDocumentElement();
            writer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
            return writer.writeToString(document);
        }
        catch (Exception e) {
            throw new CombinerRuntimeException(e);
        }
    }

    static {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            writer.getDomConfig().setParameter("xml-declaration", false);
        }
        catch (Exception e) {
            throw new CombinerRuntimeException(e);
        }
    }
}

